/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.core;

import java.io.File;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.sql.DataSource;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.dbflute.cbean.result.PagingResultBean;
import org.dbflute.hook.AccessContext;
import org.dbflute.hook.CallbackContext;
import org.dbflute.hook.SqlResultHandler;
import org.dbflute.hook.SqlResultInfo;
import org.dbflute.system.DBFluteSystem;
import org.dbflute.system.provider.DfCurrentDateProvider;
import org.dbflute.utflute.core.beanorder.BeanOrderValidator;
import org.dbflute.utflute.core.beanorder.ExpectedBeanOrderBy;
import org.dbflute.utflute.core.cannonball.CannonballDirector;
import org.dbflute.utflute.core.cannonball.CannonballOption;
import org.dbflute.utflute.core.cannonball.CannonballRun;
import org.dbflute.utflute.core.cannonball.CannonballStaff;
import org.dbflute.utflute.core.dbflute.GatheredExecutedSqlHolder;
import org.dbflute.utflute.core.exception.ExceptionExaminer;
import org.dbflute.utflute.core.exception.ExceptionExpectationAfter;
import org.dbflute.utflute.core.filesystem.FileLineHandler;
import org.dbflute.utflute.core.filesystem.FilesystemPlayer;
import org.dbflute.utflute.core.markhere.MarkHereManager;
import org.dbflute.utflute.core.policestory.PoliceStory;
import org.dbflute.utflute.core.policestory.javaclass.PoliceStoryJavaClassHandler;
import org.dbflute.utflute.core.policestory.jspfile.PoliceStoryJspFileHandler;
import org.dbflute.utflute.core.policestory.miscfile.PoliceStoryMiscFileHandler;
import org.dbflute.utflute.core.policestory.pjresource.PoliceStoryProjectResourceHandler;
import org.dbflute.utflute.core.policestory.webresource.PoliceStoryWebResourceHandler;
import org.dbflute.utflute.core.transaction.TransactionPerformFailureException;
import org.dbflute.utflute.core.transaction.TransactionPerformer;
import org.dbflute.utflute.core.transaction.TransactionResource;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.DfResourceUtil;
import org.dbflute.util.DfTypeUtil;
import org.dbflute.util.Srl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PlainTestCase
extends TestCase {
    private final Logger _xlogger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private MarkHereManager _xmarkHereManager;
    private String _xreservedTitle;
    private boolean _xuseGatheredExecutedSql;
    private boolean _xuseSwitchedCurrentDate;

    protected void setUp() throws Exception {
        this.xreserveShowTitle();
        if (!this.xisSuppressTestCaseAccessContext()) {
            this.initializeTestCaseAccessContext();
        }
        super.setUp();
    }

    protected void xreserveShowTitle() {
        this._xreservedTitle = "<<< " + this.xgetCaseDisp() + " >>>";
    }

    protected String xgetCaseDisp() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "." + this.getName() + "()";
    }

    protected void runTest() throws Throwable {
        try {
            super.runTest();
            this.postTest();
        }
        catch (Throwable e) {
            this.log("Failed to finish the test: " + this.xgetCaseDisp(), e);
            throw e;
        }
    }

    protected void postTest() {
    }

    protected void tearDown() throws Exception {
        this.xclearAccessContextOnThread();
        this.xclearGatheredExecutedSql();
        this.xclearSwitchedCurrentDate();
        this.xclearMark();
        super.tearDown();
    }

    protected Method getTestMethod() {
        String methodName = this.getName();
        try {
            return ((Object)((Object)this)).getClass().getMethod(methodName, null);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalStateException("Not found the method: " + methodName, e);
        }
    }

    protected void assertEquals(String message, int expected, Integer actual) {
        PlainTestCase.assertEquals((String)message, (Object)expected, (Object)actual);
    }

    protected void assertEquals(int expected, Integer actual) {
        PlainTestCase.assertEquals(null, (Object)expected, (Object)actual);
    }

    protected void assertTrueAll(boolean ... conditions) {
        int index = 0;
        for (boolean condition : conditions) {
            PlainTestCase.assertTrue((String)("conditions[" + index + "] expected: <true> but was: " + condition), (boolean)condition);
            ++index;
        }
    }

    protected void assertTrueAny(boolean ... conditions) {
        boolean hasTrue = false;
        for (boolean condition : conditions) {
            if (!condition) continue;
            hasTrue = true;
            break;
        }
        PlainTestCase.assertTrue((String)"all conditions were false", (boolean)hasTrue);
    }

    protected void assertFalseAll(boolean ... conditions) {
        int index = 0;
        for (boolean condition : conditions) {
            PlainTestCase.assertFalse((String)("conditions[" + index + "] expected: <false> but was: " + condition), (boolean)condition);
            ++index;
        }
    }

    protected void assertFalseAny(boolean ... conditions) {
        boolean hasFalse = false;
        for (boolean condition : conditions) {
            if (condition) continue;
            hasFalse = true;
            break;
        }
        PlainTestCase.assertTrue((String)"all conditions were true", (boolean)hasFalse);
    }

    protected void assertContains(String str, String keyword) {
        if (!Srl.contains((String)str, (String)keyword)) {
            this.log("Asserted string: " + str);
            PlainTestCase.fail((String)("the string should have the keyword but not found: " + keyword));
        }
    }

    protected void assertContainsIgnoreCase(String str, String keyword) {
        if (!Srl.containsIgnoreCase((String)str, (String)keyword)) {
            this.log("Asserted string: " + str);
            PlainTestCase.fail((String)("the string should have the keyword but not found: " + keyword));
        }
    }

    protected void assertContainsAll(String str, String ... keywords) {
        if (!Srl.containsAll((String)str, (String[])keywords)) {
            this.log("Asserted string: " + str);
            PlainTestCase.fail((String)("the string should have all keywords but not found: " + this.newArrayList(keywords)));
        }
    }

    protected void assertContainsAllIgnoreCase(String str, String ... keywords) {
        if (!Srl.containsAllIgnoreCase((String)str, (String[])keywords)) {
            this.log("Asserted string: " + str);
            PlainTestCase.fail((String)("the string should have all keywords but not found: " + this.newArrayList(keywords)));
        }
    }

    protected void assertContainsAny(String str, String ... keywords) {
        if (!Srl.containsAny((String)str, (String[])keywords)) {
            this.log("Asserted string: " + str);
            PlainTestCase.fail((String)("the string should have any keyword but not found: " + this.newArrayList(keywords)));
        }
    }

    protected void assertContainsAnyIgnoreCase(String str, String ... keywords) {
        if (!Srl.containsAnyIgnoreCase((String)str, (String[])keywords)) {
            this.log("Asserted string: " + str);
            PlainTestCase.fail((String)("the string should have any keyword but not found: " + this.newArrayList(keywords)));
        }
    }

    protected void assertNotContains(String str, String keyword) {
        if (Srl.contains((String)str, (String)keyword)) {
            this.log("Asserted string: " + str);
            PlainTestCase.fail((String)("the string should not have the keyword but found: " + keyword));
        }
    }

    protected void assertNotContainsIgnoreCase(String str, String keyword) {
        if (Srl.containsIgnoreCase((String)str, (String)keyword)) {
            this.log("Asserted string: " + str);
            PlainTestCase.fail((String)("the string should not have the keyword but found: " + keyword));
        }
    }

    protected void assertContainsKeyword(Collection<String> strList, String keyword) {
        if (!Srl.containsKeyword(strList, (String)keyword)) {
            PlainTestCase.fail((String)("the list should have the keyword but not found: " + keyword));
        }
    }

    protected void assertContainsKeywordAll(Collection<String> strList, String ... keywords) {
        if (!Srl.containsKeywordAll(strList, (String[])keywords)) {
            PlainTestCase.fail((String)("the list should have all keywords but not found: " + this.newArrayList(keywords)));
        }
    }

    protected void assertContainsKeywordAllIgnoreCase(Collection<String> strList, String ... keywords) {
        if (!Srl.containsKeywordAllIgnoreCase(strList, (String[])keywords)) {
            PlainTestCase.fail((String)("the list should have all keywords (case ignored) but not found: " + this.newArrayList(keywords)));
        }
    }

    protected void assertContainsKeywordAny(Collection<String> strList, String ... keywords) {
        if (!Srl.containsKeywordAny(strList, (String[])keywords)) {
            PlainTestCase.fail((String)("the list should have any keyword but not found: " + this.newArrayList(keywords)));
        }
    }

    protected void assertContainsKeywordAnyIgnoreCase(Collection<String> strList, String ... keywords) {
        if (!Srl.containsKeywordAnyIgnoreCase(strList, (String[])keywords)) {
            PlainTestCase.fail((String)("the list should have any keyword (case ignored) but not found: " + this.newArrayList(keywords)));
        }
    }

    protected void assertHasAnyElement(Collection<?> notEmptyList) {
        if (notEmptyList.isEmpty()) {
            PlainTestCase.fail((String)"the list should have any element (not empty) but empty.");
        }
    }

    protected void assertHasOnlyOneElement(Collection<?> lonelyList) {
        if (lonelyList.size() != 1) {
            PlainTestCase.fail((String)("the list should have the only one element but: " + lonelyList));
        }
    }

    protected void assertHasPluralElement(Collection<?> crowdedList) {
        if (crowdedList.size() < 2) {
            PlainTestCase.fail((String)("the list should have plural elements but: " + crowdedList));
        }
    }

    protected void assertHasZeroElement(Collection<?> emptyList) {
        if (!emptyList.isEmpty()) {
            PlainTestCase.fail((String)("the list should have zero element (empty) but: " + emptyList));
        }
    }

    protected <CAUSE extends Throwable> ExceptionExpectationAfter<CAUSE> assertException(Class<CAUSE> exceptionType, ExceptionExaminer noArgInLambda) {
        PlainTestCase.assertNotNull(exceptionType);
        String expected = exceptionType.getSimpleName();
        Throwable cause = null;
        try {
            noArgInLambda.examine();
        }
        catch (Throwable e) {
            cause = e;
            Class<?> causeClass = cause.getClass();
            String exp = this.buildExceptionSimpleExp(cause);
            if (!exceptionType.isAssignableFrom(causeClass)) {
                String actual = causeClass.getSimpleName();
                this.log("*Different exception, expected: {} but...", exceptionType.getName(), cause);
                PlainTestCase.fail((String)("*Different exception, expected: " + expected + " but: " + actual + " => " + exp));
            }
            this.log("expected: " + exp);
        }
        if (cause == null) {
            PlainTestCase.fail((String)("*No exception, expected: " + expected));
        }
        Throwable castCause = cause;
        return new ExceptionExpectationAfter<Throwable>(castCause);
    }

    private String buildExceptionSimpleExp(Throwable cause) {
        StringBuilder sb = new StringBuilder();
        String firstMsg = cause.getMessage();
        boolean line = firstMsg != null && firstMsg.contains(this.ln());
        sb.append("(").append(cause.getClass().getSimpleName()).append(")").append(firstMsg);
        Throwable secondCause = cause.getCause();
        if (secondCause != null) {
            String secondMsg = secondCause.getMessage();
            line = line || secondMsg != null && secondMsg.contains(this.ln());
            sb.append(line ? this.ln() : " / ");
            sb.append("(").append(secondCause.getClass().getSimpleName()).append(")").append(secondMsg);
            Throwable thirdCause = secondCause.getCause();
            if (thirdCause != null) {
                String thirdMsg = thirdCause.getMessage();
                line = line || thirdMsg != null && thirdMsg.contains(this.ln());
                sb.append(line ? this.ln() : " / ");
                sb.append("(").append(thirdCause.getClass().getSimpleName()).append(")").append(thirdMsg);
            }
        }
        String whole = sb.toString();
        return (whole.contains(this.ln()) ? this.ln() : "") + whole;
    }

    protected <BEAN> void assertOrder(List<BEAN> beanList, Consumer<ExpectedBeanOrderBy<BEAN>> oneArgLambda) {
        PlainTestCase.assertNotNull(beanList);
        PlainTestCase.assertNotNull(oneArgLambda);
        this.assertHasAnyElement(beanList);
        new BeanOrderValidator<BEAN>(oneArgLambda).validateOrder(beanList, vio -> PlainTestCase.fail((String)("[Order Failure] " + vio)));
    }

    protected void markHere(String mark) {
        PlainTestCase.assertNotNull((Object)mark);
        this.xgetMarkHereManager().mark(mark);
    }

    protected void assertMarked(String mark) {
        PlainTestCase.assertNotNull((Object)mark);
        this.xgetMarkHereManager().assertMarked(mark);
    }

    protected boolean isMarked(String mark) {
        PlainTestCase.assertNotNull((Object)mark);
        return this.xgetMarkHereManager().isMarked(mark);
    }

    protected MarkHereManager xgetMarkHereManager() {
        if (this._xmarkHereManager == null) {
            this._xmarkHereManager = new MarkHereManager();
        }
        return this._xmarkHereManager;
    }

    protected boolean xhasMarkHereManager() {
        return this._xmarkHereManager != null;
    }

    protected void xdestroyMarkHereManager() {
        this._xmarkHereManager = null;
    }

    protected void xclearMark() {
        if (this.xhasMarkHereManager()) {
            this.xgetMarkHereManager().checkNonAssertedMark();
            this.xgetMarkHereManager().clearMarkMap();
            this.xdestroyMarkHereManager();
        }
    }

    protected void log(Object ... msgs) {
        Object lastElement;
        if (msgs == null) {
            throw new IllegalArgumentException("The argument 'msgs' should not be null.");
        }
        Throwable cause = null;
        int arrayLength = msgs.length;
        if (arrayLength > 0 && (lastElement = msgs[arrayLength - 1]) instanceof Throwable) {
            cause = (Throwable)lastElement;
        }
        StringBuilder sb = new StringBuilder();
        int index = 0;
        int skipCount = 0;
        for (Object msg : msgs) {
            String appended;
            if (index == arrayLength - 1 && cause != null) break;
            if (skipCount > 0) {
                --skipCount;
                continue;
            }
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if (msg instanceof Timestamp) {
                appended = this.toString(msg, "yyyy/MM/dd HH:mm:ss.SSS");
            } else if (msg instanceof Date) {
                appended = this.toString(msg, "yyyy/MM/dd");
            } else {
                String strMsg = msg != null ? msg.toString() : null;
                skipCount = 0;
                for (int nextIndex = index + 1; strMsg != null && strMsg.contains("{}") && arrayLength > nextIndex; ++nextIndex) {
                    Object nextObj = msgs[nextIndex];
                    String replacement = nextObj != null ? Srl.replace((String)Srl.replace((String)nextObj.toString(), (String)"\\", (String)"\\\\"), (String)"$", (String)"\\$") : "null";
                    strMsg = strMsg.replaceFirst("\\{\\}", replacement);
                    ++skipCount;
                }
                appended = strMsg;
            }
            sb.append(appended);
            ++index;
        }
        String msg = sb.toString();
        if (this._xreservedTitle != null) {
            this._xlogger.debug("");
            this._xlogger.debug(this._xreservedTitle);
            this._xreservedTitle = null;
        }
        if (cause != null) {
            this._xlogger.debug(msg, cause);
        } else {
            this._xlogger.debug(msg);
        }
    }

    protected void showList(List<?> ... list) {
        int count = 1;
        for (List<?> ls : list) {
            this.log("[list" + count + "]");
            for (Object entity : ls) {
                this.log("  " + entity);
            }
            ++count;
        }
    }

    protected void showPage(PagingResultBean<?> ... pages) {
        int count = 1;
        for (PagingResultBean<?> page : pages) {
            this.log("[page" + count + "]");
            for (Object entity : page) {
                this.log("  " + entity);
            }
            ++count;
        }
    }

    protected String replace(String str, String fromStr, String toStr) {
        return Srl.replace((String)str, (String)fromStr, (String)toStr);
    }

    protected List<String> splitList(String str, String delimiter) {
        return Srl.splitList((String)str, (String)delimiter);
    }

    protected List<String> splitListTrimmed(String str, String delimiter) {
        return Srl.splitListTrimmed((String)str, (String)delimiter);
    }

    protected String toString(Object obj) {
        return DfTypeUtil.toString((Object)obj);
    }

    protected String toString(Object obj, String pattern) {
        return DfTypeUtil.toString((Object)obj, (String)pattern);
    }

    protected Integer toInteger(Object obj) {
        return DfTypeUtil.toInteger((Object)obj);
    }

    protected Long toLong(Object obj) {
        return DfTypeUtil.toLong((Object)obj);
    }

    protected BigDecimal toBigDecimal(Object obj) {
        return DfTypeUtil.toBigDecimal((Object)obj);
    }

    protected LocalDate currentLocalDate() {
        return this.toLocalDate(this.currentUtilDate());
    }

    protected LocalDateTime currentLocalDateTime() {
        return this.toLocalDateTime(this.currentUtilDate());
    }

    protected LocalTime currentLocalTime() {
        return this.toLocalTime(this.currentUtilDate());
    }

    protected Date currentDate() {
        return this.currentUtilDate();
    }

    protected Date currentUtilDate() {
        return DBFluteSystem.currentDate();
    }

    protected Timestamp currentTimestamp() {
        return new Timestamp(DBFluteSystem.currentTimeMillis());
    }

    protected LocalDate toLocalDate(Object obj) {
        return DfTypeUtil.toLocalDate((Object)obj, (TimeZone)this.getUnitTimeZone());
    }

    protected LocalDateTime toLocalDateTime(Object obj) {
        return DfTypeUtil.toLocalDateTime((Object)obj, (TimeZone)this.getUnitTimeZone());
    }

    protected LocalTime toLocalTime(Object obj) {
        return DfTypeUtil.toLocalTime((Object)obj, (TimeZone)this.getUnitTimeZone());
    }

    protected Date toDate(Object obj) {
        return this.toUtilDate(obj);
    }

    protected Date toUtilDate(Object obj) {
        return DfTypeUtil.toDate((Object)obj);
    }

    protected Timestamp toTimestamp(Object obj) {
        return DfTypeUtil.toTimestamp((Object)obj);
    }

    protected TimeZone getUnitTimeZone() {
        return DBFluteSystem.getFinalTimeZone();
    }

    protected <ELEMENT> ArrayList<ELEMENT> newArrayList() {
        return DfCollectionUtil.newArrayList();
    }

    public <ELEMENT> ArrayList<ELEMENT> newArrayList(Collection<ELEMENT> elements) {
        return DfCollectionUtil.newArrayList(elements);
    }

    protected <ELEMENT> ArrayList<ELEMENT> newArrayList(ELEMENT ... elements) {
        return DfCollectionUtil.newArrayList((Object[])elements);
    }

    protected <ELEMENT> HashSet<ELEMENT> newHashSet() {
        return DfCollectionUtil.newHashSet();
    }

    protected <ELEMENT> HashSet<ELEMENT> newHashSet(Collection<ELEMENT> elements) {
        return DfCollectionUtil.newHashSet(elements);
    }

    protected <ELEMENT> HashSet<ELEMENT> newHashSet(ELEMENT ... elements) {
        return DfCollectionUtil.newHashSet((Object[])elements);
    }

    protected <ELEMENT> LinkedHashSet<ELEMENT> newLinkedHashSet() {
        return DfCollectionUtil.newLinkedHashSet();
    }

    protected <ELEMENT> LinkedHashSet<ELEMENT> newLinkedHashSet(Collection<ELEMENT> elements) {
        return DfCollectionUtil.newLinkedHashSet(elements);
    }

    protected <ELEMENT> LinkedHashSet<ELEMENT> newLinkedHashSet(ELEMENT ... elements) {
        return DfCollectionUtil.newLinkedHashSet((Object[])elements);
    }

    protected <KEY, VALUE> HashMap<KEY, VALUE> newHashMap() {
        return DfCollectionUtil.newHashMap();
    }

    protected <KEY, VALUE> HashMap<KEY, VALUE> newHashMap(KEY key, VALUE value) {
        return DfCollectionUtil.newHashMap(key, value);
    }

    protected <KEY, VALUE> HashMap<KEY, VALUE> newHashMap(KEY key1, VALUE value1, KEY key2, VALUE value2) {
        return DfCollectionUtil.newHashMap(key1, value1, key2, value2);
    }

    protected <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMap() {
        return DfCollectionUtil.newLinkedHashMap();
    }

    protected <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMap(KEY key, VALUE value) {
        return DfCollectionUtil.newLinkedHashMap(key, value);
    }

    protected <KEY, VALUE> LinkedHashMap<KEY, VALUE> newLinkedHashMap(KEY key1, VALUE value1, KEY key2, VALUE value2) {
        return DfCollectionUtil.newLinkedHashMap(key1, value1, key2, value2);
    }

    protected String ln() {
        return "\n";
    }

    protected TransactionResource beginNewTransaction() {
        return null;
    }

    protected void commitTransaction(TransactionResource resource) {
    }

    protected void rollbackTransaction(TransactionResource resource) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void performNewTransaction(TransactionPerformer performer) {
        Exception cause;
        block30: {
            boolean commit;
            TransactionResource resource;
            block29: {
                PlainTestCase.assertNotNull((Object)performer);
                resource = this.beginNewTransaction();
                cause = null;
                commit = false;
                commit = performer.perform();
                if (!commit || cause != null) break block29;
                try {
                    this.commitTransaction(resource);
                }
                catch (RuntimeException e) {
                    cause = e;
                }
                break block30;
            }
            try {
                this.rollbackTransaction(resource);
            }
            catch (RuntimeException e) {
                if (cause != null) {
                    this.log(e.getMessage());
                    break block30;
                }
                cause = e;
            }
            break block30;
            catch (RuntimeException e) {
                block31: {
                    cause = e;
                    if (!commit || cause != null) break block31;
                    try {
                        this.commitTransaction(resource);
                    }
                    catch (RuntimeException e2) {
                        cause = e2;
                    }
                }
                try {
                    this.rollbackTransaction(resource);
                }
                catch (RuntimeException e3) {
                    if (cause != null) {
                        this.log(e3.getMessage());
                        break block30;
                    }
                    cause = e3;
                }
            }
            catch (SQLException e2) {
                block32: {
                    cause = e2;
                    if (!commit || cause != null) break block32;
                    {
                        catch (Throwable throwable) {
                            block33: {
                                if (commit && cause == null) {
                                    try {
                                        this.commitTransaction(resource);
                                    }
                                    catch (RuntimeException e4) {
                                        cause = e4;
                                    }
                                } else {
                                    try {
                                        this.rollbackTransaction(resource);
                                    }
                                    catch (RuntimeException e5) {
                                        if (cause != null) {
                                            this.log(e5.getMessage());
                                            break block33;
                                        }
                                        cause = e5;
                                    }
                                }
                            }
                            throw throwable;
                        }
                    }
                    try {
                        this.commitTransaction(resource);
                    }
                    catch (RuntimeException e6) {
                        cause = e6;
                    }
                }
                try {
                    this.rollbackTransaction(resource);
                }
                catch (RuntimeException e7) {
                    if (cause != null) {
                        this.log(e7.getMessage());
                        break block30;
                    }
                    cause = e7;
                }
            }
        }
        if (cause != null) {
            String msg = "Failed to perform the process in transaction: " + performer;
            throw new TransactionPerformFailureException(msg, cause);
        }
    }

    protected void xassertTransactionResourceNotNull(TransactionResource resource) {
        if (resource == null) {
            String msg = "The argument 'resource' should not be null.";
            throw new IllegalArgumentException(msg);
        }
    }

    protected DataSource getDataSource() {
        return null;
    }

    protected void cannonball(CannonballRun run, CannonballOption option) {
        PlainTestCase.assertNotNull((Object)run);
        PlainTestCase.assertNotNull((Object)option);
        this.createCannonballDirector().readyGo(run, option);
    }

    protected CannonballDirector createCannonballDirector() {
        return this.newCannonballDirector(this.xcreateCannonballStaff());
    }

    protected CannonballDirector newCannonballDirector(CannonballStaff cannonballStaff) {
        return new CannonballDirector(cannonballStaff);
    }

    protected CannonballStaff xcreateCannonballStaff() {
        return new CannonballStaff(){

            @Override
            public void help_prepareBeginning() {
                PlainTestCase.this.xprepareCannonballBeginning();
            }

            @Override
            public void help_prepareAccessContext() {
                PlainTestCase.this.xprepareCannonballAccessContext();
            }

            @Override
            public TransactionResource help_beginTransaction() {
                return PlainTestCase.this.beginNewTransaction();
            }

            @Override
            public void help_clearAccessContext() {
                PlainTestCase.this.xclearAccessContextOnThread();
            }

            @Override
            public void help_assertEquals(Object expected, Object actual) {
                Assert.assertEquals((Object)expected, (Object)actual);
            }

            @Override
            public void help_fail(String msg) {
                Assert.fail((String)msg);
            }

            @Override
            public void help_log(Object ... msgs) {
                PlainTestCase.this.log(msgs);
            }

            @Override
            public String help_ln() {
                return PlainTestCase.this.ln();
            }
        };
    }

    protected void xprepareCannonballBeginning() {
    }

    protected void xprepareCannonballAccessContext() {
        this.xputTestCaseAccessContextOnThread();
    }

    protected void sleep(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            String msg = "Failed to sleep but I want to sleep here...Zzz...";
            throw new IllegalStateException(msg, e);
        }
    }

    public void policeStoryOfJavaClassChase(PoliceStoryJavaClassHandler handler) {
        PlainTestCase.assertNotNull((Object)handler);
        this.createPoliceStory().chaseJavaClass(handler);
    }

    public void policeStoryOfJspFileChase(PoliceStoryJspFileHandler handler) {
        PlainTestCase.assertNotNull((Object)handler);
        this.createPoliceStory().chaseJspFile(handler);
    }

    public void policeStoryOfMiscFileChase(PoliceStoryMiscFileHandler handler, File baseDir) {
        PlainTestCase.assertNotNull((Object)handler);
        PlainTestCase.assertNotNull((Object)baseDir);
        this.createPoliceStory().chaseMiscFile(handler, baseDir);
    }

    public void policeStoryOfProjectResourceChase(PoliceStoryProjectResourceHandler handler) {
        PlainTestCase.assertNotNull((Object)handler);
        this.createPoliceStory().chaseProjectResource(handler);
    }

    public void policeStoryOfWebResourceChase(PoliceStoryWebResourceHandler handler) {
        PlainTestCase.assertNotNull((Object)handler);
        this.createPoliceStory().chaseWebResource(handler);
    }

    protected PoliceStory createPoliceStory() {
        return this.newPoliceStory((Object)this, this.getProjectDir());
    }

    protected PoliceStory newPoliceStory(Object testCase, File projectDir) {
        return new PoliceStory(testCase, projectDir);
    }

    protected void readLine(File textFile, String encoding, FileLineHandler handler) {
        PlainTestCase.assertNotNull((Object)textFile);
        PlainTestCase.assertNotNull((Object)encoding);
        PlainTestCase.assertNotNull((Object)handler);
        FilesystemPlayer reader = this.createFilesystemPlayer();
        reader.readLine(textFile, encoding, handler);
    }

    protected FilesystemPlayer createFilesystemPlayer() {
        return new FilesystemPlayer();
    }

    protected File getProjectDir() {
        Set<String> markSet = this.defineProjectDirMarkSet();
        for (File dir = this.getTestCaseBuildDir(); dir != null; dir = dir.getParentFile()) {
            if (!dir.isDirectory() || !Arrays.stream(dir.listFiles()).anyMatch(file -> markSet.contains(file.getName()))) continue;
            return dir;
        }
        throw new IllegalStateException("Not found the project dir marks: " + markSet);
    }

    protected Set<String> defineProjectDirMarkSet() {
        return DfCollectionUtil.newHashSet((Object[])new String[]{"build.xml", "pom.xml", "build.gradle", ".project", ".idea"});
    }

    protected File getTestCaseBuildDir() {
        return DfResourceUtil.getBuildDir(((Object)((Object)this)).getClass());
    }

    protected boolean xisSuppressTestCaseAccessContext() {
        return false;
    }

    protected void initializeTestCaseAccessContext() {
        this.xputTestCaseAccessContextOnThread();
    }

    protected void xputTestCaseAccessContextOnThread() {
        AccessContext.setAccessContextOnThread((AccessContext)this.createTestCaseAccessContext());
    }

    protected AccessContext createTestCaseAccessContext() {
        AccessContext context = new AccessContext();
        context.setAccessLocalDate(this.currentLocalDate());
        context.setAccessLocalDateTime(this.currentLocalDateTime());
        context.setAccessTimestamp(this.currentTimestamp());
        context.setAccessDate(this.currentUtilDate());
        context.setAccessUser(Thread.currentThread().getName());
        context.setAccessProcess(((Object)((Object)this)).getClass().getSimpleName());
        context.setAccessModule(((Object)((Object)this)).getClass().getSimpleName());
        return context;
    }

    protected AccessContext getAccessContext() {
        return AccessContext.getAccessContextOnThread();
    }

    protected void xclearAccessContextOnThread() {
        AccessContext.clearAccessContextOnThread();
    }

    protected GatheredExecutedSqlHolder gatherExecutedSql() {
        this._xuseGatheredExecutedSql = true;
        final GatheredExecutedSqlHolder holder = new GatheredExecutedSqlHolder();
        CallbackContext.setSqlResultHandlerOnThread((SqlResultHandler)new SqlResultHandler(){

            public void handle(SqlResultInfo info) {
                holder.addSqlResultInfo(info);
            }
        });
        return holder;
    }

    protected void xclearGatheredExecutedSql() {
        if (this._xuseGatheredExecutedSql) {
            CallbackContext.clearSqlResultHandlerOnThread();
        }
    }

    protected void switchCurrentDate(final Supplier<LocalDateTime> dateTimeSupplier) {
        PlainTestCase.assertNotNull(dateTimeSupplier);
        if (DBFluteSystem.hasCurrentDateProvider()) {
            String msg = "The current date provider already exists, cannot use new provider: " + dateTimeSupplier;
            throw new IllegalStateException(msg);
        }
        this._xuseSwitchedCurrentDate = true;
        DBFluteSystem.unlock();
        DBFluteSystem.setCurrentDateProvider((DfCurrentDateProvider)new DfCurrentDateProvider(){

            public long currentTimeMillis() {
                LocalDateTime currentDateTime = (LocalDateTime)dateTimeSupplier.get();
                Assert.assertNotNull((Object)currentDateTime);
                return DfTypeUtil.toDate((Object)currentDateTime).getTime();
            }
        });
    }

    protected void xclearSwitchedCurrentDate() {
        if (this._xuseSwitchedCurrentDate) {
            DBFluteSystem.unlock();
            DBFluteSystem.setCurrentDateProvider(null);
        }
    }

    protected Logger xgetLogger() {
        return this._xlogger;
    }

    protected String xgetReservedTitle() {
        return this._xreservedTitle;
    }

    protected void xsetReservedTitle(String reservedTitle) {
        this._xreservedTitle = reservedTitle;
    }

    public boolean xisUseSwitchedCurrentDate() {
        return this._xuseSwitchedCurrentDate;
    }
}

