/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.core.binding;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.dbflute.helper.beans.DfBeanDesc;
import org.dbflute.helper.beans.DfPropertyDesc;
import org.dbflute.helper.beans.factory.DfBeanDescFactory;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.utflute.core.binding.BindingAnnotationRule;
import org.dbflute.utflute.core.binding.BindingRuleProvider;
import org.dbflute.utflute.core.binding.BoundResult;
import org.dbflute.utflute.core.binding.ComponentProvider;
import org.dbflute.utflute.core.binding.NonBindingDeterminer;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.DfReflectionUtil;
import org.dbflute.util.Srl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentBinder {
    private static final Logger _logger = LoggerFactory.getLogger(ComponentBinder.class);
    protected final ComponentProvider _componentProvider;
    protected final BindingRuleProvider _bindingAnnotationProvider;
    protected final Map<Class<? extends Annotation>, BindingAnnotationRule> _bindingAnnotationRuleMap;
    protected Class<?> _terminalSuperClass;
    protected boolean _annotationOnlyBinding;
    protected boolean _byTypeInterfaceOnly;
    protected boolean _looseBinding;
    protected boolean _overridingBinding;
    protected final List<Object> _mockInstanceList = DfCollectionUtil.newArrayList();
    protected final List<Class<?>> _nonBindingTypeList = DfCollectionUtil.newArrayList();
    protected final Map<Class<?>, Object> _nestedBindingMap = DfCollectionUtil.newHashMap();

    public ComponentBinder(ComponentProvider componentProvider, BindingRuleProvider bindingAnnotationProvider) {
        this._componentProvider = componentProvider;
        this._bindingAnnotationProvider = bindingAnnotationProvider;
        this._bindingAnnotationRuleMap = this._bindingAnnotationProvider.provideBindingAnnotationRuleMap();
    }

    public void stopBindingAtSuper(Class<?> terminalSuperClass) {
        this._terminalSuperClass = terminalSuperClass;
    }

    public void annotationOnlyBinding() {
        this._annotationOnlyBinding = true;
    }

    public void cancelAnnotationOnlyBinding() {
        this._annotationOnlyBinding = false;
    }

    public void byTypeInterfaceOnly() {
        this._byTypeInterfaceOnly = true;
    }

    public void cancelByTypeInterfaceOnly() {
        this._byTypeInterfaceOnly = false;
    }

    public void looseBinding() {
        this._looseBinding = true;
    }

    public void cancelLooseBinding() {
        this._looseBinding = false;
    }

    public void overridingBinding() {
        this._overridingBinding = true;
    }

    public void cancelOverridingBinding() {
        this._overridingBinding = false;
    }

    public void addMockInstance(Object mockInstance) {
        if (mockInstance == null) {
            String msg = "The argument 'mockInstance' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        this._mockInstanceList.add(mockInstance);
    }

    public void addNonBindingType(Class<?> nonBindingType) {
        if (nonBindingType == null) {
            String msg = "The argument 'nonBindingType' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        this._nonBindingTypeList.add(nonBindingType);
    }

    public void addNestedBindingComponent(Class<?> bindingType, Object component) {
        if (bindingType == null) {
            String msg = "The argument 'bindingType' should not be null.";
            throw new IllegalArgumentException(msg);
        }
        this._nestedBindingMap.put(bindingType, component);
    }

    protected void inheritParentBinderOption(ComponentBinder binder) {
        binder._terminalSuperClass = this._terminalSuperClass;
        binder._annotationOnlyBinding = this._annotationOnlyBinding;
        binder._byTypeInterfaceOnly = this._byTypeInterfaceOnly;
        binder._looseBinding = this._looseBinding;
        binder._overridingBinding = this._overridingBinding;
        binder._mockInstanceList.addAll(this._mockInstanceList);
        binder._nonBindingTypeList.addAll(this._nonBindingTypeList);
        binder._nestedBindingMap.putAll(this._nestedBindingMap);
    }

    public BoundResult bindComponent(Object bean) {
        BoundResult boundResult = new BoundResult(bean);
        this.doBindFieldComponent(bean, boundResult);
        this.doBindPropertyComponent(bean, boundResult);
        return boundResult;
    }

    protected void doBindFieldComponent(Object bean, BoundResult boundResult) {
        for (Class<?> clazz = bean.getClass(); this.isBindTargetClass(clazz) && clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                this.fireFieldBinding(bean, field, boundResult);
            }
        }
    }

    protected void fireFieldBinding(Object bean, Field field, BoundResult boundResult) {
        if (!this.isModifiersAutoBindable(field)) {
            return;
        }
        Annotation bindingAnno = this.findBindingAnnotation(field);
        if (bindingAnno != null || this._looseBinding) {
            field.setAccessible(true);
            Class<?> fieldType = field.getType();
            if (this.isNonBindingType(fieldType)) {
                return;
            }
            if (this.isNonBindingAnnotation(bindingAnno)) {
                return;
            }
            if (!this._overridingBinding && this.getFieldValue(field, bean) != null) {
                return;
            }
            Object component = this.findInjectedComponent(field.getName(), fieldType, bindingAnno, boundResult);
            if (component != null) {
                Object existing = this.extractExistingFieldValue(bean, field);
                this.setFieldValue(field, bean, component);
                boundResult.addBoundField(field, existing);
            }
        }
    }

    protected boolean isModifiersAutoBindable(Field field) {
        int modifiers = field.getModifiers();
        return !Modifier.isStatic(modifiers) && !Modifier.isFinal(modifiers) && !field.getType().isPrimitive();
    }

    protected Object extractExistingFieldValue(Object bean, Field field) {
        return DfReflectionUtil.getValueForcedly((Field)field, (Object)bean);
    }

    protected void doBindPropertyComponent(Object bean, BoundResult boundResult) {
        DfBeanDesc beanDesc = DfBeanDescFactory.getBeanDesc(bean.getClass());
        List proppertyNameList = beanDesc.getProppertyNameList();
        for (String propertyName : proppertyNameList) {
            this.firePropertyBinding(bean, beanDesc, propertyName, boundResult);
        }
    }

    protected void firePropertyBinding(Object bean, DfBeanDesc beanDesc, String propertyName, BoundResult boundResult) {
        DfPropertyDesc propertyDesc = beanDesc.getPropertyDesc(propertyName);
        if (!propertyDesc.isWritable()) {
            return;
        }
        Class propertyType = propertyDesc.getPropertyType();
        if (this.isNonBindingType(propertyType)) {
            return;
        }
        Method writeMethod = propertyDesc.getWriteMethod();
        if (writeMethod == null) {
            return;
        }
        Annotation bindingAnno = this.findBindingAnnotation(writeMethod);
        if (this._annotationOnlyBinding && bindingAnno == null) {
            return;
        }
        if (this.isNonBindingAnnotation(bindingAnno)) {
            return;
        }
        if (!this.isBindTargetClass(writeMethod.getDeclaringClass())) {
            return;
        }
        if (!this._overridingBinding && propertyDesc.isReadable() && propertyDesc.getValue(bean) != null) {
            return;
        }
        Object component = this.findInjectedComponent(propertyName, propertyType, bindingAnno, boundResult);
        if (component == null) {
            return;
        }
        Object existing = this.extractExistingPropertyValue(bean, propertyDesc);
        propertyDesc.setValue(bean, component);
        boundResult.addBoundProperty(propertyDesc, existing);
    }

    protected Object extractExistingPropertyValue(Object bean, DfPropertyDesc propertyDesc) {
        return propertyDesc.isReadable() ? propertyDesc.getValue(bean) : null;
    }

    protected Object findInjectedComponent(String propertyName, Class<?> propertyType, Annotation bindingAnno, BoundResult boundResult) {
        InjectedComponentContainer container = this.doFindInjectedComponent(propertyName, propertyType, bindingAnno);
        this.bindNestedBinding(container, boundResult);
        this.bindNestedMock(container, boundResult);
        return container.getInjected();
    }

    protected InjectedComponentContainer doFindInjectedComponent(String propertyName, Class<?> propertyType, Annotation bindingAnno) {
        Object mock = this.findMockInstance(propertyType);
        if (mock != null) {
            return InjectedComponentContainer.ofMock(mock);
        }
        if (this.isFindingByNameOnlyProperty(propertyName, propertyType, bindingAnno)) {
            return InjectedComponentContainer.of(this.doFindInjectedComponentByName(propertyName, propertyType, bindingAnno));
        }
        if (this.isFindingByTypeOnlyProperty(propertyName, propertyType, bindingAnno)) {
            return InjectedComponentContainer.of(this.doFindInjectedComponentByType(propertyType));
        }
        Object byName = this.doFindInjectedComponentByName(propertyName, propertyType, bindingAnno);
        return InjectedComponentContainer.of(byName != null ? byName : this.doFindInjectedComponentByType(propertyType));
    }

    protected Object findMockInstance(Class<?> type) {
        List<Object> mockInstanceList = this._mockInstanceList;
        for (Object mockInstance : mockInstanceList) {
            if (!type.isInstance(mockInstance)) continue;
            return mockInstance;
        }
        return null;
    }

    protected boolean isFindingByNameOnlyProperty(String propertyName, Class<?> propertyType, Annotation bindingAnno) {
        if (this._looseBinding) {
            return false;
        }
        if (this.isByNameOnlyAnnotation(bindingAnno)) {
            return true;
        }
        if (this.extractSpecifiedName(bindingAnno) != null) {
            return true;
        }
        return this.isLimitedPropertyAsByTypeInterfaceOnly(propertyName, propertyType);
    }

    protected boolean isLimitedPropertyAsByTypeInterfaceOnly(String propertyName, Class<?> propertyType) {
        return this._byTypeInterfaceOnly && !propertyType.isInterface();
    }

    protected boolean isFindingByTypeOnlyProperty(String propertyName, Class<?> propertyType, Annotation bindingAnno) {
        return this.isByTypeOnlyAnnotation(bindingAnno);
    }

    protected Object doFindInjectedComponentByName(String propertyName, Class<?> propertyType, Annotation bindingAnno) {
        String normalized;
        String filtered;
        String specifiedName = this.extractSpecifiedName(bindingAnno);
        String realName = specifiedName != null ? specifiedName : ((filtered = this._bindingAnnotationProvider.filterByBindingNamingRule(normalized = this.normalizeName(propertyName), propertyType)) != null ? filtered : normalized);
        return this.actuallyFindInjectedComponentByName(realName);
    }

    protected Object actuallyFindInjectedComponentByName(String name) {
        return this.hasComponent(name) ? this.getComponent(name) : null;
    }

    protected Object doFindInjectedComponentByType(Class<?> propertyType) {
        return this.hasComponent(propertyType) ? this.getComponent(propertyType) : null;
    }

    protected String normalizeName(String name) {
        if (this._looseBinding) {
            return name.startsWith("_") ? name.substring("_".length()) : name;
        }
        return name;
    }

    protected Annotation findBindingAnnotation(Field field) {
        return this.doFindBindingAnnotation(field.getAnnotations());
    }

    protected Annotation findBindingAnnotation(Method method) {
        return this.doFindBindingAnnotation(method.getAnnotations());
    }

    protected Annotation doFindBindingAnnotation(Annotation[] annotations) {
        if (annotations == null || this._bindingAnnotationRuleMap == null) {
            return null;
        }
        for (Annotation annotation : annotations) {
            if (!this._bindingAnnotationRuleMap.containsKey(annotation.annotationType())) continue;
            return annotation;
        }
        return null;
    }

    protected boolean isNonBindingAnnotation(Annotation bindingAnno) {
        BindingAnnotationRule rule = this.findBindingAnnotationRule(bindingAnno);
        if (rule == null) {
            return false;
        }
        NonBindingDeterminer determiner = rule.getNonBindingDeterminer();
        return determiner != null && determiner.isNonBinding(bindingAnno);
    }

    protected boolean isByNameOnlyAnnotation(Annotation bindingAnno) {
        BindingAnnotationRule rule = this.findBindingAnnotationRule(bindingAnno);
        return rule != null && rule.isByNameOnly();
    }

    protected boolean isByTypeOnlyAnnotation(Annotation bindingAnno) {
        BindingAnnotationRule rule = this.findBindingAnnotationRule(bindingAnno);
        return rule != null && rule.isByTypeOnly();
    }

    protected BindingAnnotationRule findBindingAnnotationRule(Annotation bindingAnno) {
        return bindingAnno != null ? this._bindingAnnotationRuleMap.get(bindingAnno.annotationType()) : null;
    }

    protected void bindNestedBinding(InjectedComponentContainer container, BoundResult boundResult) {
        Object injected = container.getInjected();
        if (injected == null || this._nestedBindingMap.isEmpty()) {
            return;
        }
        ComponentBinder binder = new ComponentBinder(new ComponentProvider(){

            @Override
            public <COMPONENT> COMPONENT provideComponent(String name) {
                return null;
            }

            @Override
            public <COMPONENT> COMPONENT provideComponent(Class<COMPONENT> type) {
                Object specified = ComponentBinder.this._nestedBindingMap.get(type);
                return (COMPONENT)(specified != null ? specified : null);
            }

            @Override
            public boolean existsComponent(String name) {
                return false;
            }

            @Override
            public boolean existsComponent(Class<?> type) {
                return this.provideComponent(type) != null;
            }
        }, this._bindingAnnotationProvider);
        this.inheritParentBinderOption(binder);
        binder._looseBinding = false;
        binder._overridingBinding = true;
        BoundResult nestedResult = binder.bindComponent(injected);
        boundResult.addNestedBoundResult(nestedResult);
    }

    protected void bindNestedMock(InjectedComponentContainer container, BoundResult boundResult) {
        Object injected = container.getInjected();
        if (injected == null || this._mockInstanceList.isEmpty()) {
            return;
        }
        ComponentBinder binder = new ComponentBinder(new ComponentProvider(){

            @Override
            public <COMPONENT> COMPONENT provideComponent(String name) {
                return null;
            }

            @Override
            public <COMPONENT> COMPONENT provideComponent(Class<COMPONENT> type) {
                return (COMPONENT)ComponentBinder.this.findMockInstance(type);
            }

            @Override
            public boolean existsComponent(String name) {
                return false;
            }

            @Override
            public boolean existsComponent(Class<?> type) {
                return this.provideComponent(type) != null;
            }
        }, this._bindingAnnotationProvider);
        this.inheritParentBinderOption(binder);
        binder._looseBinding = false;
        binder._overridingBinding = true;
        BoundResult nestedResult = binder.bindComponent(injected);
        boundResult.addNestedBoundResult(nestedResult);
    }

    public void revertBoundComponent(BoundResult boundResult) {
        this.doRevertBoundComponent(boundResult);
    }

    public void revertBoundComponent(List<BoundResult> boundResultList) {
        for (BoundResult boundResult : this.orderRevertedList(boundResultList)) {
            this.doRevertBoundComponent(boundResult);
        }
    }

    protected void doRevertBoundComponent(BoundResult boundResult) {
        Object bean = boundResult.getTargetBean();
        List<BoundResult.BoundField> boundFieldList = boundResult.getBoundFieldList();
        for (BoundResult.BoundField boundField : this.orderRevertedList(boundFieldList)) {
            try {
                boundField.getField().set(bean, boundField.getExisting());
            }
            catch (Exception continued) {
                _logger.debug("*Cannot release bound field: target=" + bean + ", field=" + boundField, (Throwable)continued);
            }
        }
        boundFieldList.clear();
        List<BoundResult.BoundProperty> boundPropertyList = boundResult.getBoundPropertyList();
        for (BoundResult.BoundProperty boundProperty : this.orderRevertedList(boundPropertyList)) {
            try {
                boundProperty.getPropertyDesc().setValue(bean, boundProperty.getExisting());
            }
            catch (Exception continued) {
                _logger.debug("*Cannot release bound property: target=" + bean + ", property=" + boundProperty, (Throwable)continued);
            }
        }
        boundPropertyList.clear();
        List<BoundResult> list = boundResult.getNestedBoundResultList();
        for (BoundResult nestedBoundResult : this.orderRevertedList(list)) {
            this.doRevertBoundComponent(nestedBoundResult);
        }
    }

    protected <ELEMENT> List<ELEMENT> orderRevertedList(List<ELEMENT> originalList) {
        ArrayList<ELEMENT> reversedList = new ArrayList<ELEMENT>(originalList);
        Collections.reverse(reversedList);
        return reversedList;
    }

    protected boolean isBindTargetClass(Class<?> clazz) {
        return this._terminalSuperClass == null || !clazz.isAssignableFrom(this._terminalSuperClass);
    }

    protected boolean isNonBindingType(Class<?> type) {
        List<Class<?>> nonBindingTypeList = this._nonBindingTypeList;
        for (Class<?> nonBindingType : nonBindingTypeList) {
            if (!nonBindingType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    protected String extractSpecifiedName(Annotation bindingAnnotation) {
        String specifiedName = null;
        if (bindingAnnotation instanceof Resource) {
            specifiedName = ((Resource)bindingAnnotation).name();
        }
        return Srl.is_NotNull_and_NotTrimmedEmpty(specifiedName) ? specifiedName : null;
    }

    protected Object getFieldValue(Field field, Object target) {
        try {
            return field.get(target);
        }
        catch (IllegalArgumentException e) {
            this.throwIllegalArgumentFieldGet(field, target, e);
            return null;
        }
        catch (IllegalAccessException e) {
            this.throwIllegalAccessFieldGet(field, target, e);
            return null;
        }
    }

    protected void throwIllegalArgumentFieldGet(Field field, Object target, IllegalArgumentException e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Illegal argument to get the field.");
        br.addItem("Field");
        br.addElement((Object)field);
        br.addItem("Target");
        br.addElement(target);
        String msg = br.buildExceptionMessage();
        throw new IllegalArgumentException(msg, e);
    }

    protected void throwIllegalAccessFieldGet(Field field, Object target, IllegalAccessException e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Illegal access to get the field.");
        br.addItem("Field");
        br.addElement((Object)field);
        br.addItem("Target");
        br.addElement(target);
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg, e);
    }

    protected void setFieldValue(Field field, Object target, Object value) {
        try {
            field.set(target, value);
        }
        catch (IllegalArgumentException e) {
            this.throwIllegalArgumentFieldSet(field, target, value, e);
        }
        catch (IllegalAccessException e) {
            this.throwIllegalAccessFieldSet(field, target, value, e);
        }
    }

    protected void throwIllegalArgumentFieldSet(Field field, Object target, Object value, IllegalArgumentException e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Illegal argument to set the field.");
        br.addItem("Field");
        br.addElement((Object)field);
        br.addItem("Target");
        br.addElement(target);
        br.addItem("Value");
        br.addElement(value != null ? value.getClass() : null);
        br.addElement(value);
        String msg = br.buildExceptionMessage();
        throw new IllegalArgumentException(msg, e);
    }

    protected void throwIllegalAccessFieldSet(Field field, Object target, Object value, IllegalAccessException e) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Illegal access to set the field.");
        br.addItem("Field");
        br.addElement((Object)field);
        br.addItem("Target");
        br.addElement(target);
        br.addItem("Value");
        br.addElement(value != null ? value.getClass() : null);
        br.addElement(value);
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg, e);
    }

    protected <COMPONENT> COMPONENT getComponent(Class<COMPONENT> type) {
        return this._componentProvider.provideComponent(type);
    }

    protected <COMPONENT> COMPONENT getComponent(String name) {
        return this._componentProvider.provideComponent(name);
    }

    protected boolean hasComponent(Class<?> type) {
        return this._componentProvider.existsComponent(type);
    }

    protected boolean hasComponent(String name) {
        return this._componentProvider.existsComponent(name);
    }

    protected static class InjectedComponentContainer {
        protected final Object injected;
        protected final boolean mocked;

        protected InjectedComponentContainer(Object injected, boolean mocked) {
            this.injected = injected;
            this.mocked = mocked;
        }

        public static InjectedComponentContainer of(Object injected) {
            return new InjectedComponentContainer(injected, false);
        }

        public static InjectedComponentContainer ofMock(Object mock) {
            return new InjectedComponentContainer(mock, true);
        }

        public Object getInjected() {
            return this.injected;
        }

        public boolean isMocked() {
            return this.mocked;
        }
    }
}

