/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.core.cannonball;

import junit.framework.AssertionFailedError;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.utflute.core.cannonball.CannonballDragon;
import org.dbflute.utflute.core.cannonball.CannonballLatch;
import org.dbflute.utflute.core.cannonball.CannonballLogger;
import org.dbflute.utflute.core.cannonball.CannonballProjectA;
import org.dbflute.utflute.core.cannonball.CannonballWatchingStatus;

public class CannonballCar {
    protected final long _threadId;
    protected final CannonballLatch _ourLatch;
    protected final int _entryNumber;
    protected final Object _lockObj;
    protected final int _countOfEntry;
    protected final CannonballLogger _logger;
    protected Object _runResult;
    protected Long _projectATimeLimit;
    protected boolean _suppressDecrementWhenBreakAway;

    public CannonballCar(long threadId, CannonballLatch ourLatch, int entryNumber, Object lockObj, int countOfEntry, CannonballLogger logger) {
        this._threadId = threadId;
        this._ourLatch = ourLatch;
        this._entryNumber = entryNumber;
        this._lockObj = lockObj;
        this._countOfEntry = countOfEntry;
        this._logger = logger;
    }

    public void teaBreak(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            String msg = "Failed to have a tea break but I want to...";
            throw new IllegalStateException(msg, e);
        }
    }

    public void restart() {
        this._ourLatch.await("df:defaultLatch", this.getEntryNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectA(CannonballProjectA projectA, int entryNumber) {
        CannonballWatchingStatus cannonballWatchingStatus;
        this.checkEntryNumber(entryNumber);
        String projectAKey = this.generateProjectAKey(projectA, entryNumber);
        this._ourLatch.lineUpProjectA(projectAKey, entryNumber, this.getEntryNumber());
        CannonballWatchingStatus watchingStatus = new CannonballWatchingStatus(projectAKey);
        CannonballDragon dragon = null;
        if (this.isEntryNumber(entryNumber)) {
            this._logger.log("...Executing projectA: " + entryNumber);
            dragon = this.createDragon(watchingStatus);
            dragon.releaseIfOvertime(this.getFallbackOvertimeLimit());
            this.executeProjectA(projectA, dragon);
            cannonballWatchingStatus = watchingStatus;
            synchronized (cannonballWatchingStatus) {
                watchingStatus.markDone();
            }
        }
        cannonballWatchingStatus = watchingStatus;
        synchronized (cannonballWatchingStatus) {
            boolean forcedly = watchingStatus.containsForcedly();
            if (!forcedly) {
                this._ourLatch.waitForProjectA(projectAKey, entryNumber, this.getEntryNumber());
            } else {
                this._ourLatch.comeBackFromOvertimeProjectA(projectAKey, entryNumber);
            }
            if (this.isEntryNumber(entryNumber)) {
                if (dragon.isExpectedNormallyDone() && forcedly) {
                    String msg = "expected: normally done, but was: the plan overtime: entryNumber=" + entryNumber;
                    throw new AssertionFailedError(msg);
                }
                if (dragon.isExpectedOvertime() && !forcedly) {
                    String msg = "expected: overtime, but was: the plan normally done: entryNumber=" + entryNumber;
                    throw new AssertionFailedError(msg);
                }
            }
        }
        this.teaBreak(100L);
    }

    protected int getFallbackOvertimeLimit() {
        return 3000;
    }

    protected String generateProjectAKey(CannonballProjectA projectA, int entryNumber) {
        return Integer.toHexString((projectA.getClass().getName() + String.valueOf(entryNumber)).hashCode());
    }

    protected CannonballDragon createDragon(CannonballWatchingStatus watchingStatus) {
        return new CannonballDragon(this, watchingStatus);
    }

    protected void executeProjectA(CannonballProjectA projectA, CannonballDragon dragon) {
        try {
            projectA.plan(dragon);
        }
        catch (RuntimeException e) {
            this.adjustDecrementWhenBreakAway();
            throw e;
        }
        catch (Error e) {
            this.adjustDecrementWhenBreakAway();
            throw e;
        }
    }

    protected void adjustDecrementWhenBreakAway() {
        this._suppressDecrementWhenBreakAway = true;
    }

    public boolean isEntryNumber(int entryNumber) {
        this.checkEntryNumber(entryNumber);
        return this._entryNumber == entryNumber;
    }

    protected void checkEntryNumber(int entryNumber) {
        if (entryNumber > this._countOfEntry) {
            this.throwCannonballEntryNumberOverException(entryNumber);
        }
    }

    protected void throwCannonballEntryNumberOverException(int entryNumber) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The entry number is over count of entries.");
        br.addItem("Entry Number");
        br.addElement((Object)entryNumber);
        br.addItem("Count of Entry");
        br.addElement((Object)this._countOfEntry);
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg);
    }

    public void goal(Object runResult) {
        this._runResult = runResult;
    }

    public String toString() {
        return "{" + this._threadId + ", " + this._entryNumber + "}";
    }

    public long getThreadId() {
        return this._threadId;
    }

    public CannonballLatch getOurLatch() {
        return this._ourLatch;
    }

    public int getEntryNumber() {
        return this._entryNumber;
    }

    public Object getLockObj() {
        return this._lockObj;
    }

    public CannonballLogger getLogger() {
        return this._logger;
    }

    public Object getRunResult() {
        return this._runResult;
    }

    public boolean isSuppressDecrementWhenBreakAway() {
        return this._suppressDecrementWhenBreakAway;
    }
}

