/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.core.cannonball;

import java.util.ArrayList;
import java.util.List;
import org.dbflute.utflute.core.cannonball.CannonballCar;
import org.dbflute.utflute.core.cannonball.CannonballLatch;
import org.dbflute.utflute.core.cannonball.CannonballWatchingStatus;

public class CannonballDragon {
    protected final CannonballCar _car;
    protected final CannonballWatchingStatus _watchingStatus;
    protected final List<CannonballWatcher> _watcherList = new ArrayList<CannonballWatcher>();
    protected final long _planBeginTime;
    protected boolean _expectedNormallyDone;
    protected boolean _expectedOvertime;

    public CannonballDragon(CannonballCar car, CannonballWatchingStatus watchingStatus) {
        this._car = car;
        this._watchingStatus = watchingStatus;
        this._planBeginTime = System.currentTimeMillis();
    }

    public CannonballDragon expectNormallyDone() {
        this._expectedNormallyDone = true;
        return this;
    }

    public CannonballDragon expectOvertime() {
        this._expectedOvertime = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseIfOvertime(long millis) {
        CannonballWatchingStatus cannonballWatchingStatus = this._watchingStatus;
        synchronized (cannonballWatchingStatus) {
            if (this.isWaiting()) {
                for (CannonballWatcher watcher : this._watcherList) {
                    watcher.close();
                }
                CannonballWatcher watcher = this.createWatcher(millis);
                this._watcherList.add(watcher);
                watcher.watch();
            }
        }
    }

    protected CannonballWatcher createWatcher(long millis) {
        return new CannonballWatcher(millis);
    }

    protected boolean isWaiting() {
        return this._watchingStatus.isWaiting();
    }

    public int getEntryNumber() {
        return this._car.getEntryNumber();
    }

    public boolean isExpectedNormallyDone() {
        return this._expectedNormallyDone;
    }

    public boolean isExpectedOvertime() {
        return this._expectedOvertime;
    }

    protected class CannonballWatcher {
        protected final long _millis;
        protected volatile boolean _closed;

        public CannonballWatcher(long millis) {
            this._millis = millis;
        }

        public void watch() {
            Thread watchingThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long alreadyPastTime = System.currentTimeMillis() - CannonballDragon.this._planBeginTime;
                    int splitCount = 10;
                    long tokenMillis = (CannonballWatcher.this._millis - alreadyPastTime) / 10L;
                    if (tokenMillis > 0L) {
                        for (int i = 0; i < 10; ++i) {
                            this.sleep(tokenMillis);
                            if (!CannonballWatcher.this._closed) continue;
                            return;
                        }
                    }
                    CannonballWatchingStatus cannonballWatchingStatus = CannonballDragon.this._watchingStatus;
                    synchronized (cannonballWatchingStatus) {
                        if (CannonballWatcher.this._closed) {
                            return;
                        }
                        if (CannonballDragon.this.isWaiting()) {
                            int entryNumber = CannonballDragon.this._car.getEntryNumber();
                            CannonballLatch ourLatch = CannonballDragon.this._car.getOurLatch();
                            ourLatch.leaveProjectAAlone(CannonballDragon.this._watchingStatus.getProjectAKey(), entryNumber);
                            CannonballDragon.this._watchingStatus.markForecdly();
                        }
                    }
                }

                protected void sleep(long millis) {
                    try {
                        Thread.sleep(millis);
                    }
                    catch (InterruptedException e) {
                        String msg = "Failed to have a tea break but I want to...";
                        throw new IllegalStateException(msg, e);
                    }
                }
            });
            watchingThread.start();
        }

        public void close() {
            this._closed = true;
        }
    }
}

