/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.core.cannonball;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dbflute.utflute.core.cannonball.CannonballLogger;
import org.dbflute.utflute.core.cannonball.CannonballVaryingLatch;

public class CannonballLatch {
    public static final String DEFAULT_LATCH_NAME = "df:defaultLatch";
    protected int _activeCount;
    protected final int _initialCount;
    protected final CannonballLogger _logger;
    protected final Map<String, CannonballVaryingLatch> _ourLatchMap = new ConcurrentHashMap<String, CannonballVaryingLatch>();

    public CannonballLatch(int threadCount, CannonballLogger logger) {
        this._activeCount = threadCount;
        this._initialCount = threadCount;
        this._logger = logger;
    }

    public void await(String latchName, int entryNumber) {
        this.doAwait(latchName, entryNumber, false);
    }

    public void awaitSilently(String latchName, int entryNumber) {
        this.doAwait(latchName, entryNumber, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAwait(String latchName, int entryNumber, boolean silently) {
        boolean last;
        CannonballVaryingLatch latch;
        CannonballLatch cannonballLatch = this;
        synchronized (cannonballLatch) {
            latch = this.prepareLatch(latchName);
            if (latch.isReleasedLatch()) {
                return;
            }
            last = latch.isLastCountLatch();
            if (last) {
                this.destroyLatchIfNeeds(latchName);
                if (!silently) {
                    this._logger.log("Ready...Go! (restart): entryNumber=" + entryNumber);
                }
            }
            latch.countDown();
        }
        if (!last && this.isWaitingLatch(latchName)) {
            if (!silently) {
                this._logger.log("...Awaiting arrivals: entryNumber=" + entryNumber + ", count=" + latch.getCount());
            }
            latch.await();
        }
    }

    protected synchronized CannonballVaryingLatch prepareLatch(String latchName) {
        CannonballVaryingLatch latch = this._ourLatchMap.get(latchName);
        if (latch == null) {
            latch = new CannonballVaryingLatch(this._activeCount);
            this._ourLatchMap.put(latchName, latch);
        }
        return latch;
    }

    protected synchronized boolean isWaitingLatch(String latchName) {
        CannonballVaryingLatch latch = this._ourLatchMap.get(latchName);
        return latch != null && latch.getCount() > 0L;
    }

    protected boolean isDefaultLatch(String latchName) {
        return DEFAULT_LATCH_NAME.equals(latchName);
    }

    protected synchronized CannonballVaryingLatch getDefaultLatch() {
        return this._ourLatchMap.get(DEFAULT_LATCH_NAME);
    }

    protected synchronized void destroyLatchIfNeeds(String latchName) {
        if (this.isDefaultLatch(latchName)) {
            this._ourLatchMap.remove(latchName);
        }
    }

    public void lineUpProjectA(String projectAKey, int executionNumber, int currenNumber) {
        this.awaitSilently(this.generateProjectALineUpLatchName(projectAKey), currenNumber);
    }

    protected String generateProjectALineUpLatchName(String projectAKey) {
        return projectAKey + "::lineUp";
    }

    public void waitForProjectA(String projectAKey, int executionNumber, int currenNumber) {
        this.awaitSilently(this.generateProjectAWaitForLatchName(projectAKey), currenNumber);
    }

    protected String generateProjectAWaitForLatchName(String projectAKey) {
        return projectAKey + "::waitFor";
    }

    public synchronized void leaveProjectAAlone(String projectAKey, int entryNumber) {
        this._logger.log("*Leaving the projectA car alone as overtime: entryNumber=" + entryNumber);
        this.decrementThreadCount();
        this.reset(this.generateProjectALineUpLatchName(projectAKey));
        this.reset(this.generateProjectAWaitForLatchName(projectAKey));
    }

    public synchronized void comeBackFromOvertimeProjectA(String projectAKey, int entryNumber) {
        CannonballVaryingLatch defaultLatch;
        this._logger.log("*Coming back from overtime projectA finally: entryNumber=" + entryNumber);
        this.incrementThreadCount();
        if (this.isWaitingLatch(DEFAULT_LATCH_NAME) && (defaultLatch = this.getDefaultLatch()) != null) {
            defaultLatch.incrementBufferCount();
        }
    }

    public synchronized void breakAway(int entryNumber, boolean suppressDecrement) {
        String decrementExp = !suppressDecrement ? "(decrement)" : "";
        this._logger.log("*Breaking away from cannonball race " + decrementExp + ": entryNumber=" + entryNumber);
        if (!suppressDecrement) {
            this.decrementThreadCount();
        }
        this.reset(DEFAULT_LATCH_NAME);
    }

    public synchronized void complete(int entryNumber, boolean suppressDecrement) {
        if (!suppressDecrement) {
            this.decrementThreadCountSilently();
        }
        this.reset(DEFAULT_LATCH_NAME);
    }

    public synchronized void reset(String latchName) {
        CannonballVaryingLatch latch = this._ourLatchMap.get(latchName);
        if (latch == null) {
            return;
        }
        long count = latch.getCount();
        if (count > 0L) {
            this._logger.log("...Resetting your latch: count=" + count);
            int i = 0;
            while ((long)i < count) {
                latch.countDown();
                ++i;
            }
            this.destroyLatchIfNeeds(latchName);
        }
    }

    protected synchronized void incrementThreadCount() {
        if (this._initialCount > this._activeCount) {
            this._logger.log("...Incrementing active thread count: " + this._activeCount + " to " + (this._activeCount + 1));
            ++this._activeCount;
        } else {
            this._logger.log("*Too many increment of thread count: first=" + this._initialCount + ", current=" + this._activeCount);
        }
    }

    protected synchronized void decrementThreadCount() {
        this.doDecrementThreadCount(false);
    }

    protected synchronized void decrementThreadCountSilently() {
        this.doDecrementThreadCount(true);
    }

    protected synchronized void doDecrementThreadCount(boolean silently) {
        if (this._activeCount > 0) {
            if (!silently) {
                this._logger.log("...Decrementing active thread count: " + this._activeCount + " to " + (this._activeCount - 1));
            }
            --this._activeCount;
        } else {
            this._logger.log("*Too many decrement of thread count: current=" + this._activeCount);
        }
    }

    public int getActiveCount() {
        return this._activeCount;
    }

    public int getInitialCount() {
        return this._initialCount;
    }
}

