/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.core.policestory;

import java.io.File;
import java.io.IOException;
import org.dbflute.utflute.core.policestory.javaclass.PoliceStoryJavaClassChase;
import org.dbflute.utflute.core.policestory.javaclass.PoliceStoryJavaClassHandler;
import org.dbflute.utflute.core.policestory.jspfile.PoliceStoryJspFileChase;
import org.dbflute.utflute.core.policestory.jspfile.PoliceStoryJspFileHandler;
import org.dbflute.utflute.core.policestory.miscfile.PoliceStoryMiscFileChase;
import org.dbflute.utflute.core.policestory.miscfile.PoliceStoryMiscFileHandler;
import org.dbflute.utflute.core.policestory.pjresource.PoliceStoryProjectResourceChase;
import org.dbflute.utflute.core.policestory.pjresource.PoliceStoryProjectResourceHandler;
import org.dbflute.utflute.core.policestory.webresource.PoliceStoryWebResourceChase;
import org.dbflute.utflute.core.policestory.webresource.PoliceStoryWebResourceHandler;

public class PoliceStory {
    protected final Object _testCase;
    protected final File _projectDir;

    public PoliceStory(Object testCase, File projectDir) {
        this._testCase = testCase;
        this._projectDir = projectDir;
    }

    public void chaseJavaClass(PoliceStoryJavaClassHandler handler) {
        this.createJavaClassChase(this.getSrcMainJavaDir()).chaseJavaClass(handler);
        if (handler.containsTestClass()) {
            this.createJavaClassChase(this.getSrcTestJavaDir()).chaseJavaClass(handler);
        }
    }

    public void chaseJspFile(PoliceStoryJspFileHandler handler) {
        this.createJspFileChase(this.getWebappDir()).chaseJspFile(handler);
    }

    public void chaseMiscFile(PoliceStoryMiscFileHandler handler, File miscDir) {
        this.createMiscFileChase(miscDir).chaseMiscFile(handler);
    }

    public void chaseProjectResource(PoliceStoryProjectResourceHandler handler) {
        this.createProjectResourceChase(this.getProjectDir()).chaseProjectResource(handler);
    }

    public void chaseWebResource(PoliceStoryWebResourceHandler handler) {
        this.createWebResourceChase(this.getWebappDir()).chaseWebResource(handler);
    }

    protected PoliceStoryJavaClassChase createJavaClassChase(File javaSourceDir) {
        return new PoliceStoryJavaClassChase(this._testCase, javaSourceDir);
    }

    protected PoliceStoryJspFileChase createJspFileChase(File jspDir) {
        return new PoliceStoryJspFileChase(this._testCase, jspDir);
    }

    protected PoliceStoryMiscFileChase createMiscFileChase(File baseDir) {
        return new PoliceStoryMiscFileChase(this._testCase, baseDir);
    }

    protected PoliceStoryProjectResourceChase createProjectResourceChase(File projectDir) {
        return new PoliceStoryProjectResourceChase(this._testCase, projectDir);
    }

    protected PoliceStoryWebResourceChase createWebResourceChase(File webappDir) {
        return new PoliceStoryWebResourceChase(this._testCase, webappDir);
    }

    protected File getSrcMainJavaDir() {
        return new File(this.getProjectPath() + "/src/main/java/");
    }

    protected File getSrcMainResourcesDir() {
        return new File(this.getProjectPath() + "/src/main/resources/");
    }

    protected File getSrcTestJavaDir() {
        return new File(this.getProjectPath() + "/src/test/java/");
    }

    protected File getSrcTestResourcesDir() {
        return new File(this.getProjectPath() + "/src/test/resources/");
    }

    protected File getWebappDir() {
        return new File(this.getProjectPath() + "/src/main/webapp/");
    }

    protected File getProjectDir() {
        return this._projectDir;
    }

    protected String getProjectPath() {
        String projectCanonicalPath;
        File projectDir = this.getProjectDir();
        try {
            projectCanonicalPath = projectDir.getCanonicalPath();
        }
        catch (IOException e) {
            String msg = "Failed to get canonical path from: " + projectDir;
            throw new IllegalStateException(msg, e);
        }
        return projectCanonicalPath;
    }
}

