/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.lastaflute.mail;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.utflute.lastaflute.mail.TestingPreparedMessage;
import org.junit.Assert;
import org.lastaflute.core.mail.LaMailPostcard;

public class TestingMailData {
    protected final Map<Class<?>, List<TestingPreparedMessage>> _messageMap = new ConcurrentHashMap();

    public List<TestingPreparedMessage> required(Class<? extends LaMailPostcard> postcardType) {
        List<TestingPreparedMessage> messageList = this._messageMap.get(postcardType);
        if (messageList == null) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("Not found the postcard in the prepared messages.");
            br.addItem("NotFound Postcard");
            br.addElement(postcardType);
            br.addItem("Existing Postcards");
            br.addElement(this._messageMap.keySet());
            String msg = br.buildExceptionMessage();
            Assert.fail((String)msg);
        }
        if (messageList.isEmpty()) {
            String msg = "Found the empty message list in the prepared messages: " + postcardType;
            Assert.fail((String)msg);
        }
        return messageList;
    }

    public void saveMessage(Class<?> postcardType, TestingPreparedMessage message) {
        List<TestingPreparedMessage> messageList = this._messageMap.get(postcardType);
        if (messageList == null) {
            messageList = new ArrayList<TestingPreparedMessage>();
            this._messageMap.put(postcardType, messageList);
        }
        messageList.add(message);
    }

    public boolean isEmpty() {
        return this._messageMap.isEmpty();
    }
}

