/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.lastaflute.mail;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.mail.internet.InternetAddress;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.mail.CardView;
import org.dbflute.mail.send.supplement.SMailPostingDiscloser;
import org.dbflute.mail.send.supplement.attachment.SMailReadAttachedData;
import org.junit.Assert;

public class TestingPreparedMessage {
    protected final CardView _cardView;
    protected final SMailPostingDiscloser _discloser;

    public TestingPreparedMessage(CardView cardView, SMailPostingDiscloser discloser) {
        this._cardView = cardView;
        this._discloser = discloser;
    }

    public InternetAddress requiredFrom() {
        return (InternetAddress)this._discloser.getSavedFrom().get();
    }

    public List<InternetAddress> requiredToList() {
        List addrList = this._discloser.getSavedToList();
        this.assertTrue("Not found the to-address: postcard=" + this.toPostcardDisp(), !addrList.isEmpty());
        return addrList.stream().map(addr -> (InternetAddress)addr).collect(Collectors.toList());
    }

    public List<InternetAddress> requiredCcList() {
        List addrList = this._discloser.getSavedCcList();
        this.assertTrue("Not found the cc-address: postcard=" + this.toPostcardDisp(), !addrList.isEmpty());
        return addrList.stream().map(addr -> (InternetAddress)addr).collect(Collectors.toList());
    }

    public List<InternetAddress> requiredBccList() {
        List addrList = this._discloser.getSavedBccList();
        this.assertTrue("Not found the bcc-address: postcard=" + this.toPostcardDisp(), !addrList.isEmpty());
        return addrList.stream().map(addr -> (InternetAddress)addr).collect(Collectors.toList());
    }

    public List<InternetAddress> requiredReplyToList() {
        List addrList = this._discloser.getSavedReplyToList();
        this.assertTrue("Not found the reply-to-address: postcard=" + this.toPostcardDisp(), !addrList.isEmpty());
        return addrList.stream().map(addr -> (InternetAddress)addr).collect(Collectors.toList());
    }

    public String requiredReturnPath() {
        return (String)this._discloser.getSavedReturnPath().get();
    }

    public String requiredSubject() {
        return (String)this._discloser.getSavedSubject().get();
    }

    public String requiredPlainText() {
        return (String)this._discloser.getSavedPlainText().get();
    }

    public String requiredHtmlText() {
        return (String)this._discloser.getSavedHtmlText().get();
    }

    public SMailReadAttachedData requiredAttachment(String filenameOnHeader) {
        SMailReadAttachedData attachedData = (SMailReadAttachedData)this._discloser.getSavedAttachmentMap().get(filenameOnHeader);
        if (attachedData == null) {
            this.fail("Not found the attachment in the mail message: filenameOnHeader=" + filenameOnHeader + ", postcard=" + this.toPostcardDisp());
        }
        return attachedData;
    }

    public void assertSubjectContains(String keyword) {
        this.assertTrue("The argument 'keyword' should not be null.", keyword != null);
        this.assertContainsKeyword("subject", this.requiredSubject().toLowerCase(), keyword.toLowerCase());
    }

    public void assertPlainTextContains(String keyword) {
        this.assertTrue("The argument 'keyword' should not be null.", keyword != null);
        this.assertContainsKeyword("plainText", this.requiredPlainText().toLowerCase(), keyword.toLowerCase());
    }

    public void assertHtmlTextContains(String keyword) {
        this.assertTrue("The argument 'keyword' should not be null.", keyword != null);
        this.assertContainsKeyword("htmlText", this.requiredHtmlText().toLowerCase(), keyword.toLowerCase());
    }

    protected void assertContainsKeyword(String title, String text, String keyword) {
        boolean result = text.contains(keyword);
        if (!result) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("Not found the keyword in the mail message.");
            br.addItem("NotFound Keyword");
            br.addElement((Object)keyword);
            br.addItem("Checked Text Part");
            br.addElement((Object)title);
            br.addItem("Your Postcard");
            br.addElement(this.toPostcardDisp());
            String msg = br.buildExceptionMessage();
            this.fail(msg);
        }
    }

    protected void fail(String msg) {
        Assert.fail((String)msg);
    }

    protected void assertTrue(String msg, boolean condition) {
        Assert.assertTrue((String)msg, (boolean)condition);
    }

    protected Object toPostcardDisp() {
        Map loggingMap = this._discloser.getOfficeManagedLoggingMap();
        Map sysinfoMap = (Map)loggingMap.get("sysInfo");
        return sysinfoMap != null ? sysinfoMap : loggingMap;
    }

    public CardView getCardView() {
        return this._cardView;
    }

    public SMailPostingDiscloser getDiscloser() {
        return this._discloser;
    }
}

