/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.lastaflute.police;

import java.io.File;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.utflute.core.filesystem.FilesystemPlayer;
import org.dbflute.utflute.core.policestory.javaclass.PoliceStoryJavaClassHandler;
import org.dbflute.util.Srl;
import org.lastaflute.di.naming.NamingConvention;

public class HotDeployDestroyerPolice
implements PoliceStoryJavaClassHandler {
    protected final Function<Class<?>, Object> componentProvider;

    public HotDeployDestroyerPolice(Function<Class<?>, Object> componentProvider) {
        this.componentProvider = componentProvider;
    }

    @Override
    public void handle(File srcFile, Class<?> clazz) {
        NamingConvention namingConvention = (NamingConvention)this.componentProvider.apply(NamingConvention.class);
        String[] rootPackageNames = namingConvention.getRootPackageNames();
        List rootPrefixList = Stream.of(rootPackageNames).map(name -> name + ".").collect(Collectors.toList());
        String fqcn = clazz.getName();
        if (rootPrefixList.stream().anyMatch(prefix -> fqcn.startsWith((String)prefix))) {
            return;
        }
        new FilesystemPlayer().readLine(srcFile, "UTF-8", line -> {
            if (line.startsWith("import ")) {
                String imported = this.extractImported(line);
                if (rootPrefixList.stream().anyMatch(prefix -> imported.startsWith((String)prefix))) {
                    this.throwHotDeployDestroyerException(clazz, imported);
                }
            }
        });
    }

    protected String extractImported(String line) {
        return Srl.substringFirstFront((String)Srl.ltrim((String)Srl.substringFirstRear((String)line, (String[])new String[]{"import "}), (String)"static "), (String[])new String[]{";"});
    }

    protected void throwHotDeployDestroyerException(Class<?> clazz, Object destroyer) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("HotDeploy destroyer is here.");
        br.addItem("Advice");
        br.addElement((Object)"Non smart deploy package cannot refer smart deploy package.");
        br.addElement((Object)"Make sure your references.");
        br.addElement((Object)"For example:");
        br.addElement((Object)"  (x):");
        br.addElement((Object)"    'bizfw' package => 'app' package");
        br.addElement((Object)"    'dbflute' package => 'app' package");
        br.addElement((Object)"    'mylasta' package => 'app' package");
        br.addElement((Object)"  (o):");
        br.addElement((Object)"    'app' package => 'app' package");
        br.addElement((Object)"    'app' package => 'bizfw' package");
        br.addElement((Object)"    'app' package => 'dbflute' package");
        br.addElement((Object)"    'app' package => 'mylasta' package");
        br.addItem("Destroyer");
        br.addElement((Object)clazz.getName());
        br.addItem("Destroyed");
        br.addElement(destroyer);
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg);
    }
}

