/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.lastaflute.police;

import java.io.File;
import java.lang.reflect.Modifier;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.utflute.core.filesystem.FileLineHandler;
import org.dbflute.utflute.core.filesystem.FilesystemPlayer;
import org.dbflute.utflute.core.policestory.javaclass.PoliceStoryJavaClassHandler;
import org.dbflute.util.Srl;

public class LastaPresentsSomethingPolice
implements PoliceStoryJavaClassHandler {
    protected boolean _formImmutable;
    protected boolean _bodyImmutable;

    @Override
    public void handle(File srcFile, Class<?> clazz) {
        this.handleFormImmutable(srcFile, clazz);
    }

    protected void handleFormImmutable(File srcFile, final Class<?> clazz) {
        if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
            return;
        }
        if (this.isFormImmutableTargetClass(clazz)) {
            new FilesystemPlayer().readLine(srcFile, "UTF-8", new FileLineHandler(){
                private boolean hasFormParameter;
                private boolean hasFormSetup;
                private boolean hasBodyParameter;

                @Override
                public void handle(String line) {
                    if (LastaPresentsSomethingPolice.this._formImmutable) {
                        if (!this.hasFormParameter && LastaPresentsSomethingPolice.this.containsFormParameterDefinition(line)) {
                            this.hasFormParameter = true;
                        }
                        if (!this.hasFormSetup && LastaPresentsSomethingPolice.this.containsFormSetupMethodCall(line)) {
                            this.hasFormSetup = true;
                        }
                        if (this.hasFormParameter && !this.hasFormSetup) {
                            LastaPresentsSomethingPolice.this.checkFormImmutableLine(clazz, line, "Form", "form.");
                        }
                    }
                    if (LastaPresentsSomethingPolice.this._bodyImmutable) {
                        if (!this.hasBodyParameter && LastaPresentsSomethingPolice.this.containsBodyParameterDefinition(line)) {
                            this.hasBodyParameter = true;
                        }
                        if (this.hasBodyParameter) {
                            LastaPresentsSomethingPolice.this.checkFormImmutableLine(clazz, line, "Body", "body.");
                        }
                    }
                }
            });
        }
    }

    protected boolean isFormImmutableTargetClass(Class<?> clazz) {
        String name = clazz.getName();
        return name.contains(this.getWebPackageKeyword()) && (name.endsWith(this.getActionSuffix()) || name.endsWith(this.getAssistSuffix()));
    }

    protected String getWebPackageKeyword() {
        return ".app.web.";
    }

    protected String getActionSuffix() {
        return "Action";
    }

    protected String getAssistSuffix() {
        return "Assist";
    }

    protected boolean containsFormParameterDefinition(String line) {
        return Srl.containsAll((String)line, (String[])new String[]{"public", "Response", "Form form)"});
    }

    protected boolean containsFormSetupMethodCall(String line) {
        return line.contains("setup(form ->");
    }

    protected boolean containsBodyParameterDefinition(String line) {
        return Srl.containsAll((String)line, (String[])new String[]{"public", "Response", "Body body)"});
    }

    protected void checkFormImmutableLine(Class<?> clazz, String line, String title, String formPrefix) {
        String formRear;
        String ltrimmedLine;
        if (line.contains(formPrefix) && (ltrimmedLine = Srl.ltrim((String)line)).startsWith(formPrefix) && ltrimmedLine.length() != line.length() && (formRear = Srl.substringFirstRear((String)line, (String[])new String[]{formPrefix})).contains(" = ")) {
            this.throwFormImmutableBreakException(clazz, title, ltrimmedLine);
        }
    }

    protected void throwFormImmutableBreakException(Class<?> clazz, String title, String ltrimmedLine) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice(title + " should be immutable but re-assignment was found.");
        br.addItem("Advice");
        br.addElement((Object)"Form and Body should be read-only object.");
        br.addElement((Object)"For example:");
        br.addElement((Object)"  (x):");
        br.addElement((Object)"    form.memberName = \"sea\"; // *Bad");
        br.addElement((Object)"    body.memberAccount = \"land\"; // *Bad");
        br.addElement((Object)"  (o):");
        br.addElement((Object)"    selectMember(form.memberName); // Good");
        br.addElement((Object)"    selectMember(body.memberAccount); // Good");
        br.addItem("Target Class");
        br.addElement(clazz);
        br.addItem("Wrong Statement");
        br.addElement((Object)ltrimmedLine);
        String msg = br.buildExceptionMessage();
        throw new FormImmutableBrokenException(msg);
    }

    public LastaPresentsSomethingPolice formImmutable() {
        this._formImmutable = true;
        return this;
    }

    public LastaPresentsSomethingPolice bodyImmutable() {
        this._bodyImmutable = true;
        return this;
    }

    public static class FormImmutableBrokenException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public FormImmutableBrokenException(String msg) {
            super(msg);
        }
    }
}

