/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.lastaflute.police;

import java.io.File;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.utflute.core.policestory.javaclass.PoliceStoryJavaClassHandler;
import org.dbflute.util.Srl;
import org.lastaflute.web.LastaAction;

public class NonActionExtendsActionPolice
implements PoliceStoryJavaClassHandler {
    @Override
    public void handle(File srcFile, Class<?> clazz) {
        this.check(srcFile, clazz, this.getAssistSuffix());
        this.check(srcFile, clazz, this.getLogicSuffix());
        this.check(srcFile, clazz, this.getServiceSuffix());
        this.check(srcFile, clazz, this.getJobSuffix());
    }

    protected String getAssistSuffix() {
        return "Assist";
    }

    protected String getLogicSuffix() {
        return "Logic";
    }

    protected String getServiceSuffix() {
        return "Service";
    }

    protected String getJobSuffix() {
        return "Job";
    }

    protected void check(File srcFile, Class<?> clazz, String suffix) {
        if (clazz.getName().endsWith(suffix) && LastaAction.class.isAssignableFrom(clazz)) {
            this.throwLogicExtendsBaseActionException(clazz, suffix);
        }
    }

    protected void throwLogicExtendsBaseActionException(Class<?> clazz, String suffix) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("No way, the " + Srl.initUncap((String)suffix) + " extends action.");
        br.addItem("Advice");
        br.addElement((Object)(suffix + " is not Action."));
        br.addElement((Object)("so the " + Srl.initUncap((String)suffix) + " cannot extend action."));
        br.addElement((Object)"For example:");
        br.addElement((Object)"  (x):");
        br.addElement((Object)("    public class Sea" + suffix + " extends LandBaseAction { // *Bad"));
        br.addElement((Object)"  (o):");
        br.addElement((Object)("    public class Sea" + suffix + " { // Good"));
        br.addItem(suffix);
        br.addElement((Object)clazz.getName());
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg);
    }
}

