/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.mocklet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.dbflute.utflute.mocklet.MockletHeaderUtil;
import org.dbflute.utflute.mocklet.MockletHttpServletRequest;
import org.dbflute.utflute.mocklet.MockletHttpSessionImpl;
import org.dbflute.utflute.mocklet.MockletRequestDispatcherImpl;
import org.dbflute.utflute.mocklet.helper.MockletEmptyEnumeration;
import org.dbflute.utflute.mocklet.helper.MockletEnumerationAdapter;

public class MockletHttpServletRequestImpl
implements MockletHttpServletRequest {
    protected final ServletContext servletContext;
    protected final String servletPath;
    protected String authType;
    protected final List<Cookie> cookieList = new ArrayList<Cookie>();
    protected final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    protected String method = "POST";
    protected String pathInfo;
    protected String pathTranslated;
    protected String queryString;
    protected MockletHttpSessionImpl session;
    protected String scheme = "http";
    protected int serverPort = 80;
    protected String protocol = "HTTP/1.1";
    protected String serverName = "localhost";
    protected final Map<String, Object> attributes = new HashMap<String, Object>();
    protected String characterEncoding = "ISO-8859-1";
    protected int contentLength;
    protected String contentType;
    protected final Map<String, String[]> parameters = new HashMap<String, String[]>();
    protected String remoteAddr;
    protected String remoteHost;
    protected int remotePort;
    protected String localAddr;
    protected String localName;
    protected int localPort;
    protected final List<Locale> locales = new ArrayList<Locale>();

    public MockletHttpServletRequestImpl(ServletContext servletContext, String servletPath) {
        this.servletContext = servletContext;
        this.servletPath = servletPath.charAt(0) == '/' ? servletPath : "/" + servletPath;
    }

    public String getAuthType() {
        return this.authType;
    }

    @Override
    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public Cookie[] getCookies() {
        return this.cookieList.toArray(new Cookie[this.cookieList.size()]);
    }

    @Override
    public void addCookie(Cookie cookie) {
        this.cookieList.add(cookie);
    }

    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        return MockletHeaderUtil.getDateValue(value);
    }

    public String getHeader(String name) {
        List<String> values = this.getHeaderList(name);
        if (values != null) {
            return values.get(0);
        }
        return null;
    }

    public Enumeration<String> getHeaders(String name) {
        List<String> values = this.getHeaderList(name);
        if (values != null) {
            return new MockletEnumerationAdapter<String>(values.iterator());
        }
        return new MockletEmptyEnumeration<String>();
    }

    public Enumeration<String> getHeaderNames() {
        return new MockletEnumerationAdapter<String>(this.headers.keySet().iterator());
    }

    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        return MockletHeaderUtil.getIntValue(value);
    }

    @Override
    public void addHeader(String name, String value) {
        List<String> values = this.getHeaderList(name);
        if (values == null) {
            values = new ArrayList<String>();
        }
        values.add(value);
        this.headers.put(name.toLowerCase(), values);
    }

    @Override
    public void addDateHeader(String name, long value) {
        this.addHeader(name, MockletHeaderUtil.getDateValue(value));
    }

    @Override
    public void addIntHeader(String name, int value) {
        this.addHeader(name, "" + value);
    }

    private List<String> getHeaderList(String name) {
        name = name.toLowerCase();
        return this.headers.get(name);
    }

    public String getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(String method) {
        this.method = method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    @Override
    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public String getPathTranslated() {
        return this.pathTranslated;
    }

    @Override
    public void setPathTranslated(String pathTranslated) {
        this.pathTranslated = pathTranslated;
    }

    public String getContextPath() {
        return this.servletContext.getContextPath();
    }

    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getRemoteUser() {
        return System.getProperty("user.name");
    }

    public boolean isUserInRole(String arg0) {
        throw new UnsupportedOperationException();
    }

    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException();
    }

    public String getRequestedSessionId() {
        String sessionId = this.getRequestedSessionIdFromCookie();
        if (sessionId != null) {
            return sessionId;
        }
        return this.getRequestedSessionIdFromURL();
    }

    protected String getRequestedSessionIdFromCookie() {
        Cookie[] cookies = this.getCookies();
        if (cookies == null) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            if (!cookie.getName().endsWith("sessionid")) continue;
            return cookie.getValue();
        }
        return null;
    }

    protected String getRequestedSessionIdFromURL() {
        String uri = this.getRequestURI();
        int index = uri.lastIndexOf("sessionid");
        if (index < 0) {
            return null;
        }
        return uri.substring(index + "sessionid".length());
    }

    public String getRequestURI() {
        String contextPath = this.getContextPath();
        if (contextPath.equals("/")) {
            return this.servletPath;
        }
        return contextPath + this.servletPath;
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer();
        url.append(this.scheme);
        url.append("://");
        url.append(this.serverName);
        if (this.scheme.equals("http") && this.serverPort != 80 || this.scheme.equals("https") && this.serverPort != 443) {
            url.append(':');
            url.append(this.serverPort);
        }
        url.append(this.getRequestURI());
        return url;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession(boolean create) {
        if (this.session != null) {
            return this.session;
        }
        if (create) {
            this.session = this.createMockletHttpSessionImpl(this.servletContext);
        }
        if (this.session != null) {
            this.session.access();
        }
        return this.session;
    }

    protected MockletHttpSessionImpl createMockletHttpSessionImpl(ServletContext servletContext) {
        return new MockletHttpSessionImpl(servletContext);
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public boolean isRequestedSessionIdValid() {
        if (this.session != null) {
            return this.session.isValid();
        }
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.getRequestedSessionIdFromCookie() != null;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.getRequestedSessionIdFromURL() != null;
    }

    @Deprecated
    public boolean isRequestedSessionIdFromUrl() {
        return this.isRequestedSessionIdFromURL();
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return new MockletEnumerationAdapter<String>(this.attributes.keySet().iterator());
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) throws UnsupportedEncodingException {
        this.characterEncoding = characterEncoding;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    @Override
    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public ServletInputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getParameter(String name) {
        String[] values = this.parameters.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public Enumeration<String> getParameterNames() {
        return new MockletEnumerationAdapter<String>(this.parameters.keySet().iterator());
    }

    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameters;
    }

    @Override
    public void addParameter(String name, String value) {
        String[] values = this.getParameterValues(name);
        if (values == null) {
            this.setParameter(name, value);
        } else {
            String[] newArray = new String[values.length + 1];
            System.arraycopy(values, 0, newArray, 0, values.length);
            newArray[newArray.length - 1] = value;
            this.parameters.put(name, newArray);
        }
    }

    @Override
    public void addParameter(String name, String[] values) {
        if (values == null) {
            this.setParameter(name, (String)null);
            return;
        }
        String[] vals = this.getParameterValues(name);
        if (vals == null) {
            this.setParameter(name, values);
        } else {
            String[] newArray = new String[vals.length + values.length];
            System.arraycopy(vals, 0, newArray, 0, vals.length);
            System.arraycopy(values, 0, newArray, vals.length, values.length);
            this.parameters.put(name, newArray);
        }
    }

    @Override
    public void setParameter(String name, String value) {
        this.parameters.put(name, new String[]{value});
    }

    @Override
    public void setParameter(String name, String[] values) {
        this.parameters.put(name, values);
    }

    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getScheme() {
        return this.scheme;
    }

    @Override
    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getServerName() {
        return this.serverName;
    }

    @Override
    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    @Override
    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public BufferedReader getReader() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    @Override
    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    @Override
    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    @Override
    public void setLocalAddr(String localAddr) {
        this.localAddr = localAddr;
    }

    public String getLocalName() {
        return this.localName;
    }

    @Override
    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    @Override
    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    @Override
    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public Locale getLocale() {
        if (this.locales.isEmpty()) {
            return Locale.getDefault();
        }
        return this.locales.get(0);
    }

    @Override
    public void setLocale(Locale locale) {
        this.locales.clear();
        this.locales.add(locale);
    }

    public Enumeration<Locale> getLocales() {
        return new MockletEnumerationAdapter<Locale>(this.locales.iterator());
    }

    public boolean isSecure() {
        return false;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return new MockletRequestDispatcherImpl();
    }

    @Deprecated
    public String getRealPath(String path) {
        return path;
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String changeSessionId() {
        return null;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return false;
    }

    public void login(String username, String password) throws ServletException {
    }

    public void logout() throws ServletException {
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return null;
    }

    public Part getPart(String name) throws IOException, ServletException {
        return null;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        return null;
    }

    public long getContentLengthLong() {
        return 0L;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return null;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return null;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        return null;
    }
}

