/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.mocklet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.dbflute.utflute.mocklet.MockletHeaderUtil;
import org.dbflute.utflute.mocklet.MockletHttpServletResponse;
import org.dbflute.utflute.mocklet.MockletServletOutputStreamImpl;
import org.dbflute.utflute.mocklet.helper.MockletSPrintWriter;

public class MockletHttpServletResponseImpl
implements MockletHttpServletResponse {
    protected final List<Cookie> cookieList;
    protected final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    protected boolean committed = false;
    protected int status;
    protected String message;
    protected byte[] buffer = new byte[1024];
    protected Locale locale;
    protected String characterEncoding;
    protected final PrintWriter writer = new MockletSPrintWriter();
    protected final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    protected final ServletOutputStream outputStream = new MockletServletOutputStreamImpl(this.byteArrayOutputStream);
    protected boolean getWriterCalled;
    protected boolean getOutputStreamCalled;

    public MockletHttpServletResponseImpl(HttpServletRequest request) {
        this.cookieList = new ArrayList<Cookie>(Arrays.asList(request.getCookies()));
        this.locale = request.getLocale();
        this.characterEncoding = request.getCharacterEncoding();
    }

    @Override
    public Cookie[] getCookies() {
        return this.cookieList.toArray(new Cookie[this.cookieList.size()]);
    }

    public void addCookie(Cookie cookie) {
        this.cookieList.add(cookie);
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    public String encodeURL(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    @Deprecated
    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    @Deprecated
    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void sendError(int status, String message) throws IOException {
        this.setStatus(status, message);
    }

    public void sendError(int status) throws IOException {
        this.setStatus(status);
    }

    public void sendRedirect(String path) throws IOException {
    }

    @Override
    public Collection<String> getHeaders(String name) {
        List<String> values = this.getHeaderList(name);
        return values != null ? new ArrayList<String>(values) : new ArrayList();
    }

    @Override
    public String getHeader(String name) {
        List<String> values = this.getHeaderList(name);
        if (values != null) {
            return values.get(0);
        }
        return null;
    }

    @Override
    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public void setDateHeader(String name, long value) {
        this.setHeader(name, MockletHeaderUtil.getDateValue(value));
    }

    public void addDateHeader(String name, long value) {
        this.addHeader(name, MockletHeaderUtil.getDateValue(value));
    }

    public void setHeader(String name, String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.headers.put(name.toLowerCase(), values);
    }

    public void addHeader(String name, String value) {
        List<String> values = this.getHeaderList(name);
        if (values == null) {
            values = new ArrayList<String>();
        }
        values.add(value);
        this.headers.put(name.toLowerCase(), values);
    }

    @Override
    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        return MockletHeaderUtil.getIntValue(value);
    }

    public void setIntHeader(String name, int value) {
        this.setHeader(name, value + "");
    }

    public void addIntHeader(String name, int value) {
        this.addHeader(name, value + "");
    }

    private List<String> getHeaderList(String name) {
        name = name.toLowerCase();
        return this.headers.get(name);
    }

    public void setStatus(int status) {
        this.setStatus(status, MockletHttpServletResponseImpl.getResponseStatusMessage(status));
    }

    private static String getResponseStatusMessage(int status) {
        switch (status) {
            case 200: {
                return "OK";
            }
            case 202: {
                return "Accepted";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 400: {
                return "Bad Request";
            }
            case 409: {
                return "Conflict";
            }
            case 100: {
                return "Continue";
            }
            case 201: {
                return "Created";
            }
            case 417: {
                return "Expectation Failed";
            }
            case 403: {
                return "Forbidden";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 410: {
                return "Gone";
            }
            case 505: {
                return "HTTP Version Not Supported";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 411: {
                return "Length Required";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Moved Temporarily";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 204: {
                return "No Content";
            }
            case 203: {
                return "Non-Authoritative Information";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 404: {
                return "Not Found";
            }
            case 501: {
                return "Not Implemented";
            }
            case 304: {
                return "Not Modified";
            }
            case 206: {
                return "Partial Content";
            }
            case 402: {
                return "Payment Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 408: {
                return "Request Timeout";
            }
            case 414: {
                return "Request URI Too Long";
            }
            case 416: {
                return "Requested Range Not Satisfiable";
            }
            case 205: {
                return "Reset Content";
            }
            case 303: {
                return "See Other";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 101: {
                return "Switching Protocols";
            }
            case 401: {
                return "Unauthorized";
            }
            case 415: {
                return "Unsupported Media Type";
            }
            case 305: {
                return "Use Proxy";
            }
            case 207: {
                return "Multi-Status";
            }
            case 422: {
                return "Unprocessable Entity";
            }
            case 423: {
                return "Locked";
            }
            case 507: {
                return "Insufficient Storage";
            }
        }
        return "HTTP Response Status " + status;
    }

    @Deprecated
    public void setStatus(int status, String message) {
        this.assertNotCommitted();
        this.status = status;
        this.message = message;
        this.resetBuffer();
    }

    private void assertNotCommitted() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Already committed");
        }
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    @Override
    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.getWriterCalled) {
            throw new IllegalStateException();
        }
        if (!this.getOutputStreamCalled) {
            this.getOutputStreamCalled = true;
        }
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.getOutputStreamCalled) {
            throw new IllegalStateException();
        }
        if (!this.getWriterCalled) {
            this.getWriterCalled = true;
        }
        return this.writer;
    }

    public void setContentLength(int contentLength) {
        this.setIntHeader("content-length", contentLength);
    }

    @Override
    public int getContentLength() {
        return this.getIntHeader("content-length");
    }

    @Override
    public String getContentType() {
        return this.getHeader("content-type");
    }

    public void setContentType(String contentType) {
        this.setHeader("content-type", contentType);
    }

    public void setBufferSize(int size) {
        this.assertNotCommitted();
        if (size <= this.buffer.length) {
            return;
        }
        this.buffer = new byte[size];
    }

    public int getBufferSize() {
        return this.buffer.length;
    }

    public void flushBuffer() throws IOException {
    }

    public void resetBuffer() {
        this.assertNotCommitted();
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void reset() {
        this.committed = false;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public byte[] getResponseBytes() {
        return this.byteArrayOutputStream.toByteArray();
    }

    @Override
    public String getResponseString() {
        return this.writer.toString();
    }

    public void setContentLengthLong(long len) {
    }
}

