/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.core.beanorder;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.dbflute.utflute.core.beanorder.BeanOrderBySpec;
import org.dbflute.utflute.core.beanorder.BeanOrderByViolation;
import org.dbflute.utflute.core.beanorder.BeanOrderCaseMark;
import org.dbflute.utflute.core.beanorder.ExpectedBeanOrderBy;

public class BeanOrderValidator<BEAN> {
    protected final Consumer<ExpectedBeanOrderBy<BEAN>> orderBySpecCall;
    protected boolean orderShortCaseIgnored;

    public BeanOrderValidator(Consumer<ExpectedBeanOrderBy<BEAN>> orderBySpecCall) {
        this.orderBySpecCall = orderBySpecCall;
    }

    public BeanOrderValidator<BEAN> ignoreOrderShortCase() {
        this.orderShortCaseIgnored = true;
        return this;
    }

    public void validateOrder(List<BEAN> beanList, Consumer<BeanOrderByViolation<BEAN>> violationCall) {
        ExpectedBeanOrderBy orderBy = new ExpectedBeanOrderBy();
        this.orderBySpecCall.accept(orderBy);
        List orderBySpecList = orderBy.getOrderBySpecList();
        LinkedHashMap<Integer, BeanOrderCaseMark> caseMarkMap = new LinkedHashMap<Integer, BeanOrderCaseMark>();
        BEAN previousBean = null;
        for (BEAN nextBean : beanList) {
            if (previousBean != null) {
                this.doAssertOrder(previousBean, nextBean, orderBySpecList.iterator(), violationCall, 1, caseMarkMap);
            }
            previousBean = nextBean;
        }
        this.verifyShortCase(orderBySpecList, caseMarkMap);
    }

    protected void verifyShortCase(List<BeanOrderBySpec<BEAN>> orderBySpecList, Map<Integer, BeanOrderCaseMark> caseMarkMap) {
        if (this.orderShortCaseIgnored) {
            return;
        }
        for (BeanOrderBySpec<BEAN> spec : orderBySpecList) {
            int specNo = spec.getSpecNo();
            BeanOrderCaseMark caseMark = caseMarkMap.get(specNo);
            if (caseMark != null && caseMark.isCaseFound()) continue;
            throw new IllegalStateException("Not found the order case for the spec number: " + specNo);
        }
    }

    protected void doAssertOrder(BEAN previousBean, BEAN nextBean, Iterator<BeanOrderBySpec<BEAN>> specIterator, Consumer<BeanOrderByViolation<BEAN>> violationCall, int specNo, Map<Integer, BeanOrderCaseMark> caseMarkMap) {
        if (!specIterator.hasNext()) {
            return;
        }
        BeanOrderBySpec<BEAN> spec = specIterator.next();
        Function<BEAN, Comparable<Object>> provider = spec.getValueProvider();
        Comparable<Object> previousValue = provider.apply(previousBean);
        Comparable<Object> nextValue = provider.apply(nextBean);
        int compareTo = this.compareTo(spec, previousValue, nextValue);
        if (spec.isAsc() ? compareTo > 0 : compareTo < 0) {
            violationCall.accept(this.createOrderByViolation(specNo, previousBean, nextBean, previousValue, nextValue));
        } else if (compareTo == 0) {
            this.doAssertOrder(previousBean, nextBean, specIterator, violationCall, specNo + 1, caseMarkMap);
        }
        if (compareTo != 0 && !caseMarkMap.containsKey(specNo)) {
            caseMarkMap.put(specNo, new BeanOrderCaseMark(specNo).markCase());
        }
    }

    protected int compareTo(BeanOrderBySpec<BEAN> spec, Comparable<Object> previousValue, Comparable<Object> nextValue) {
        if (previousValue == null && nextValue == null) {
            return 0;
        }
        if (previousValue == null) {
            return (spec.isAsc() ? 1 : -1) * (spec.isNullsFirst() ? -1 : 1);
        }
        if (nextValue == null) {
            return (spec.isAsc() ? 1 : -1) * (spec.isNullsFirst() ? 1 : -1);
        }
        return previousValue.compareTo(nextValue);
    }

    protected BeanOrderByViolation<BEAN> createOrderByViolation(int specNo, BEAN previousBean, BEAN nextBean, Comparable<Object> previousValue, Comparable<Object> nextValue) {
        return new BeanOrderByViolation<BEAN>(specNo, previousBean, nextBean, previousValue, nextValue);
    }
}

