/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.core.cannonball;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import junit.framework.AssertionFailedError;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.utflute.core.cannonball.CannonballCar;
import org.dbflute.utflute.core.cannonball.CannonballFinalizer;
import org.dbflute.utflute.core.cannonball.CannonballLatch;
import org.dbflute.utflute.core.cannonball.CannonballLogger;
import org.dbflute.utflute.core.cannonball.CannonballOption;
import org.dbflute.utflute.core.cannonball.CannonballRetireException;
import org.dbflute.utflute.core.cannonball.CannonballRun;
import org.dbflute.utflute.core.cannonball.CannonballStaff;
import org.dbflute.utflute.core.transaction.TransactionResource;
import org.dbflute.util.Srl;

public class CannonballDirector {
    protected final CannonballStaff _cannonballHelper;

    public CannonballDirector(CannonballStaff cannonballHelper) {
        this._cannonballHelper = cannonballHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readyGo(CannonballRun execution, CannonballOption option) {
        ArrayList<CannonballRetireException> retireExList;
        block13: {
            if (execution == null) {
                String msg = "The argument 'execution' should be not null.";
                throw new IllegalArgumentException(msg);
            }
            if (option == null) {
                String msg = "The argument 'option' should be not null.";
                throw new IllegalArgumentException(msg);
            }
            retireExList = new ArrayList<CannonballRetireException>();
            try {
                CannonballFinalizer finalizer;
                try {
                    for (int i = 0; i < option.getRepeatCount(); ++i) {
                        List<Object> resultList = this.doThreadFire(execution, option);
                        for (Object result : resultList) {
                            if (!(result instanceof CannonballRetireException)) continue;
                            retireExList.add((CannonballRetireException)result);
                        }
                    }
                    finalizer = option.getFinalizer();
                    if (finalizer == null) break block13;
                }
                catch (Throwable throwable) {
                    CannonballFinalizer finalizer2 = option.getFinalizer();
                    if (finalizer2 == null) throw throwable;
                    try {
                        this.log("...Running finalizer for fired threads");
                        finalizer2.run();
                        throw throwable;
                    }
                    catch (RuntimeException continued) {
                        this.handleFinalizerException(continued);
                    }
                    throw throwable;
                }
                try {
                    this.log("...Running finalizer for fired threads");
                    finalizer.run();
                }
                catch (RuntimeException continued) {
                    this.handleFinalizerException(continued);
                }
            }
            catch (CannonballRetireException e) {
                retireExList.add(e);
            }
        }
        if (option.isCheckExpectedExceptionAny()) {
            this.handleExpectedExceptionAny(option, retireExList);
            return;
        }
        this.handleNormalException(retireExList);
    }

    protected List<Object> doThreadFire(CannonballRun execution, CannonballOption option) {
        ExecutorService service = Executors.newCachedThreadPool();
        int threadCount = option.getThreadCount();
        CountDownLatch ready = new CountDownLatch(threadCount);
        CountDownLatch start = new CountDownLatch(1);
        CountDownLatch goal = new CountDownLatch(threadCount);
        CannonballLogger logger = this.createLogger();
        CannonballLatch ourLatch = new CannonballLatch(threadCount, logger);
        Object lockObj = new Object();
        ArrayList<Future<Object>> futureList = new ArrayList<Future<Object>>();
        for (int i = 0; i < threadCount; ++i) {
            int entryNumber = i + 1;
            Callable<Object> callable = this.createCallable(execution, option, ready, start, goal, ourLatch, entryNumber, lockObj, logger);
            Future<Object> future = service.submit(callable);
            futureList.add(future);
        }
        this.log("/- - - - - - - - - - - - - - - - - - - - - -");
        this.log("                                 Cannon-ball");
        this.log("                                 - - - - - -");
        start.countDown();
        try {
            goal.await();
        }
        catch (InterruptedException e) {
            String msg = "goal.await() was interrupted!";
            throw new IllegalStateException(msg, e);
        }
        this.log("- - - - - - - - -/ *All threads were fired");
        List<Object> resultList = this.handleFuture(option, futureList);
        this.assertSameResultIfExpected(option, resultList);
        return resultList;
    }

    protected CannonballLogger createLogger() {
        return new CannonballLogger(){

            @Override
            public void log(Object ... msgs) {
                CannonballDirector.this.log(msgs);
            }
        };
    }

    protected List<Object> handleFuture(CannonballOption option, List<Future<Object>> futureList) {
        ArrayList<Object> resultList = new ArrayList<Object>();
        for (Future<Object> future : futureList) {
            String msg;
            Object result = null;
            try {
                result = future.get();
            }
            catch (InterruptedException e) {
                msg = "future.get() was interrupted!";
                throw new IllegalStateException(msg, e);
            }
            catch (ExecutionException continued) {
                msg = "Failed to fire the thread: " + future;
                result = new CannonballRetireException(msg, continued.getCause());
            }
            resultList.add(result);
        }
        return resultList;
    }

    protected <RESULT> void assertSameResultIfExpected(CannonballOption option, List<RESULT> resultList) {
        if (option.isExpectedSameResult()) {
            Object preResult = null;
            for (RESULT result : resultList) {
                this.log(result);
                if (preResult == null) {
                    preResult = result;
                    continue;
                }
                this.assertEquals(preResult, result);
            }
        }
    }

    protected void handleFinalizerException(RuntimeException continued) {
        StringBuilder sb = new StringBuilder();
        sb.append("*Failed to run finalizer:");
        sb.append(this.ln()).append("/= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =");
        sb.append(this.ln()).append(continued.getMessage());
        sb.append(this.ln()).append("= = = = = = = = = =/");
        String msg = sb.toString();
        this.log(msg);
    }

    protected Callable<Object> createCallable(final CannonballRun run, final CannonballOption option, final CountDownLatch ready, final CountDownLatch start, final CountDownLatch goal, final CannonballLatch ourLatch, final int entryNumber, final Object lockObj, final CannonballLogger logger) {
        return new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Object call() {
                long threadId = Thread.currentThread().getId();
                CannonballCar car = CannonballDirector.this.createCar(threadId, ourLatch, entryNumber, lockObj, option, logger);
                boolean failure = false;
                try {
                    Object result;
                    block22: {
                        ready.countDown();
                        try {
                            start.await();
                        }
                        catch (InterruptedException e) {
                            String msg = "start.await() was interrupted: start=" + start;
                            throw new IllegalStateException(msg, e);
                        }
                        CannonballDirector.this.prepareBeginning();
                        CannonballDirector.this.prepareAccessContext();
                        TransactionResource txRes = null;
                        if (!option.isSuppressTransaction()) {
                            txRes = CannonballDirector.this.beginTransaction();
                        }
                        result = null;
                        try {
                            run.drive(car);
                            result = car.getRunResult();
                            if (txRes == null) break block22;
                        }
                        catch (RuntimeException e) {
                            try {
                                failure = true;
                                throw e;
                                catch (Error e2) {
                                    failure = true;
                                    throw e2;
                                }
                            }
                            catch (Throwable throwable) {
                                if (txRes != null) {
                                    try {
                                        if (!failure && option.isCommitTransaction()) {
                                            txRes.commit();
                                        } else {
                                            txRes.rollback();
                                        }
                                    }
                                    catch (Exception continued) {
                                        CannonballDirector.this.log("*Failed to commit or roll-back: " + continued.getMessage());
                                    }
                                }
                                CannonballDirector.this.clearAccessContext();
                                throw throwable;
                            }
                        }
                        try {
                            if (!failure && option.isCommitTransaction()) {
                                txRes.commit();
                            } else {
                                txRes.rollback();
                            }
                        }
                        catch (Exception continued) {
                            CannonballDirector.this.log("*Failed to commit or roll-back: " + continued.getMessage());
                        }
                    }
                    CannonballDirector.this.clearAccessContext();
                    Object object = result;
                    return object;
                }
                finally {
                    goal.countDown();
                    boolean suppressDecrement = car.isSuppressDecrementWhenBreakAway();
                    if (failure) {
                        ourLatch.breakAway(entryNumber, suppressDecrement);
                    } else {
                        ourLatch.complete(entryNumber, suppressDecrement);
                    }
                }
            }
        };
    }

    protected CannonballCar createCar(long threadId, CannonballLatch ourLatch, int entryNumber, Object lockObj, CannonballOption option, CannonballLogger logger) {
        int countOfEntry = option.getThreadCount();
        return new CannonballCar(threadId, ourLatch, entryNumber, lockObj, countOfEntry, logger);
    }

    protected void handleExpectedExceptionAny(CannonballOption option, List<CannonballRetireException> retireExList) {
        ArrayList<Throwable> expectedCauseList = new ArrayList<Throwable>();
        ArrayList<Throwable> unexpectedCauseList = new ArrayList<Throwable>();
        String expectedExpceptionAnyExp = option.getExpectedExpceptionAnyExp();
        if (retireExList.isEmpty()) {
            this.fail("The cannonball cars should throw the exception: " + expectedExpceptionAnyExp);
        }
        for (CannonballRetireException retireEx : retireExList) {
            Throwable targetCause;
            Throwable cause = retireEx.getCause();
            if (cause != null) {
                if (cause instanceof AssertionFailedError) {
                    throw (AssertionFailedError)cause;
                }
                targetCause = cause;
            } else {
                targetCause = retireEx;
            }
            if (option.isMatchExpectedExceptionAny(targetCause)) {
                expectedCauseList.add(targetCause);
                continue;
            }
            unexpectedCauseList.add(targetCause);
        }
        if (expectedCauseList.isEmpty()) {
            this.throwUnexpectedExceptionFound(unexpectedCauseList, expectedExpceptionAnyExp);
        } else {
            this.handleExpectedExceptionFound(expectedCauseList, unexpectedCauseList, expectedExpceptionAnyExp);
        }
    }

    protected void throwUnexpectedExceptionFound(List<Throwable> unexpectedCauseList, String expectedExpceptionAnyExp) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("The unexpected exception was thrown in cannonball().");
        br.addItem("Advice");
        br.addElement((Object)"Expect the exception is");
        br.addElement((Object)("  '" + expectedExpceptionAnyExp + "'."));
        br.addElement((Object)"But such an exception was not found,");
        br.addElement((Object)"while unexpected exception was found.");
        br.addItem("Unexpected Exception");
        br.addElement((Object)"The unexpected exception are following.");
        br.addElement((Object)"(And you can also see for the detail in your log)");
        for (Throwable unexpectedCause : unexpectedCauseList) {
            String oneLine = this.buildOneLineExceptionMessage(unexpectedCause);
            br.addElement((Object)unexpectedCause.getClass().getName());
            br.addElement((Object)("  '" + oneLine + "'"));
            this.log(unexpectedCause);
        }
        String msg = br.buildExceptionMessage();
        throw new AssertionFailedError(msg);
    }

    protected String buildOneLineExceptionMessage(Throwable unexpectedCause) {
        String message = unexpectedCause.getMessage();
        if (message == null) {
            return "null";
        }
        if (message.contains(this.ln())) {
            return Srl.substringFirstFront((String)message, (String[])new String[]{"\n"}) + "...";
        }
        return message;
    }

    protected void handleExpectedExceptionFound(List<Throwable> expectedCauseList, List<Throwable> unexpectedCauseList, String expectedExpceptionAnyExp) {
        boolean unexpected;
        StringBuilder sb = new StringBuilder();
        sb.append(this.ln()).append("_/_/_/_/_/_/_/_/_/_/");
        sb.append(this.ln()).append(" Expected exception");
        sb.append(this.ln()).append("_/_/_/_/_/_/_/_/_/_/");
        this.buildExceptionOverview(sb, expectedCauseList);
        sb.append(this.ln());
        boolean bl = unexpected = !unexpectedCauseList.isEmpty();
        if (unexpected) {
            sb.append(this.ln()).append("_/_/_/_/_/_/_/_/_/_/_/");
            sb.append(this.ln()).append(" Unexpected Exception");
            sb.append(this.ln()).append("_/_/_/_/_/_/_/_/_/_/_/");
            this.buildExceptionOverview(sb, unexpectedCauseList);
            sb.append(this.ln());
        }
        sb.append(this.ln());
        String supplement = unexpected ? " (with unexpected)" : "";
        sb.append("*The expected exception" + supplement + " was found: " + expectedExpceptionAnyExp);
        this.log(sb.toString());
    }

    protected void buildExceptionOverview(StringBuilder sb, List<Throwable> unexpectedCauseList) {
        for (Throwable unexpectedCause : unexpectedCauseList) {
            String msg = unexpectedCause.getMessage();
            sb.append(this.ln()).append(unexpectedCause.getClass().getName()).append(": ").append(msg);
        }
    }

    protected void handleNormalException(List<CannonballRetireException> retireExList) {
        if (retireExList.isEmpty()) {
            return;
        }
        boolean titleDone = false;
        for (CannonballRetireException retireEx : retireExList) {
            Throwable cause = retireEx.getCause();
            if (cause instanceof AssertionFailedError) {
                throw (AssertionFailedError)cause;
            }
            if (!titleDone) {
                this.log("_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/");
                this.log(" Cannonball Retire Exception");
                this.log("_/_/_/_/_/_/_/_/_/_/_/_/_/_/_/");
                titleDone = true;
            }
            this.log(cause != null ? cause : retireEx);
        }
        throw retireExList.get(0);
    }

    protected TransactionResource beginTransaction() {
        return this._cannonballHelper.help_beginTransaction();
    }

    protected void prepareBeginning() {
        this._cannonballHelper.help_prepareBeginning();
    }

    protected void prepareAccessContext() {
        this._cannonballHelper.help_prepareAccessContext();
    }

    protected void clearAccessContext() {
        this._cannonballHelper.help_clearAccessContext();
    }

    protected void assertEquals(Object expected, Object actual) {
        this._cannonballHelper.help_assertEquals(expected, actual);
    }

    protected void fail(String msg) {
        this._cannonballHelper.help_fail(msg);
    }

    protected void log(Object ... msgs) {
        this._cannonballHelper.help_log(msgs);
    }

    protected String ln() {
        return this._cannonballHelper.help_ln();
    }
}

