/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.core.cannonball;

import java.util.concurrent.CountDownLatch;
import org.dbflute.utflute.core.cannonball.CannonballRetireException;

public class CannonballVaryingLatch {
    protected final int _initialCount;
    protected final CountDownLatch _latch;
    protected int _bufferCount;

    public CannonballVaryingLatch(int initialCount) {
        this._initialCount = initialCount;
        this._latch = new CountDownLatch(initialCount);
    }

    public void await() {
        try {
            this._latch.await();
        }
        catch (InterruptedException e) {
            String msg = "Failed to await by your latch: latch=" + this._latch;
            throw new CannonballRetireException(msg, e);
        }
    }

    public void countDown() {
        if (this.countDownBufferCount()) {
            return;
        }
        this._latch.countDown();
    }

    public synchronized long getCount() {
        return this._latch.getCount() + (long)this._bufferCount;
    }

    public synchronized void incrementBufferCount() {
        ++this._bufferCount;
    }

    protected synchronized boolean countDownBufferCount() {
        if (this._bufferCount > 0) {
            --this._bufferCount;
            return true;
        }
        return false;
    }

    public boolean isReleasedLatch() {
        return this.getCount() == 0L;
    }

    public boolean isLastCountLatch() {
        return this.getCount() == 1L;
    }

    public int getInitialCount() {
        return this._initialCount;
    }
}

