/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.core.markhere;

import java.util.LinkedHashMap;
import java.util.Map;
import org.dbflute.utflute.core.markhere.MarkHerePhase;

public class MarkHereInfo {
    protected final String _mark;
    protected Integer _currentPhaseNumber = 1;
    protected final Map<Integer, MarkHerePhase> _markedPhaseMap = new LinkedHashMap<Integer, MarkHerePhase>();

    public MarkHereInfo(String mark) {
        this._mark = mark;
    }

    public void markPhase() {
        MarkHerePhase phase = this.getCurrentPhase();
        if (phase == null) {
            phase = this.createPhase(this._mark, this._currentPhaseNumber);
            this._markedPhaseMap.put(this._currentPhaseNumber, phase);
        }
        phase.incrementMarkedCount();
    }

    protected MarkHerePhase createPhase(String mark, Integer phaseNumber) {
        return new MarkHerePhase(mark, phaseNumber);
    }

    public boolean isNonAssertedPhase() {
        MarkHerePhase phase = this.getCurrentPhase();
        return phase != null && !phase.isAsserted();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("mark").append(":{");
        sb.append(this._mark);
        int phaseSize = this._markedPhaseMap.size();
        sb.append(", has ").append(phaseSize).append(" ").append(phaseSize > 1 ? "phases" : "phase ");
        MarkHerePhase phase = this.getCurrentPhase();
        sb.append(", current=").append(phase).append(phase == null ? ":(no mark)" : "");
        sb.append("}");
        return sb.toString();
    }

    public String getMark() {
        return this._mark;
    }

    public Integer getCurrentPhaseNumber() {
        return this._currentPhaseNumber;
    }

    public void finishPhase() {
        this._currentPhaseNumber = this._currentPhaseNumber + 1;
    }

    public MarkHerePhase getCurrentPhase() {
        return this._markedPhaseMap.get(this._currentPhaseNumber);
    }
}

