/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.core.markhere;

import java.util.LinkedHashMap;
import java.util.Map;
import junit.framework.AssertionFailedError;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.utflute.core.markhere.MarkHereInfo;

public class MarkHereManager {
    protected Map<String, MarkHereInfo> _xmarkMap;

    public void mark(String mark) {
        MarkHereInfo info;
        if (this._xmarkMap == null) {
            this._xmarkMap = new LinkedHashMap<String, MarkHereInfo>();
        }
        if ((info = this._xmarkMap.get(mark)) == null) {
            info = new MarkHereInfo(mark);
            this._xmarkMap.put(mark, info);
        }
        info.markPhase();
    }

    public void assertMarked(String mark) {
        MarkHereInfo info;
        boolean existsMark = false;
        if (this._xmarkMap != null && this.isFoundMark(info = this._xmarkMap.get(mark))) {
            existsMark = true;
            info.finishPhase();
        }
        if (!existsMark) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("The mark was NOT marked. (not found)");
            br.addItem("NotFound Mark");
            br.addElement((Object)mark);
            br.addItem("Mark Map");
            if (this._xmarkMap != null && !this._xmarkMap.isEmpty()) {
                for (Map.Entry<String, MarkHereInfo> entry : this._xmarkMap.entrySet()) {
                    br.addElement((Object)entry.getValue());
                }
            } else {
                br.addItem("*no mark");
            }
            String msg = br.buildExceptionMessage();
            throw new AssertionFailedError(msg);
        }
    }

    protected boolean isFoundMark(MarkHereInfo info) {
        return info != null && info.isNonAssertedPhase();
    }

    public boolean isMarked(String mark) {
        return this._xmarkMap != null && this._xmarkMap.get(mark) != null;
    }

    public void checkNonAssertedMark() {
        if (this._xmarkMap == null) {
            return;
        }
        MarkHereInfo nonAssertedInfo = null;
        for (Map.Entry<String, MarkHereInfo> entry : this._xmarkMap.entrySet()) {
            MarkHereInfo markHereInfo = entry.getValue();
            if (!markHereInfo.isNonAssertedPhase()) continue;
            nonAssertedInfo = markHereInfo;
            break;
        }
        if (nonAssertedInfo != null) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("Found the non-asserted mark.");
            br.addItem("Advice");
            br.addElement((Object)"The mark should be asserted like this:");
            br.addElement((Object)"  (x):");
            br.addElement((Object)"    markHere(\"foo\");");
            br.addElement((Object)"    markHere(\"bar\");");
            br.addElement((Object)"    ...");
            br.addElement((Object)"    assertMarked(\"foo\");");
            br.addElement((Object)"  (o):");
            br.addElement((Object)"    markHere(\"foo\");");
            br.addElement((Object)"    markHere(\"bar\");");
            br.addElement((Object)"    ...");
            br.addElement((Object)"    assertMarked(\"foo\");");
            br.addElement((Object)"    assertMarked(\"bar\");");
            br.addItem("Non-Asserted Mark");
            br.addElement((Object)nonAssertedInfo.getMark());
            br.addItem("Mark Map");
            for (Map.Entry entry : this._xmarkMap.entrySet()) {
                br.addElement(entry.getValue());
            }
            String msg = br.buildExceptionMessage();
            throw new AssertionFailedError(msg);
        }
    }

    public void clearMarkMap() {
        if (this._xmarkMap != null) {
            this._xmarkMap.clear();
            this._xmarkMap = null;
        }
    }
}

