/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.core.policestory.javaclass;

import java.io.File;
import java.io.IOException;
import org.dbflute.helper.filesystem.FileHierarchyTracer;
import org.dbflute.helper.filesystem.FileHierarchyTracingHandler;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.utflute.core.policestory.javaclass.PoliceStoryJavaClassHandler;
import org.dbflute.util.DfReflectionUtil;
import org.dbflute.util.Srl;

public class PoliceStoryJavaClassChase {
    protected final Object _testCase;
    protected final File _javaSrcDir;

    public PoliceStoryJavaClassChase(Object testCase, File javaSrcDir) {
        this._testCase = testCase;
        this._javaSrcDir = javaSrcDir;
    }

    public void chaseJavaClass(PoliceStoryJavaClassHandler handler) {
        try {
            this.doChase(this._javaSrcDir, handler);
        }
        catch (RuntimeException e) {
            this.throwPoliceStoryOfJavaClassChaseFailureException(this._javaSrcDir, e);
        }
    }

    protected void throwPoliceStoryOfJavaClassChaseFailureException(File srcDir, Exception cause) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to chase Java class.");
        br.addItem("Test Case");
        br.addElement(this._testCase);
        br.addItem("Source Directory");
        br.addElement((Object)srcDir);
        br.addItem("Cause");
        br.addElement(cause.getClass());
        br.addElement((Object)"See the cause exception message at 'Caused by'.");
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg, cause);
    }

    protected void doChase(final File srcDir, final PoliceStoryJavaClassHandler handler) {
        if (!srcDir.exists()) {
            String msg = "The source directory does not exist: " + srcDir;
            throw new IllegalStateException(msg);
        }
        this.createFileHierarchyTracer().trace(srcDir, new FileHierarchyTracingHandler(){

            public boolean isTargetFileOrDir(File currentFile) {
                if (currentFile.isDirectory()) {
                    return true;
                }
                String fileName = currentFile.getName();
                if ("package-info.java".equals(fileName)) {
                    return false;
                }
                return fileName.endsWith(".java");
            }

            public void handleFile(File currentFile) throws IOException {
                handler.handle(currentFile, PoliceStoryJavaClassChase.this.analyzeClass(srcDir, currentFile));
            }
        });
    }

    protected FileHierarchyTracer createFileHierarchyTracer() {
        return new FileHierarchyTracer();
    }

    protected Class<?> analyzeClass(File srcDir, File currentFile) throws IOException {
        String srcCanoPath = Srl.replace((String)srcDir.getCanonicalPath(), (String)"\\", (String)"/");
        String fileCanoPath = Srl.replace((String)currentFile.getCanonicalPath(), (String)"\\", (String)"/");
        String packageFile = Srl.substringFirstRear((String)fileCanoPath, (String[])new String[]{srcCanoPath});
        String packageExp = Srl.trim((String)Srl.replace((String)Srl.substringLastFront((String)packageFile, (String[])new String[]{"/"}), (String)"/", (String)"."), (String)".");
        String simpleName = Srl.substringLastFront((String)currentFile.getName(), (String[])new String[]{".java"});
        String className = packageExp + "." + simpleName;
        return DfReflectionUtil.forName((String)className);
    }
}

