/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.core.policestory.miscfile;

import java.io.File;
import java.io.IOException;
import org.dbflute.helper.filesystem.FileHierarchyTracer;
import org.dbflute.helper.filesystem.FileHierarchyTracingHandler;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.utflute.core.policestory.miscfile.PoliceStoryMiscFileHandler;

public class PoliceStoryMiscFileChase {
    protected final Object _testCase;
    protected final File _baseDir;

    public PoliceStoryMiscFileChase(Object testCase, File baseDir) {
        this._testCase = testCase;
        this._baseDir = baseDir;
    }

    public void chaseMiscFile(PoliceStoryMiscFileHandler handler) {
        try {
            this.doChase(this._baseDir, handler);
        }
        catch (RuntimeException e) {
            this.throwPoliceStoryOfTextFileChaseFailureException(this._baseDir, e);
        }
    }

    protected void throwPoliceStoryOfTextFileChaseFailureException(File baseDir, Exception cause) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Failed to chase the file.");
        br.addItem("Test Case");
        br.addElement(this._testCase);
        br.addItem("Base Directory");
        br.addElement((Object)baseDir);
        br.addItem("Exception");
        br.addElement(cause.getClass());
        br.addElement((Object)cause.getMessage());
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg, cause);
    }

    protected void doChase(File baseDir, final PoliceStoryMiscFileHandler handler) {
        if (!baseDir.exists()) {
            String msg = "The base directory does not exist: " + baseDir;
            throw new IllegalStateException(msg);
        }
        final String chaseFileExt = this.getChaseFileExt();
        this.createFileHierarchyTracer().trace(baseDir, new FileHierarchyTracingHandler(){

            public boolean isTargetFileOrDir(File currentFile) {
                if (currentFile.isDirectory()) {
                    return true;
                }
                if (chaseFileExt != null) {
                    return currentFile.getName().endsWith("." + chaseFileExt);
                }
                return true;
            }

            public void handleFile(File currentFile) throws IOException {
                handler.handle(currentFile);
            }
        });
    }

    protected FileHierarchyTracer createFileHierarchyTracer() {
        return new FileHierarchyTracer();
    }

    protected String getChaseFileExt() {
        return null;
    }
}

