/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.lastaflute;

import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.Enumeration;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Resource;
import javax.servlet.FilterConfig;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.sql.DataSource;
import org.dbflute.hook.AccessContext;
import org.dbflute.utflute.lastadi.LastaDiTestCase;
import org.dbflute.utflute.lastaflute.mail.MailMessageAssertion;
import org.dbflute.utflute.lastaflute.mail.TestingMailData;
import org.dbflute.utflute.mocklet.MockletServletConfig;
import org.dbflute.utflute.mocklet.MockletServletConfigImpl;
import org.dbflute.utflute.mocklet.MockletServletContext;
import org.dbflute.utflute.mocklet.MockletServletContextImpl;
import org.dbflute.util.DfTypeUtil;
import org.lastaflute.core.direction.FwAssistantDirector;
import org.lastaflute.core.json.JsonManager;
import org.lastaflute.core.magic.ThreadCacheContext;
import org.lastaflute.core.magic.destructive.BowgunDestructiveAdjuster;
import org.lastaflute.core.time.SimpleTimeManager;
import org.lastaflute.db.dbflute.accesscontext.PreparedAccessContext;
import org.lastaflute.di.core.factory.SingletonLaContainerFactory;
import org.lastaflute.web.LastaFilter;
import org.lastaflute.web.response.JsonResponse;

public abstract class LastaFluteTestCase
extends LastaDiTestCase {
    private static MockletServletConfig _xcachedServletConfig;
    protected static Boolean _xexistsLastaJob;
    protected static boolean _xjobSchedulingSuppressed;
    @Resource
    private DataSource _xdataSource;
    private MailMessageAssertion _xmailMessageAssertion;

    @Override
    protected boolean xisSuppressTestCaseAccessContext() {
        return true;
    }

    @Override
    protected void xsetupBeforeTestCaseContainer() {
        this.xsuppressJobSchedulingIfNeeds();
        super.xsetupBeforeTestCaseContainer();
    }

    @Override
    protected void xsetupAfterTestCaseContainer() {
        super.xsetupAfterTestCaseContainer();
        if (this.isUseJobScheduling()) {
            this.xrebootJobSchedulingIfNeeds();
        }
        this.initializeAssistantDirector();
    }

    protected void initializeAssistantDirector() {
        FwAssistantDirector director = this.getComponent(FwAssistantDirector.class);
        director.assistCoreDirection().assistCurtainBeforeHook().hook(director);
    }

    @Override
    protected void xsetupBeforeTestCaseInjection() {
        super.xsetupBeforeTestCaseInjection();
        this.initializeThreadCacheContext();
        this.initializePreparedAccessContext();
    }

    protected void initializeThreadCacheContext() {
        ThreadCacheContext.initialize();
    }

    protected void initializePreparedAccessContext() {
        PreparedAccessContext.setAccessContextOnThread((AccessContext)this.createPreparedAccessContext());
    }

    protected AccessContext createPreparedAccessContext() {
        return this.createTestCaseAccessContext();
    }

    @Override
    protected void postTest() {
        super.postTest();
        this.xprocessMailAssertion();
    }

    @Override
    public void tearDown() throws Exception {
        this.xdestroyJobSchedulingIfNeeds();
        super.tearDown();
        ThreadCacheContext.clear();
        if (BowgunDestructiveAdjuster.hasAnyBowgun()) {
            BowgunDestructiveAdjuster.unlock();
            BowgunDestructiveAdjuster.restoreBowgunAll();
        }
    }

    @Override
    protected boolean isUseOneTimeContainer() {
        return this.maybeContainerResourceOverridden();
    }

    protected boolean maybeContainerResourceOverridden() {
        return this.xisMethodOverridden("prepareMockContextPath", new Class[0]);
    }

    protected boolean xisMethodOverridden(String methodName, Class<?> ... argTypes) {
        try {
            ((Object)((Object)this)).getClass().getDeclaredMethod(methodName, argTypes);
            return true;
        }
        catch (NoSuchMethodException ignored) {
            return false;
        }
    }

    @Override
    protected boolean xisTreatedAsWebContainer() {
        return true;
    }

    @Override
    protected void xinitializeContainer(String configFile) {
        this.log("...Initializing Lasta Di via LastaFlute: " + configFile);
        this.xdoInitializeContainerViaLastaFlute(configFile);
    }

    protected void xdoInitializeContainerViaLastaFlute(String configFile) {
        SingletonLaContainerFactory.setConfigPath((String)configFile);
        final ServletConfig servletConfig = this.xprepareMockServletConfig(configFile);
        LastaFilter filter = this.xcreateLastaFilter();
        try {
            filter.init(new FilterConfig(){

                public String getFilterName() {
                    return "containerFilter";
                }

                public ServletContext getServletContext() {
                    return servletConfig.getServletContext();
                }

                public Enumeration<String> getInitParameterNames() {
                    return null;
                }

                public String getInitParameter(String name) {
                    return null;
                }
            });
        }
        catch (ServletException e) {
            String msg = "Failed to initialize servlet config to servlet: " + servletConfig;
            throw new IllegalStateException(msg, e.getRootCause());
        }
    }

    @Override
    protected void xdestroyContainer() {
        super.xdestroyContainer();
        this.xclearServletConfig();
    }

    protected ServletConfig xprepareMockServletConfig(String configFile) {
        _xcachedServletConfig = this.createMockletServletConfig();
        _xcachedServletConfig.setServletContext(this.createMockletServletContext());
        return _xcachedServletConfig;
    }

    protected LastaFilter xcreateLastaFilter() {
        return new LastaFilter();
    }

    protected MockletServletConfig createMockletServletConfig() {
        return new MockletServletConfigImpl();
    }

    protected MockletServletContext createMockletServletContext() {
        return new MockletServletContextImpl(this.prepareMockContextPath());
    }

    protected String prepareMockContextPath() {
        return "/utcontext";
    }

    protected void xclearServletConfig() {
        _xcachedServletConfig = null;
    }

    @Override
    protected void xprepareCannonballBeginning() {
        super.xprepareCannonballBeginning();
        this.initializeThreadCacheContext();
    }

    @Override
    protected void xprepareCannonballAccessContext() {
        this.initializePreparedAccessContext();
    }

    protected void showJson(Object jsonBean) {
        this.log(jsonBean.getClass().getSimpleName() + ":" + this.ln() + this.toJson(jsonBean));
    }

    protected String toJson(Object jsonBean) {
        Object realBean = jsonBean instanceof JsonResponse ? ((JsonResponse)jsonBean).getJsonBean() : jsonBean;
        return this.getComponent(JsonManager.class).toJson(realBean);
    }

    protected void reserveMailAssertion(Consumer<TestingMailData> dataLambda) {
        this._xmailMessageAssertion = new MailMessageAssertion(dataLambda);
    }

    protected void xprocessMailAssertion() {
        if (this._xmailMessageAssertion != null) {
            this._xmailMessageAssertion.assertMailData();
            this._xmailMessageAssertion = null;
        }
    }

    protected void changeAsyncToNormalSync() {
        BowgunDestructiveAdjuster.unlock();
        BowgunDestructiveAdjuster.shootBowgunAsyncToNormalSync();
    }

    protected void restoreAsyncToNormalSync() {
        BowgunDestructiveAdjuster.unlock();
        BowgunDestructiveAdjuster.restoreBowgunAsyncToNormalSync();
    }

    protected void changeRequiresNewToRequired() {
        BowgunDestructiveAdjuster.unlock();
        BowgunDestructiveAdjuster.shootBowgunRequiresNewToRequired();
    }

    protected void restoreRequiresNewToRequired() {
        BowgunDestructiveAdjuster.unlock();
        BowgunDestructiveAdjuster.restoreBowgunRequiresNewToRequired();
    }

    @Override
    protected void switchCurrentDate(Supplier<LocalDateTime> dateTimeSupplier) {
        super.switchCurrentDate(dateTimeSupplier);
        SimpleTimeManager.unlock();
        SimpleTimeManager.shootBowgunCurrentTimeProvider(() -> DfTypeUtil.toDate(dateTimeSupplier.get()).getTime());
    }

    @Override
    protected void xclearSwitchedCurrentDate() {
        if (this.xisUseSwitchedCurrentDate()) {
            SimpleTimeManager.unlock();
            SimpleTimeManager.shootBowgunCurrentTimeProvider(null);
        }
        super.xclearSwitchedCurrentDate();
    }

    protected void xsuppressJobSchedulingIfNeeds() {
        if (!this.xexistsLastaJob()) {
            return;
        }
        if (_xjobSchedulingSuppressed) {
            return;
        }
        _xjobSchedulingSuppressed = true;
        try {
            Class<?> jobManagerType = Class.forName("org.lastaflute.job.SimpleJobManager");
            Method unlockMethod = jobManagerType.getMethod("unlock", null);
            unlockMethod.invoke(null, (Object[])null);
            Method shootMethod = jobManagerType.getMethod("shootBowgunEmptyScheduling", null);
            shootMethod.invoke(null, (Object[])null);
        }
        catch (Exception continued) {
            this.log("*Failed to suppress job scheduling", continued);
        }
    }

    protected boolean isUseJobScheduling() {
        return false;
    }

    protected void xrebootJobSchedulingIfNeeds() {
        if (!this.xexistsLastaJob()) {
            return;
        }
        try {
            Class<?> jobManagerType = LastaFluteTestCase.xforNameJobManager();
            Object jobManager = this.getComponent(jobManagerType);
            if (!this.xisJobSchedulingDone(jobManagerType, jobManager)) {
                this.xcallNoArgInstanceJobMethod(jobManagerType, jobManager, "reboot");
            }
        }
        catch (Exception continued) {
            this.log("*Failed to reboot job scheduling", continued);
        }
    }

    protected void xdestroyJobSchedulingIfNeeds() {
        if (!this.xexistsLastaJob()) {
            return;
        }
        try {
            Object jobManager;
            Class<?> jobManagerType = LastaFluteTestCase.xforNameJobManager();
            if (this.hasComponent(jobManagerType) && this.xisJobSchedulingDone(jobManagerType, jobManager = this.getComponent(jobManagerType))) {
                this.xcallNoArgInstanceJobMethod(jobManagerType, jobManager, "destroy");
            }
        }
        catch (Exception continued) {
            this.log("*Failed to destroy job scheduling", continued);
        }
    }

    protected static Class<?> xforNameJobManager() throws ClassNotFoundException {
        return Class.forName("org.lastaflute.job.JobManager");
    }

    protected boolean xisJobSchedulingDone(Class<?> jobManagerType, Object jobManager) throws ReflectiveOperationException {
        return (Boolean)this.xcallNoArgInstanceJobMethod(jobManagerType, jobManager, "isSchedulingDone");
    }

    private Object xcallNoArgInstanceJobMethod(Class<?> jobManagerType, Object jobManager, String methodName) throws ReflectiveOperationException {
        Method rebootMethod = jobManagerType.getMethod(methodName, null);
        return rebootMethod.invoke(jobManager, (Object[])null);
    }

    protected boolean xexistsLastaJob() {
        if (_xexistsLastaJob != null) {
            return _xexistsLastaJob;
        }
        try {
            LastaFluteTestCase.xforNameJobManager();
            _xexistsLastaJob = true;
        }
        catch (ClassNotFoundException e) {
            _xexistsLastaJob = false;
        }
        return _xexistsLastaJob;
    }

    @Override
    protected DataSource getDataSource() {
        return this._xdataSource;
    }

    protected static MockletServletConfig xgetCachedServletConfig() {
        return _xcachedServletConfig;
    }

    protected static void xsetCachedServletConfig(MockletServletConfig xcachedServletConfig) {
        _xcachedServletConfig = xcachedServletConfig;
    }

    protected MailMessageAssertion xgetMailMessageValidator() {
        return this._xmailMessageAssertion;
    }

    protected void xsetMailMessageValidator(MailMessageAssertion xmailMessageValidator) {
        this._xmailMessageAssertion = xmailMessageValidator;
    }
}

