/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.lastaflute;

import java.util.HashSet;
import java.util.function.Consumer;
import javax.annotation.Resource;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.dbflute.helper.function.IndependentProcessor;
import org.dbflute.utflute.lastaflute.LastaFluteTestCase;
import org.dbflute.utflute.lastaflute.mock.MockResopnseBeanValidator;
import org.dbflute.utflute.lastaflute.mock.MockRuntimeFactory;
import org.dbflute.utflute.lastaflute.mock.TestingHtmlData;
import org.dbflute.utflute.lastaflute.mock.TestingJsonData;
import org.dbflute.utflute.lastaflute.validation.TestingValidationErrorAfter;
import org.dbflute.utflute.mocklet.MockletHttpServletRequest;
import org.dbflute.utflute.mocklet.MockletHttpServletRequestImpl;
import org.dbflute.utflute.mocklet.MockletHttpServletResponse;
import org.dbflute.utflute.mocklet.MockletHttpServletResponseImpl;
import org.dbflute.utflute.mocklet.MockletHttpSession;
import org.dbflute.utflute.mocklet.MockletServletConfig;
import org.lastaflute.core.direction.FwAssistantDirector;
import org.lastaflute.core.magic.ThreadCacheContext;
import org.lastaflute.core.message.MessageManager;
import org.lastaflute.di.core.ExternalContext;
import org.lastaflute.di.core.LaContainer;
import org.lastaflute.di.core.factory.SingletonLaContainerFactory;
import org.lastaflute.meta.DocumentGenerator;
import org.lastaflute.meta.SwaggerGenerator;
import org.lastaflute.meta.agent.yourswagger.YourSwaggerSyncAgent;
import org.lastaflute.meta.agent.yourswagger.YourSwaggerSyncOption;
import org.lastaflute.meta.swagger.web.LaActionSwaggerable;
import org.lastaflute.web.response.ActionResponse;
import org.lastaflute.web.response.HtmlResponse;
import org.lastaflute.web.response.JsonResponse;
import org.lastaflute.web.ruts.process.ActionRuntime;
import org.lastaflute.web.servlet.request.RequestManager;
import org.lastaflute.web.token.DoubleSubmitManager;
import org.lastaflute.web.token.DoubleSubmitTokenMap;
import org.lastaflute.web.validation.exception.ValidationErrorException;

public abstract class WebContainerTestCase
extends LastaFluteTestCase {
    private MockletHttpServletRequest _xmockRequest;
    private MockletHttpServletResponse _xmockResponse;
    @Resource
    private FwAssistantDirector _assistantDirector;
    @Resource
    private MessageManager _messageManager;
    @Resource
    private RequestManager _requestManager;
    @Resource
    private DoubleSubmitManager _doubleSubmitManager;

    @Override
    protected void xprepareTestCaseContainer() {
        super.xprepareTestCaseContainer();
        if (!this.isSuppressRequestMock()) {
            this.xdoPrepareRequestMockContext();
        }
    }

    protected boolean isSuppressRequestMock() {
        return false;
    }

    protected void xdoPrepareRequestMockContext() {
        MockletServletConfig servletConfig = WebContainerTestCase.xgetCachedServletConfig();
        if (servletConfig != null) {
            this.xregisterRequestMockContext(servletConfig);
        }
    }

    protected void xregisterRequestMockContext(MockletServletConfig servletConfig) {
        LaContainer container = SingletonLaContainerFactory.getContainer();
        ExternalContext externalContext = container.getExternalContext();
        MockletHttpServletRequest request = this.createMockletHttpServletRequest(servletConfig.getServletContext());
        MockletHttpServletResponse response = this.createMockletHttpServletResponse(request);
        externalContext.setRequest((Object)request);
        externalContext.setResponse((Object)response);
        this.xkeepMockRequestInstance(request, response);
    }

    protected MockletHttpServletRequest createMockletHttpServletRequest(ServletContext servletContext) {
        return new MockletHttpServletRequestImpl(servletContext, this.prepareMockServletPath());
    }

    protected MockletHttpServletResponse createMockletHttpServletResponse(HttpServletRequest request) {
        return new MockletHttpServletResponseImpl(request);
    }

    protected String prepareMockServletPath() {
        return "/utservlet";
    }

    protected void xkeepMockRequestInstance(MockletHttpServletRequest request, MockletHttpServletResponse response) {
        this._xmockRequest = request;
        this._xmockResponse = response;
    }

    @Override
    protected boolean maybeContainerResourceOverridden() {
        return super.maybeContainerResourceOverridden() || this.xisMethodOverridden("prepareMockServletPath", new Class[0]);
    }

    @Override
    protected void xdestroyTestCaseContainer() {
        this.xclearRequestMockContext();
        super.xdestroyTestCaseContainer();
    }

    protected void xclearRequestMockContext() {
        LaContainer container = SingletonLaContainerFactory.getContainer();
        ExternalContext externalContext = container.getExternalContext();
        if (externalContext != null) {
            externalContext.setRequest(null);
            externalContext.setResponse(null);
        }
        this.xreleaseMockRequestInstance();
    }

    protected void xreleaseMockRequestInstance() {
        this._xmockRequest = null;
        this._xmockResponse = null;
    }

    protected ActionRuntime getMockHtmlRuntime() {
        return new MockRuntimeFactory().createHtmlRuntime();
    }

    protected ActionRuntime getMockJsonRuntime() {
        return new MockRuntimeFactory().createJsonRuntime();
    }

    protected MockletHttpServletRequest getMockRequest() {
        return this._xmockRequest;
    }

    protected void addMockRequestHeader(String name, String value) {
        MockletHttpServletRequest request = this.getMockRequest();
        if (request != null) {
            request.addHeader(name, value);
        }
    }

    protected <ATTRIBUTE> ATTRIBUTE getMockRequestParameter(String name) {
        MockletHttpServletRequest request = this.getMockRequest();
        return (ATTRIBUTE)(request != null ? request.getParameter(name) : null);
    }

    protected void addMockRequestParameter(String name, String value) {
        MockletHttpServletRequest request = this.getMockRequest();
        if (request != null) {
            request.addParameter(name, value);
        }
    }

    protected <ATTRIBUTE> ATTRIBUTE getMockRequestAttribute(String name) {
        MockletHttpServletRequest request = this.getMockRequest();
        return (ATTRIBUTE)(request != null ? request.getAttribute(name) : null);
    }

    protected void setMockRequestAttribute(String name, Object value) {
        MockletHttpServletRequest request = this.getMockRequest();
        if (request != null) {
            request.setAttribute(name, value);
        }
    }

    protected MockletHttpServletResponse getMockResponse() {
        return this._xmockResponse;
    }

    protected Cookie[] getMockResponseCookies() {
        MockletHttpServletResponse response = this.getMockResponse();
        return response != null ? response.getCookies() : null;
    }

    protected int getMockResponseStatus() {
        MockletHttpServletResponse response = this.getMockResponse();
        return response != null ? response.getStatus() : 0;
    }

    protected String getMockResponseString() {
        MockletHttpServletResponse response = this.getMockResponse();
        return response != null ? response.getResponseString() : null;
    }

    protected MockletHttpSession getMockSession() {
        return this._xmockRequest != null ? (MockletHttpSession)this._xmockRequest.getSession(true) : null;
    }

    protected void invalidateMockSession() {
        MockletHttpSession session = this.getMockSession();
        if (session != null) {
            session.invalidate();
        }
    }

    protected <ATTRIBUTE> ATTRIBUTE getMockSessionAttribute(String name) {
        MockletHttpSession session = this.getMockSession();
        return (ATTRIBUTE)(session != null ? session.getAttribute(name) : null);
    }

    protected void setMockSessionAttribute(String name, Object value) {
        MockletHttpSession session = this.getMockSession();
        if (session != null) {
            session.setAttribute(name, value);
        }
    }

    protected TestingHtmlData validateHtmlData(HtmlResponse response) {
        return new MockResopnseBeanValidator(this._requestManager).validateHtmlData(response);
    }

    protected <BEAN> TestingJsonData<BEAN> validateJsonData(JsonResponse<BEAN> response) {
        return new MockResopnseBeanValidator(this._requestManager).validateJsonData(response);
    }

    protected TestingValidationErrorAfter assertValidationError(IndependentProcessor noArgInLambda) {
        HashSet causeSet = new HashSet();
        this.assertException(ValidationErrorException.class, () -> noArgInLambda.process()).handle(cause -> causeSet.add(cause));
        return new TestingValidationErrorAfter((ValidationErrorException)causeSet.iterator().next(), this._messageManager, this._requestManager);
    }

    protected <RESPONSE extends ActionResponse> RESPONSE hookValidationError(ValidationErrorException cause) {
        return (RESPONSE)cause.getErrorHook().hook();
    }

    protected void assertTokenSaved(Class<?> groupType) {
        DoubleSubmitTokenMap tokenMap = (DoubleSubmitTokenMap)this._doubleSubmitManager.getSessionTokenMap().get();
        boolean condition = tokenMap.get(groupType).isPresent();
        WebContainerTestCase.assertTrue((String)("Not found the transaction token saved in session, so call saveToken(): tokenMap=" + tokenMap), (boolean)condition);
    }

    protected void mockTokenRequested(Class<?> groupType) {
        String savedToken = this._doubleSubmitManager.saveToken(groupType);
        this.getMockRequest().setParameter("lastaflute.action.TRANSACTION_TOKEN", savedToken);
    }

    protected void mockTokenRequestedAsDoubleSubmit(Class<?> groupType) {
        String savedToken = this._doubleSubmitManager.saveToken(groupType);
        this.getMockRequest().setParameter("lastaflute.action.TRANSACTION_TOKEN", savedToken);
        this._doubleSubmitManager.verifyToken(groupType, () -> {
            throw new IllegalStateException("no way");
        });
    }

    protected void assertTokenVerified() {
        boolean condition = this._doubleSubmitManager.isFirstSubmittedRequest();
        WebContainerTestCase.assertTrue((String)"Not found the transaction token verification, so call verifyToken().", (boolean)condition);
    }

    protected void mockHtmlValidateCall() {
        ThreadCacheContext.registerValidatorErrorHook(() -> ActionResponse.undefined());
    }

    protected void saveLastaDocMeta() {
        this.createDocumentGenerator().saveLastaDocMeta();
    }

    protected DocumentGenerator createDocumentGenerator() {
        return new DocumentGenerator();
    }

    protected void saveSwaggerMeta(LaActionSwaggerable swaggerable) {
        WebContainerTestCase.assertNotNull((Object)swaggerable);
        this.inject(swaggerable);
        this.createSwaggerGenerator().saveSwaggerMeta(swaggerable);
    }

    protected SwaggerGenerator createSwaggerGenerator() {
        return new SwaggerGenerator();
    }

    protected void verifyYourSwaggerSync(String locationPath, Consumer<YourSwaggerSyncOption> opLambda) {
        this.createYourSwaggerSyncAgent().verifyYourSwaggerSync(locationPath, opLambda);
    }

    protected YourSwaggerSyncAgent createYourSwaggerSyncAgent() {
        return new YourSwaggerSyncAgent();
    }

    protected MockletHttpServletRequest xgetMockRequest() {
        return this._xmockRequest;
    }

    protected void xsetMockRequest(MockletHttpServletRequest xmockRequest) {
        this._xmockRequest = xmockRequest;
    }

    protected MockletHttpServletResponse xgetMockResponse() {
        return this._xmockResponse;
    }

    protected void xsetMockResponse(MockletHttpServletResponse xmockResponse) {
        this._xmockResponse = xmockResponse;
    }
}

