/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.lastaflute.mail;

import java.util.Map;
import java.util.function.Consumer;
import junit.framework.Assert;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.mail.CardView;
import org.dbflute.mail.send.hook.SMailCallbackContext;
import org.dbflute.mail.send.hook.SMailPreparedMessageHook;
import org.dbflute.mail.send.supplement.SMailPostingDiscloser;
import org.dbflute.utflute.lastaflute.mail.TestingMailData;
import org.dbflute.utflute.lastaflute.mail.TestingPreparedMessage;

public class MailMessageAssertion {
    protected final Consumer<TestingMailData> _testingMailDataCall;
    protected final TestingMailData _testingMailData;

    public MailMessageAssertion(Consumer<TestingMailData> oneArgLambda) {
        if (oneArgLambda == null) {
            throw new IllegalArgumentException("The argument 'oneArgLambda' should not be null.");
        }
        this._testingMailDataCall = oneArgLambda;
        this._testingMailData = this.newTestingMailData();
        this.hookMessageSaving();
    }

    protected TestingMailData newTestingMailData() {
        return new TestingMailData();
    }

    protected void hookMessageSaving() {
        SMailCallbackContext.clearPreparedMessageHookOnThread();
        SMailCallbackContext.setPreparedMessageHookOnThread((SMailPreparedMessageHook)new SMailPreparedMessageHook(){

            public void hookPreparedMessage(CardView cardView, SMailPostingDiscloser discloser) {
                TestingPreparedMessage message = new TestingPreparedMessage(cardView, discloser);
                MailMessageAssertion.this.assertBasicCorrectness(cardView, discloser);
                MailMessageAssertion.this._testingMailData.saveMessage((Class)cardView.getMessageTheme().get(), message);
            }
        });
    }

    protected void assertBasicCorrectness(CardView cardView, SMailPostingDiscloser discloser) {
        discloser.getSavedPlainText().ifPresent(subject -> this.assertNotContainsMistakeComment(cardView, discloser, "subject", (String)subject));
        discloser.getSavedPlainText().ifPresent(plainText -> this.assertNotContainsMistakeComment(cardView, discloser, "plainText", (String)plainText));
        discloser.getSavedHtmlText().ifPresent(htmlText -> this.assertNotContainsMistakeComment(cardView, discloser, "htmlText", (String)htmlText));
    }

    protected void assertNotContainsMistakeComment(CardView cardView, SMailPostingDiscloser discloser, String title, String text) {
        String lowerText = text.toLowerCase();
        this.assertNoMistakePlaceholder(cardView, discloser, title, lowerText, "/*pmb.");
        this.assertNoMistakePlaceholder(cardView, discloser, title, lowerText, "/* pmb.");
        this.assertNoMistakePlaceholder(cardView, discloser, title, lowerText, "/*pnb.");
        this.assertNoMistakePlaceholder(cardView, discloser, title, lowerText, "/* pnb.");
        this.assertNoMistakePlaceholder(cardView, discloser, title, lowerText, "/*pmd.");
        this.assertNoMistakePlaceholder(cardView, discloser, title, lowerText, "/* pmd.");
    }

    protected void assertNoMistakePlaceholder(CardView cardView, SMailPostingDiscloser discloser, String title, String lowerText, String keyword) {
        boolean result = lowerText.contains(keyword);
        if (result) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("Detected the mistake placeholder in the mail message.");
            br.addItem("Advice");
            br.addElement((Object)"Fix your mistake placeholder like this:");
            br.addElement((Object)"For example:");
            br.addElement((Object)"  (x):");
            br.addElement((Object)"    /* pmb.xxx */");
            br.addElement((Object)"    /*pnb.xxx*/");
            br.addElement((Object)"    /*pmd.xxx*/");
            br.addElement((Object)"  (o):");
            br.addElement((Object)"    /*pmb.xxx*/");
            br.addItem("Mistake Placeholder");
            br.addElement((Object)keyword);
            br.addItem("Checked Text Part");
            br.addElement((Object)title);
            br.addItem("Your Postcard");
            br.addElement(this.toPostcardDisp(discloser));
            String msg = br.buildExceptionMessage();
            this.fail(msg);
        }
    }

    public void assertMailData() {
        SMailCallbackContext.clearPreparedMessageHookOnThread();
        if (this._testingMailData.isEmpty()) {
            this.throwMailSendingNotFoundException();
        } else {
            this._testingMailDataCall.accept(this._testingMailData);
        }
    }

    protected void throwMailSendingNotFoundException() {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Not found the mail sending in this test case.");
        br.addItem("Advice");
        br.addElement((Object)"Make sure your mail sending logic. (really send?)");
        br.addElement((Object)"Or call the validation method before your sending logic.");
        br.addElement((Object)"For example:");
        br.addElement((Object)"  (x):");
        br.addElement((Object)"    HtmlResponse response = action.index(...); // mail here");
        br.addElement((Object)"    reserveMailAssertion(mailData -> { // *Bad");
        br.addElement((Object)"        ...");
        br.addElement((Object)"    });");
        br.addElement((Object)"  (o):");
        br.addElement((Object)"    reserveMailAssertion(mailData -> { // Good");
        br.addElement((Object)"        ...");
        br.addElement((Object)"    });");
        br.addElement((Object)"    HtmlResponse response = action.index(...); // mail here");
        String msg = br.buildExceptionMessage();
        this.fail(msg);
    }

    protected void fail(String msg) {
        Assert.fail((String)msg);
    }

    protected Object toPostcardDisp(SMailPostingDiscloser discloser) {
        Map loggingMap = discloser.getOfficeManagedLoggingMap();
        Map sysinfoMap = (Map)loggingMap.get("sysInfo");
        return sysinfoMap != null ? sysinfoMap : loggingMap;
    }
}

