/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.lastaflute.mock;

import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.dbflute.optional.OptionalThing;
import org.lastaflute.core.util.ContainerUtil;
import org.lastaflute.web.path.ActionPathResolver;
import org.lastaflute.web.response.next.ForwardNext;
import org.lastaflute.web.response.next.HtmlNext;
import org.lastaflute.web.response.next.RedirectNext;
import org.lastaflute.web.response.next.RoutingNext;

public class TestingHtmlData {
    protected final RoutingNext _nextRouting;
    protected final Map<String, Object> _dataMap;
    protected final OptionalThing<Object> _pushedForm;

    public TestingHtmlData(RoutingNext nextRouting, Map<String, Object> dataMap, OptionalThing<Object> pushedForm) {
        this._nextRouting = nextRouting;
        this._dataMap = dataMap;
        this._pushedForm = pushedForm;
    }

    public void assertHtmlForward(HtmlNext htmlNext) {
        this.assertTrue("Not HTML forward response: " + this._nextRouting, this.isRoutingAsHtmlForward());
        this.assertEquals(htmlNext.getRoutingPath(), this._nextRouting.getRoutingPath());
    }

    public void assertRedirect(Class<?> actionType) {
        this.assertTrue("Not redirect response: " + this._nextRouting, this.isRoutingAsRedirect());
        this.doAssertRedirectOrForward("redirect", actionType);
    }

    public void assertSimpleForward(Class<?> actionType) {
        this.assertTrue("Not (simple) forward response: " + this._nextRouting, this.isRoutingAsSimpleForward());
        this.doAssertRedirectOrForward("forward", actionType);
    }

    protected void doAssertRedirectOrForward(String type, Class<?> actionType) {
        String actionUrl = this.toActionUrl(actionType);
        String routingPath = this._nextRouting.getRoutingPath();
        boolean result = routingPath.startsWith(actionUrl);
        this.assertTrue("Wrong action " + type + ": expected=" + actionUrl + ", actual" + routingPath, result);
    }

    protected String toActionUrl(Class<?> actionType) {
        return this.getActionPathResolver().toActionUrl(actionType);
    }

    public boolean isRoutingAsHtmlForward() {
        return this._nextRouting instanceof HtmlNext;
    }

    public boolean isRoutingAsRedirect() {
        return this._nextRouting instanceof RedirectNext;
    }

    public boolean isRoutingAsSimpleForward() {
        return this._nextRouting instanceof ForwardNext;
    }

    public <VALUE> VALUE required(String key, Class<VALUE> valueType) {
        Object value = this._dataMap.get(key);
        this.assertTrue("Not found the value: key=" + key + ", dataMap=" + this._dataMap.keySet(), value != null);
        Class<?> actualType = value.getClass();
        this.assertTrue("Cannot cast the value: expected=" + valueType + ", actual=" + actualType, valueType.isAssignableFrom(actualType));
        Object cast = value;
        return (VALUE)cast;
    }

    public <ELEMENT> List<ELEMENT> requiredList(String key, Class<ELEMENT> elementType) {
        List list = (List)this._dataMap.get(key);
        this.assertListNotNull(key, list);
        this.assertListHasAnyElement(key, list);
        this.assertListHasSpecifiedElementType(elementType, list);
        return list;
    }

    protected <ELEMENT> void assertListNotNull(String key, List<ELEMENT> list) {
        this.assertTrue("Not found the list: key=" + key + ", dataMap=" + this._dataMap.keySet(), list != null);
    }

    protected <ELEMENT> void assertListHasAnyElement(String key, List<ELEMENT> list) {
        this.assertTrue("Found the empty list: key=" + key, !list.isEmpty());
    }

    protected <ELEMENT> void assertListHasSpecifiedElementType(Class<ELEMENT> elementType, List<ELEMENT> list) {
        Class<?> firstType = list.get(0).getClass();
        boolean result = elementType.isAssignableFrom(firstType);
        this.assertTrue("Cannot cast the list element: expected=" + elementType + ", actual=" + firstType, result);
    }

    public <FORM> FORM requiredPushedForm(Class<FORM> formType) {
        this.assertTrue("Not found the pushed form: formType=" + formType, this._pushedForm.isPresent());
        Object form = this._pushedForm.get();
        return (FORM)form;
    }

    protected void assertEquals(Object expected, Object actual) {
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    protected void assertTrue(String msg, boolean condition) {
        Assert.assertTrue((String)msg, (boolean)condition);
    }

    protected ActionPathResolver getActionPathResolver() {
        return (ActionPathResolver)ContainerUtil.getComponent(ActionPathResolver.class);
    }

    public RoutingNext getNextRouting() {
        return this._nextRouting;
    }

    public Map<String, Object> getDataMap() {
        return this._dataMap;
    }

    public OptionalThing<Object> getPushedForm() {
        return this._pushedForm;
    }
}

