/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.lastaflute.police;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Resource;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.utflute.core.policestory.javaclass.PoliceStoryJavaClassHandler;
import org.dbflute.util.DfReflectionUtil;

public class InjectedResourceDefinitionPolice
implements PoliceStoryJavaClassHandler {
    protected boolean alwaysPrivateOrProtectedField;
    protected Predicate<Field> privateFieldDeterminer;

    @Override
    public void handle(File srcFile, Class<?> clazz) {
        List fieldList = DfReflectionUtil.getWholeFieldList(clazz);
        for (Field field : fieldList) {
            if (!field.isAnnotationPresent(Resource.class)) continue;
            this.check(clazz, field);
        }
    }

    protected void check(Class<?> targetType, Field targetField) {
        if (this.alwaysPrivateOrProtectedField && !this.isPrivate(targetField) && !this.isProtected(targetField)) {
            this.throwInjectedResourceNonPrivateOrProtectedFieldException(targetType, targetField);
        }
        if (this.privateFieldDeterminer != null && this.privateFieldDeterminer.test(targetField) && !this.isPrivate(targetField)) {
            this.throwInjectedResourceNonPrivateFieldException(targetType, targetField);
        }
    }

    protected void throwInjectedResourceNonPrivateOrProtectedFieldException(Class<?> targetType, Field targetField) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Non private or protected field for injected resource.");
        br.addItem("Advice");
        br.addElement((Object)"You should define @Resource field as priavte or protected.");
        br.addElement((Object)"For example:");
        br.addElement((Object)"  (x):");
        br.addElement((Object)"    @Resource");
        br.addElement((Object)"    public MemberBhv memberBhv; // *Bad");
        br.addElement((Object)"  (x):");
        br.addElement((Object)"    @Resource");
        br.addElement((Object)"    MemberBhv memberBhv; // *Bad");
        br.addElement((Object)"  (o):");
        br.addElement((Object)"    @Resource");
        br.addElement((Object)"    private MemberBhv memberBhv; // Good");
        br.addElement((Object)"  (o):");
        br.addElement((Object)"    @Resource");
        br.addElement((Object)"    protected MemberBhv memberBhv; // Good");
        br.addItem("Target Class");
        br.addElement(targetType);
        br.addItem("Target Field");
        br.addElement((Object)targetField);
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg);
    }

    protected void throwInjectedResourceNonPrivateFieldException(Class<?> targetType, Field targetField) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Non private field for injected resource.");
        br.addItem("Advice");
        br.addElement((Object)"You should define @Resource field as priavte.");
        br.addElement((Object)"For example:");
        br.addElement((Object)"  (x):");
        br.addElement((Object)"    @Resource");
        br.addElement((Object)"    public MemberBhv memberBhv; // *Bad");
        br.addElement((Object)"  (x):");
        br.addElement((Object)"    @Resource");
        br.addElement((Object)"    protected MemberBhv memberBhv; // *Bad");
        br.addElement((Object)"  (o):");
        br.addElement((Object)"    @Resource");
        br.addElement((Object)"    private MemberBhv memberBhv; // Good");
        br.addItem("Target Class");
        br.addElement(targetType);
        br.addItem("Target Field");
        br.addElement((Object)targetField);
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg);
    }

    public InjectedResourceDefinitionPolice alwaysPrivateOrProtectedField() {
        this.alwaysPrivateOrProtectedField = true;
        return this;
    }

    public InjectedResourceDefinitionPolice shouldBePrivateField(Predicate<Field> oneArgLambda) {
        this.privateFieldDeterminer = oneArgLambda;
        return this;
    }

    protected boolean isPrivate(Field field) {
        return Modifier.isPrivate(field.getModifiers());
    }

    protected boolean isProtected(Field field) {
        return Modifier.isProtected(field.getModifiers());
    }
}

