/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.lastaflute.police;

import java.io.File;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.utflute.core.filesystem.FilesystemPlayer;
import org.dbflute.utflute.core.policestory.javaclass.PoliceStoryJavaClassHandler;
import org.dbflute.util.Srl;
import org.lastaflute.web.servlet.cookie.CookieManager;
import org.lastaflute.web.servlet.request.RequestManager;
import org.lastaflute.web.servlet.request.ResponseManager;
import org.lastaflute.web.servlet.session.SessionManager;

public class NonWebHasWebReferencePolice
implements PoliceStoryJavaClassHandler {
    @Override
    public void handle(File srcFile, Class<?> clazz) {
        this.check(srcFile, clazz, this.getLogicKeyword());
        this.check(srcFile, clazz, this.getJobKeyword());
    }

    protected String getLogicKeyword() {
        return ".app.logic.";
    }

    protected String getJobKeyword() {
        return ".app.job.";
    }

    protected void check(File srcFile, Class<?> clazz, String packageKeyword) {
        if (!clazz.getName().contains(packageKeyword)) {
            return;
        }
        this.doCheck(srcFile, clazz, this.getAppWebPackageKeyword());
        this.doCheck(srcFile, clazz, this.getBizfwWebPackageKeyword());
        this.doCheck(srcFile, clazz, this.getMylastaWebPackageKeyword());
        this.doCheck(srcFile, clazz, this.getWebClsPackageKeyword());
    }

    protected String getAppWebPackageKeyword() {
        return ".app.web.";
    }

    protected String getBizfwWebPackageKeyword() {
        return ".bizfw.web.";
    }

    protected String getMylastaWebPackageKeyword() {
        return ".mylasta.web.";
    }

    protected String getWebClsPackageKeyword() {
        return ".mylasta.webcls.";
    }

    protected void doCheck(File srcFile, Class<?> clazz, String webPackageKeyword) {
        new FilesystemPlayer().readLine(srcFile, "UTF-8", line -> {
            if (line.startsWith("import ")) {
                String imported = this.extractImported(line);
                if (imported.contains(webPackageKeyword)) {
                    this.throwNonWebHasWebReferenceException(clazz, imported);
                }
                if (this.isWebComponent(imported)) {
                    this.throwNonWebHasWebReferenceException(clazz, imported);
                }
            }
        });
    }

    protected String extractImported(String line) {
        return Srl.substringFirstFront((String)Srl.ltrim((String)Srl.substringFirstRear((String)line, (String[])new String[]{"import "}), (String)"static "), (String[])new String[]{";"});
    }

    protected boolean isWebComponent(String imported) {
        return Srl.equalsPlain((String)imported, (String[])new String[]{RequestManager.class.getName(), ResponseManager.class.getName(), SessionManager.class.getName(), CookieManager.class.getName(), HttpServletRequest.class.getName(), HttpServletResponse.class.getName(), HttpSession.class.getName()});
    }

    protected void throwNonWebHasWebReferenceException(Class<?> componentType, Object target) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Web reference from the non-web object.");
        br.addItem("Advice");
        br.addElement((Object)"Non-web object should not refer web resources,");
        br.addElement((Object)" e.g. classes under 'app.web' package, RequestManager.");
        br.addElement((Object)"For example:");
        br.addElement((Object)"  (x):");
        br.addElement((Object)"    public class SeaLogic {");
        br.addElement((Object)"        @Resource");
        br.addElement((Object)"        private RequestManager requestManager; // *Bad");
        br.addElement((Object)"");
        br.addElement((Object)"        public void land(SeaForm form) { // *Bad");
        br.addElement((Object)"            ...");
        br.addElement((Object)"        }");
        br.addElement((Object)"    }");
        br.addItem("Non-Web Object");
        br.addElement(componentType);
        br.addItem("Web Reference");
        br.addElement(target);
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg);
    }
}

