/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.lastaflute.police;

import java.io.File;
import java.util.List;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.utflute.core.filesystem.FilesystemPlayer;
import org.dbflute.utflute.core.policestory.javaclass.PoliceStoryJavaClassHandler;
import org.dbflute.util.DfCollectionUtil;
import org.dbflute.util.Srl;

public class WebPackageNinjaReferencePolice
implements PoliceStoryJavaClassHandler {
    protected final List<String> parentChildSharedPackageList;

    public WebPackageNinjaReferencePolice() {
        List<String> sharedPackageList = this.prepareParentChildSharedPackageList();
        if (sharedPackageList == null) {
            throw new IllegalStateException("The sharedPackageList should not be null.");
        }
        this.parentChildSharedPackageList = sharedPackageList;
    }

    protected List<String> prepareParentChildSharedPackageList() {
        return DfCollectionUtil.newArrayList((Object[])new String[]{"assist"});
    }

    @Override
    public void handle(File srcFile, Class<?> clazz) {
        String webPackageKeyword = this.getWebPackageKeyword();
        if (!clazz.getName().contains(webPackageKeyword)) {
            return;
        }
        this.check(srcFile, clazz, webPackageKeyword);
    }

    protected String getWebPackageKeyword() {
        return ".app.web.";
    }

    protected void check(File srcFile, Class<?> clazz, String webPackageKeyword) {
        String myRearName = this.deriveMyRearName(clazz, webPackageKeyword);
        new FilesystemPlayer().readLine(srcFile, "UTF-8", line -> {
            String rearImported;
            String imported;
            if (line.startsWith("import ") && !line.startsWith("import static ") && (imported = this.extractImported(line)).contains(webPackageKeyword) && this.existsNinjaReference(clazz, myRearName, rearImported = Srl.substringFirstRear((String)imported, (String[])new String[]{webPackageKeyword}))) {
                this.throwWebPackageNinjaReferenceException(clazz, imported);
            }
        });
    }

    protected String deriveMyRearName(Class<?> clazz, String webPackageKeyword) {
        return Srl.substringFirstRear((String)clazz.getName(), (String[])new String[]{webPackageKeyword});
    }

    protected String deriveMyPackage(Class<?> clazz, String webPackageKeyword) {
        return Srl.substringFirstFront((String)Srl.substringFirstRear((String)clazz.getName(), (String[])new String[]{webPackageKeyword}), (String[])new String[]{"."});
    }

    protected String deriveMyRelativePackage(Class<?> clazz, String webPackageKeyword) {
        return Srl.substringLastFront((String)Srl.substringFirstRear((String)clazz.getName(), (String[])new String[]{webPackageKeyword}), (String[])new String[]{"."});
    }

    protected String extractImported(String line) {
        return Srl.substringFirstFront((String)Srl.ltrim((String)Srl.substringFirstRear((String)line, (String[])new String[]{"import "}), (String)"static "), (String[])new String[]{";"});
    }

    protected boolean existsNinjaReference(Class<?> clazz, String myRearName, String rearImported) {
        if (rearImported.contains(".")) {
            String yourRelativePackage;
            if (this.isFromRootClass(myRearName, rearImported)) {
                return false;
            }
            if (this.isReferingToAction(myRearName, rearImported)) {
                return false;
            }
            if (this.isReferingToCommonPackage(myRearName, rearImported)) {
                return false;
            }
            String myRelativePackage = Srl.substringLastFront((String)myRearName, (String[])new String[]{"."});
            return !this.hasParentChildRelationship(myRelativePackage, yourRelativePackage = this.extractYourRelativePackage(rearImported));
        }
        return false;
    }

    protected boolean isFromRootClass(String myRearName, String rearImported) {
        return !myRearName.contains(".");
    }

    protected boolean isReferingToAction(String myRearName, String rearImported) {
        return rearImported.endsWith("Action");
    }

    protected boolean isReferingToCommonPackage(String myRearName, String rearImported) {
        String firstPurePackage = Srl.substringFirstFront((String)rearImported, (String[])new String[]{"."});
        return firstPurePackage.equals("base") || firstPurePackage.equals("common");
    }

    protected String extractYourRelativePackage(String rearImported) {
        String yourRelativePackage = Srl.substringLastFront((String)rearImported, (String[])new String[]{"."});
        if (yourRelativePackage.contains(".") && Srl.isInitUpperCase((String)Srl.substringLastRear((String)yourRelativePackage, (String[])new String[]{"."}))) {
            yourRelativePackage = Srl.substringLastFront((String)yourRelativePackage, (String[])new String[]{"."});
        }
        return yourRelativePackage;
    }

    protected boolean hasParentChildRelationship(String myRelativePackage, String yourRelativePackage) {
        if (this.judgeParentChildPackage(myRelativePackage, yourRelativePackage)) {
            return true;
        }
        if (!this.parentChildSharedPackageList.isEmpty()) {
            for (String sharedPackage : this.parentChildSharedPackageList) {
                String yourRemoved;
                String myRemoved;
                String sharedSuffix = "." + sharedPackage;
                if (!myRelativePackage.endsWith(sharedSuffix) || !yourRelativePackage.endsWith(sharedSuffix) || !this.judgeParentChildPackage(myRemoved = Srl.substringLastFront((String)myRelativePackage, (String[])new String[]{sharedSuffix}), yourRemoved = Srl.substringLastFront((String)yourRelativePackage, (String[])new String[]{sharedSuffix}))) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean judgeParentChildPackage(String myRelativePackage, String yourRelativePackage) {
        return myRelativePackage.startsWith(yourRelativePackage) || yourRelativePackage.startsWith(myRelativePackage);
    }

    protected void throwWebPackageNinjaReferenceException(Class<?> targetType, Object reference) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("Ninja reference in web package.");
        br.addItem("Advice");
        br.addElement((Object)"Web resources cannot refer other business web resources");
        br.addElement((Object)"For example: (under app.web package)");
        br.addElement((Object)"  (x):");
        br.addElement((Object)"    land.LandAction refers sea.SeaForm");
        br.addElement((Object)"  (o):");
        br.addElement((Object)"    land.LandAction refers land.LandForm");
        br.addElement((Object)"    land.LandAction refers base.sea.SeaForm");
        br.addElement((Object)"    land.LandAction refers common.sea.SeaForm");
        this.setupParentChildSharedMessage(br);
        br.addItem("Source Type");
        br.addElement((Object)targetType.getName());
        br.addItem("Ninja Reference");
        br.addElement(reference);
        String msg = br.buildExceptionMessage();
        throw new IllegalStateException(msg);
    }

    protected void setupParentChildSharedMessage(ExceptionMessageBuilder br) {
        br.addElement((Object)"");
        br.addElement((Object)"While, shared packages e.g. 'assist' on parent-child relationship");
        br.addElement((Object)"can be shared each other.");
        br.addElement((Object)"You can customize it by overridding the police class.");
        br.addElement((Object)"For example:");
        br.addElement((Object)"  (x):");
        br.addElement((Object)"    sea.land.SeaLandAssist refers sea.assist.SeaAssist");
        br.addElement((Object)"    sea.assist.SeaAssist refers sea.land.SeaLandAssist");
        br.addElement((Object)"  (o):");
        br.addElement((Object)"    sea.land.assist.SeaLandAssist refers sea.assist.SeaAssist");
        br.addElement((Object)"    sea.assist.SeaAssist refers sea.land.assist.SeaLandAssist");
    }
}

