/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.lastaflute.validation;

import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.dbflute.helper.message.ExceptionMessageBuilder;
import org.dbflute.optional.OptionalThing;
import org.junit.Assert;
import org.lastaflute.core.message.MessageManager;
import org.lastaflute.core.message.UserMessage;
import org.lastaflute.core.message.UserMessages;
import org.lastaflute.web.response.ActionResponse;
import org.lastaflute.web.servlet.request.RequestManager;
import org.lastaflute.web.validation.exception.ValidationErrorException;
import org.lastaflute.web.validation.exception.ValidationSuccessAttributeCannotCastException;

public class TestingValidationData {
    protected final ValidationErrorException _cause;
    protected final MessageManager _messageManager;
    protected final RequestManager _requestManager;

    public TestingValidationData(ValidationErrorException cause, MessageManager messageManager, RequestManager requestManager) {
        this._cause = cause;
        this._messageManager = messageManager;
        this._requestManager = requestManager;
    }

    public void requiredMessageOf(String property, Class<? extends Annotation> annotationType) {
        if (property == null) {
            throw new IllegalArgumentException("The argument 'property' should not be null.");
        }
        if (annotationType == null) {
            throw new IllegalArgumentException("The argument 'annotationType' should not be null.");
        }
        UserMessages messages = this._cause.getMessages();
        Iterator ite = messages.silentAccessByIteratorOf(property);
        while (ite.hasNext()) {
            Annotation anno;
            UserMessage message = (UserMessage)ite.next();
            OptionalThing optAnno = message.getValidatorAnnotation();
            if (!optAnno.isPresent() || !annotationType.isAssignableFrom((anno = (Annotation)optAnno.get()).annotationType())) continue;
            return;
        }
        Assert.fail((String)this.buildNoValidationErrorMessage(messages, property, annotationType));
    }

    public void requiredMessageOf(String property, String messageKey) {
        if (property == null) {
            throw new IllegalArgumentException("The argument 'property' should not be null.");
        }
        if (messageKey == null) {
            throw new IllegalArgumentException("The argument 'messageKey' should not be null.");
        }
        UserMessages messages = this._cause.getMessages();
        if (!messages.hasMessageOf(property, messageKey)) {
            Assert.fail((String)this.buildNoValidationErrorMessage(messages, property, messageKey));
        }
    }

    public void requiredMessageOfDirectly(String property, String keyword) {
        if (property == null) {
            throw new IllegalArgumentException("The argument 'property' should not be null.");
        }
        if (keyword == null) {
            throw new IllegalArgumentException("The argument 'keyword' should not be null.");
        }
        UserMessages messages = this._cause.getMessages();
        Iterator ite = messages.silentAccessByIteratorOf(property);
        boolean found = false;
        while (ite.hasNext()) {
            UserMessage message = (UserMessage)ite.next();
            if (!message.getMessageKey().contains(keyword)) continue;
            found = true;
        }
        if (!found) {
            Assert.fail((String)this.buildNoValidationErrorMessageDirectly(messages, property, keyword));
        }
    }

    protected String buildNoValidationErrorMessage(UserMessages messages, String property, Class<? extends Annotation> annotationType) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("No validation error for the validator annotation.");
        br.addItem("Property");
        br.addElement((Object)property);
        br.addItem("Validator Annotation");
        br.addElement((Object)annotationType.getName());
        br.addItem("UserMessages");
        this.setupUserMessagesDisplay(messages, br);
        return br.buildExceptionMessage();
    }

    protected String buildNoValidationErrorMessage(UserMessages messages, String property, String messageKey) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("No validation error for the message key.");
        br.addItem("Property");
        br.addElement((Object)property);
        br.addItem("Message Key");
        br.addElement((Object)messageKey);
        br.addItem("UserMessages");
        this.setupUserMessagesDisplay(messages, br);
        return br.buildExceptionMessage();
    }

    protected String buildNoValidationErrorMessageDirectly(UserMessages messages, String property, String keyword) {
        ExceptionMessageBuilder br = new ExceptionMessageBuilder();
        br.addNotice("No validation error for the message key.");
        br.addItem("Property");
        br.addElement((Object)property);
        br.addItem("Keyword");
        br.addElement((Object)keyword);
        br.addItem("UserMessages");
        this.setupUserMessagesDisplay(messages, br);
        return br.buildExceptionMessage();
    }

    protected void setupUserMessagesDisplay(UserMessages messages, ExceptionMessageBuilder br) {
        Set propertySet = messages.toPropertySet();
        for (String current : propertySet) {
            br.addElement((Object)current);
            Iterator ite = messages.silentAccessByIteratorOf(current);
            while (ite.hasNext()) {
                UserMessage userMessage = (UserMessage)ite.next();
                br.addElement((Object)("  " + userMessage));
            }
        }
    }

    public <MESSAGES extends UserMessages> MESSAGES requiredMessages() {
        UserMessages messages = this._cause.getMessages();
        Assert.assertFalse((String)("No messages for validation error: " + this._cause), (boolean)messages.isEmpty());
        return (MESSAGES)messages;
    }

    public <ATTRIBUTE> ATTRIBUTE requiredSuccessAttribute(String key, Class<ATTRIBUTE> attributeType) {
        Map successAttributeMap = this._cause.getMessages().getSuccessAttributeMap();
        Object original = successAttributeMap.get(key);
        if (original == null) {
            Assert.fail((String)this.buildSuccessAttributeFailureMessage(successAttributeMap, key));
        }
        try {
            return attributeType.cast(original);
        }
        catch (ClassCastException e) {
            ExceptionMessageBuilder br = new ExceptionMessageBuilder();
            br.addNotice("Cannot cast the validation success attribute");
            br.addItem("Attribute Key");
            br.addElement((Object)key);
            br.addItem("Specified Type");
            br.addElement(attributeType);
            br.addItem("Existing Attribute");
            br.addElement(original.getClass());
            br.addElement(original);
            br.addItem("Attribute Map");
            br.addElement((Object)successAttributeMap);
            String msg = br.buildExceptionMessage();
            throw new ValidationSuccessAttributeCannotCastException(msg);
        }
    }

    protected String buildSuccessAttributeFailureMessage(Map<String, Object> successAttributeMap, String key) {
        return "Not found the success attribute: key=" + key + ", existing=" + successAttributeMap.keySet();
    }

    public <RESPONSE extends ActionResponse> RESPONSE hookError() {
        return (RESPONSE)this._cause.getErrorHook().hook();
    }

    protected String toDefinedMessageKey(Class<?> annotationType) {
        return "constraints." + annotationType.getSimpleName() + ".message";
    }

    public String toString() {
        return "{" + this._cause + "}";
    }

    public ValidationErrorException getCause() {
        return this._cause;
    }
}

