/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.mocklet;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSessionContext;
import org.dbflute.utflute.mocklet.MockletHttpSession;
import org.dbflute.utflute.mocklet.helper.MockletEnumerationAdapter;

public class MockletHttpSessionImpl
implements MockletHttpSession,
Serializable {
    private static final long serialVersionUID = 2182279632419560836L;
    protected final ServletContext servletContext;
    protected String id;
    protected final long creationTime;
    protected long lastAccessedTime;
    protected boolean new_;
    protected boolean valid;
    protected int maxInactiveInterval;
    protected final Map<String, Object> attributes;

    public MockletHttpSessionImpl(ServletContext servletContext) {
        this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
        this.new_ = true;
        this.valid = true;
        this.maxInactiveInterval = -1;
        this.attributes = new HashMap<String, Object>();
        this.servletContext = servletContext;
        this.id = this.prepareSessionId();
    }

    protected String prepareSessionId() {
        return String.valueOf(System.currentTimeMillis());
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    @Override
    public void access() {
        this.new_ = false;
        this.lastAccessedTime = System.currentTimeMillis();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    @Deprecated
    public HttpSessionContext getSessionContext() {
        return null;
    }

    @Deprecated
    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        return new MockletEnumerationAdapter<String>(this.attributes.keySet().iterator());
    }

    @Deprecated
    public String[] getValueNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    @Deprecated
    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    @Deprecated
    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void invalidate() {
        if (!this.valid) {
            return;
        }
        this.attributes.clear();
        this.valid = false;
        this.id = this.prepareSessionId();
    }

    public boolean isNew() {
        return this.new_;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void setValid(boolean valid) {
        this.valid = valid;
    }
}

