/*
 * Decompiled with CFR 0.152.
 */
package org.dbflute.utflute.mocklet;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.SessionCookieConfig;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import org.dbflute.utflute.mocklet.MockletHttpServletRequest;
import org.dbflute.utflute.mocklet.MockletHttpServletRequestImpl;
import org.dbflute.utflute.mocklet.MockletRequestDispatcherImpl;
import org.dbflute.utflute.mocklet.MockletServletContext;
import org.dbflute.utflute.mocklet.helper.MockletEnumerationAdapter;
import org.dbflute.util.DfResourceUtil;

public class MockletServletContextImpl
implements MockletServletContext,
Serializable {
    private static final long serialVersionUID = -5626752218858278823L;
    public static final int MAJOR_VERSION = 2;
    public static final int MINOR_VERSION = 4;
    public static final String SERVER_INFO = "utflute";
    protected String servletContextName;
    protected String contextPath;
    protected final Map<String, String> mimeTypes = new HashMap<String, String>();
    protected final Map<String, String> initParameters = new HashMap<String, String>();
    protected final Map<String, Object> attributes = new HashMap<String, Object>();

    public MockletServletContextImpl(String path) {
        if (path == null) {
            throw new IllegalArgumentException("The argument 'path' should not be null.");
        }
        this.contextPath = path;
    }

    public String getServletContextName() {
        return this.servletContextName;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public ServletContext getContext(String path) {
        throw new UnsupportedOperationException();
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 4;
    }

    public String getMimeType(String file) {
        return this.mimeTypes.get(file);
    }

    public Set<String> getResourcePaths(String path) {
        File file;
        path = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
        File src = this.getFile(DfResourceUtil.getResourceUrl((String)"."));
        File root = src.getParentFile();
        if (root.getName().equalsIgnoreCase("WEB-INF")) {
            root = root.getParentFile();
        }
        if (!(file = new File(root, this.adjustPath(path))).exists()) {
            int pos = path.lastIndexOf(47);
            if (pos != -1) {
                path = path.substring(pos + 1);
            }
            do {
                file = new File(root, path);
                root = root.getParentFile();
            } while (!file.exists() && root != null);
            path = "/" + path;
        }
        if (file.isDirectory()) {
            int len = file.getAbsolutePath().length();
            HashSet<String> paths = new HashSet<String>();
            File[] files = file.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    paths.add(path + files[i].getAbsolutePath().substring(len).replace('\\', '/'));
                }
                return paths;
            }
        }
        return null;
    }

    public URL getResource(String path) throws MalformedURLException {
        if (path == null) {
            return null;
        }
        path = this.adjustPath(path);
        File src = this.getFile(DfResourceUtil.getResourceUrl((String)"."));
        File root = src.getParentFile();
        if (root.getName().equalsIgnoreCase("WEB-INF")) {
            root = root.getParentFile();
        }
        while (root != null) {
            File file = new File(root, path);
            if (file.exists()) {
                return file.toURL();
            }
            root = root.getParentFile();
        }
        if (DfResourceUtil.isExist((String)path)) {
            return DfResourceUtil.getResourceUrl((String)path);
        }
        if (path.startsWith("WEB-INF")) {
            path = path.substring("WEB-INF".length());
            return this.getResource(path);
        }
        return null;
    }

    protected File getFile(URL url) {
        File file = new File(DfResourceUtil.getFileName((URL)url));
        if (file != null && file.exists()) {
            return file;
        }
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        if (path == null) {
            return null;
        }
        if (DfResourceUtil.isExist((String)(path = this.adjustPath(path)))) {
            return DfResourceUtil.getResourceStream((String)path);
        }
        if (path.startsWith("WEB-INF")) {
            path = path.substring("WEB-INF".length());
            return this.getResourceAsStream(path);
        }
        return null;
    }

    protected String adjustPath(String path) {
        if (path != null && path.length() > 0 && path.charAt(0) == '/') {
            return path.substring(1);
        }
        return path;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return new MockletRequestDispatcherImpl();
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Servlet getServlet(String name) throws ServletException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Enumeration<Servlet> getServlets() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public Enumeration<String> getServletNames() {
        throw new UnsupportedOperationException();
    }

    public void log(String message) {
        System.out.println(message);
    }

    @Deprecated
    public void log(Exception ex, String message) {
        System.out.println(message);
        ex.printStackTrace();
    }

    public void log(String message, Throwable t) {
        System.out.println(message);
        t.printStackTrace();
    }

    public String getRealPath(String path) {
        try {
            return DfResourceUtil.getResourceUrl((String)this.adjustPath(path)).getFile();
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public String getServerInfo() {
        return SERVER_INFO;
    }

    public String getInitParameter(String name) {
        return this.initParameters.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return new MockletEnumerationAdapter<String>(this.initParameters.keySet().iterator());
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return new MockletEnumerationAdapter<String>(this.attributes.keySet().iterator());
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    @Override
    public void addMimeType(String file, String type) {
        this.mimeTypes.put(file, type);
    }

    @Override
    public boolean setInitParameter(String name, String value) {
        if (this.initParameters.containsKey(name)) {
            return false;
        }
        this.initParameters.put(name, value);
        return true;
    }

    @Override
    public MockletHttpServletRequest createRequest(String path) {
        String queryString = null;
        int question = path.indexOf(63);
        if (question >= 0) {
            queryString = path.substring(question + 1);
            path = path.substring(0, question);
        }
        MockletHttpServletRequestImpl request = new MockletHttpServletRequestImpl(this, path);
        request.setQueryString(queryString);
        return request;
    }

    @Override
    public void setServletContextName(String servletContextName) {
        this.servletContextName = servletContextName;
    }

    @Override
    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    @Override
    public Map<String, String> getInitParameterMap() {
        return this.initParameters;
    }

    public int getEffectiveMajorVersion() {
        return 0;
    }

    public int getEffectiveMinorVersion() {
        return 0;
    }

    public ServletRegistration.Dynamic addServlet(String servletName, String className) {
        return null;
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Servlet servlet) {
        return null;
    }

    public ServletRegistration.Dynamic addServlet(String servletName, Class<? extends Servlet> servletClass) {
        return null;
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        return null;
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return null;
    }

    public Map<String, ? extends ServletRegistration> getServletRegistrations() {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, String className) {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Filter filter) {
        return null;
    }

    public FilterRegistration.Dynamic addFilter(String filterName, Class<? extends Filter> filterClass) {
        return null;
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        return null;
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return null;
    }

    public Map<String, ? extends FilterRegistration> getFilterRegistrations() {
        return null;
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return null;
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return null;
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        return null;
    }

    public void addListener(String className) {
    }

    public <T extends EventListener> void addListener(T t) {
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        return null;
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        return null;
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public void declareRoles(String ... roleNames) {
    }

    public String getVirtualServerName() {
        return null;
    }
}

