/*
 * Decompiled with CFR 0.152.
 */
package org.decampo.xirr;

import java.util.function.DoubleUnaryOperator;

public class NewtonRaphson {
    public static final double TOLERANCE = 1.0E-7;
    private final DoubleUnaryOperator func;
    private final DoubleUnaryOperator derivative;
    private final double tolerance;
    private final long iterations;

    public static Builder builder() {
        return new Builder();
    }

    public NewtonRaphson(DoubleUnaryOperator func, DoubleUnaryOperator derivative, double tolerance, long iterations) {
        this.func = func;
        this.derivative = derivative;
        this.tolerance = tolerance;
        this.iterations = iterations;
    }

    public double findRoot(double guess) {
        return this.inverse(0.0, guess);
    }

    public double inverse(double target, double guess) {
        double candidate = guess;
        int i = 0;
        while ((long)i < this.iterations) {
            double value = this.func.applyAsDouble(candidate) - target;
            if (Math.abs(value) < this.tolerance) {
                return candidate;
            }
            double slope = this.derivative.applyAsDouble(candidate);
            if (slope == 0.0) {
                throw new ArithmeticException("Newton-Raphson failed due to zero-valued derivative.");
            }
            candidate -= value / slope;
            ++i;
        }
        throw new IllegalArgumentException("Newton-Raphson failed to converge within " + this.iterations + " iterations.");
    }

    public static class Builder {
        private DoubleUnaryOperator func;
        private DoubleUnaryOperator derivative;
        private double tolerance = 1.0E-7;
        private long iterations = 10000L;

        public Builder withFunction(DoubleUnaryOperator func) {
            this.func = func;
            return this;
        }

        public Builder withDerivative(DoubleUnaryOperator derivative) {
            this.derivative = derivative;
            return this;
        }

        public Builder withTolerance(double tolerance) {
            this.tolerance = tolerance;
            return this;
        }

        public Builder withIterations(long iterations) {
            this.iterations = iterations;
            return this;
        }

        public NewtonRaphson build() {
            return new NewtonRaphson(this.func, this.derivative, this.tolerance, this.iterations);
        }

        public double findRoot(double guess) {
            return this.build().findRoot(guess);
        }
    }
}

