/*
 * Decompiled with CFR 0.152.
 */
package org.decampo.xirr;

import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.decampo.xirr.NewtonRaphson;
import org.decampo.xirr.Transaction;
import org.decampo.xirr.XirrDetails;

public class Xirr {
    private static final double DAYS_IN_YEAR = 365.0;
    private final List<Investment> investments;
    private final XirrDetails details;

    public Xirr(Transaction ... tx) {
        this(Arrays.asList(tx));
    }

    public Xirr(Collection<Transaction> txs) {
        if (txs.size() < 2) {
            throw new IllegalArgumentException("Must have at least two transactions");
        }
        this.details = txs.stream().collect(XirrDetails.collector());
        this.details.validate();
        this.investments = txs.stream().map(this::createInvestment).collect(Collectors.toList());
    }

    private Investment createInvestment(Transaction tx) {
        Investment result = new Investment();
        result.amount = tx.amount;
        result.years = (double)ChronoUnit.DAYS.between(tx.when, this.details.end) / 365.0;
        return result;
    }

    public double presentValue(double rate) {
        return this.investments.stream().mapToDouble(inv -> ((Investment)inv).presentValue(rate)).sum();
    }

    public double derivative(double rate) {
        return this.investments.stream().mapToDouble(inv -> ((Investment)inv).derivative(rate)).sum();
    }

    public double xirr() {
        double years = (double)ChronoUnit.DAYS.between(this.details.start, this.details.end) / 365.0;
        double guess = this.details.total / this.details.deposits / years;
        return NewtonRaphson.builder().withFunction(this::presentValue).withDerivative(this::derivative).findRoot(guess);
    }

    private static class Investment {
        double amount;
        double years;

        private Investment() {
        }

        private double presentValue(double rate) {
            return this.amount * Math.pow(1.0 + rate, this.years);
        }

        private double derivative(double rate) {
            if (this.years == 0.0) {
                return 0.0;
            }
            return this.amount * this.years * Math.pow(1.0 + rate, this.years - 1.0);
        }
    }
}

