/*
 * Decompiled with CFR 0.152.
 */
package org.decampo.xirr;

import java.time.LocalDate;
import java.util.stream.Collector;
import org.decampo.xirr.Transaction;

class XirrDetails {
    LocalDate start;
    LocalDate end;
    double minAmount = Double.POSITIVE_INFINITY;
    double maxAmount = Double.NEGATIVE_INFINITY;
    double total;
    double deposits;

    XirrDetails() {
    }

    public static Collector<Transaction, XirrDetails, XirrDetails> collector() {
        return Collector.of(XirrDetails::new, XirrDetails::accumulate, XirrDetails::combine, Collector.Characteristics.IDENTITY_FINISH, Collector.Characteristics.UNORDERED);
    }

    public void accumulate(Transaction tx) {
        this.start = this.start != null && this.start.isBefore(tx.when) ? this.start : tx.when;
        this.end = this.end != null && this.end.isAfter(tx.when) ? this.end : tx.when;
        this.minAmount = Math.min(this.minAmount, tx.amount);
        this.maxAmount = Math.max(this.maxAmount, tx.amount);
        this.total += tx.amount;
        if (tx.amount < 0.0) {
            this.deposits -= tx.amount;
        }
    }

    public XirrDetails combine(XirrDetails other) {
        this.start = this.start.isBefore(other.start) ? this.start : other.start;
        this.end = this.end.isAfter(other.end) ? this.end : other.end;
        this.minAmount = Math.min(this.minAmount, other.minAmount);
        this.maxAmount = Math.max(this.maxAmount, other.maxAmount);
        this.total += other.total;
        return this;
    }

    public void validate() {
        if (this.start == null) {
            throw new IllegalArgumentException("No transactions to anaylze");
        }
        if (this.start.equals(this.end)) {
            throw new IllegalArgumentException("Transactions must not all be on the same day.");
        }
        if (this.minAmount >= 0.0) {
            throw new IllegalArgumentException("Transactions must not all be nonnegative.");
        }
        if (this.maxAmount < 0.0) {
            throw new IllegalArgumentException("Transactions must not be negative.");
        }
    }
}

