(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'phaser'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('phaser'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'phaser3-kotlin-wrapper'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'phaser3-kotlin-wrapper'.");
    }
    if (typeof phaser === 'undefined') {
      throw new Error("Error loading module 'phaser3-kotlin-wrapper'. Its dependency 'phaser' was not found. Please, check whether 'phaser' is loaded prior to 'phaser3-kotlin-wrapper'.");
    }
    root['phaser3-kotlin-wrapper'] = factory(typeof this['phaser3-kotlin-wrapper'] === 'undefined' ? {} : this['phaser3-kotlin-wrapper'], kotlin, phaser);
  }
}(this, function (_, Kotlin, $module$phaser) {
  'use strict';
  var Enum = Kotlin.kotlin.Enum;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var throwISE = Kotlin.throwISE;
  var Unit = Kotlin.kotlin.Unit;
  var contains = Kotlin.kotlin.collections.contains_mjy6jw$;
  var throwCCE = Kotlin.throwCCE;
  PhaserEvent.prototype = Object.create(Enum.prototype);
  PhaserEvent.prototype.constructor = PhaserEvent;
  function PhaserEvent(name, ordinal, eventName) {
    Enum.call(this);
    this.eventName = eventName;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function PhaserEvent_initFields() {
    PhaserEvent_initFields = function () {
    };
    PhaserEvent$POINTER_DOWN_instance = new PhaserEvent('POINTER_DOWN', 0, 'pointerdown');
    PhaserEvent$POINTER_OVER_instance = new PhaserEvent('POINTER_OVER', 1, 'pointerover');
    PhaserEvent$POINTER_OUT_instance = new PhaserEvent('POINTER_OUT', 2, 'pointerout');
  }
  var PhaserEvent$POINTER_DOWN_instance;
  function PhaserEvent$POINTER_DOWN_getInstance() {
    PhaserEvent_initFields();
    return PhaserEvent$POINTER_DOWN_instance;
  }
  var PhaserEvent$POINTER_OVER_instance;
  function PhaserEvent$POINTER_OVER_getInstance() {
    PhaserEvent_initFields();
    return PhaserEvent$POINTER_OVER_instance;
  }
  var PhaserEvent$POINTER_OUT_instance;
  function PhaserEvent$POINTER_OUT_getInstance() {
    PhaserEvent_initFields();
    return PhaserEvent$POINTER_OUT_instance;
  }
  PhaserEvent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'PhaserEvent',
    interfaces: [Enum]
  };
  function PhaserEvent$values() {
    return [PhaserEvent$POINTER_DOWN_getInstance(), PhaserEvent$POINTER_OVER_getInstance(), PhaserEvent$POINTER_OUT_getInstance()];
  }
  PhaserEvent.values = PhaserEvent$values;
  function PhaserEvent$valueOf(name) {
    switch (name) {
      case 'POINTER_DOWN':
        return PhaserEvent$POINTER_DOWN_getInstance();
      case 'POINTER_OVER':
        return PhaserEvent$POINTER_OVER_getInstance();
      case 'POINTER_OUT':
        return PhaserEvent$POINTER_OUT_getInstance();
      default:throwISE('No enum constant org.decembrist.utils.PhaserEvent.' + name);
    }
  }
  PhaserEvent.valueOf_61zpoe$ = PhaserEvent$valueOf;
  function onEvent$lambda(closure$fn, this$onEvent) {
    return function (evt) {
      closure$fn(this$onEvent, evt);
      return Unit;
    };
  }
  function onEvent($receiver, event, fn, context) {
    if (context === void 0)
      context = undefined;
    return $receiver.on(event.eventName, onEvent$lambda(fn, $receiver), context);
  }
  function onEvent_0($receiver, event, fn, context) {
    if (context === void 0)
      context = undefined;
    return $receiver.on(event.eventName, fn, context);
  }
  function toPhaserConfig$lambda(this$toPhaserConfig) {
    return function (property) {
      var tmp$;
      var ownProperties = Object.getOwnPropertyNames(this);
      if (contains(ownProperties, property))
        tmp$ = true;
      else if (this$toPhaserConfig[property] != undefined) {
        this$toPhaserConfig[property] = configSubFields(this$toPhaserConfig, property);
        tmp$ = true;
      }
       else
        tmp$ = false;
      return tmp$;
    };
  }
  function toPhaserConfig($receiver) {
    $receiver.hasOwnProperty = toPhaserConfig$lambda($receiver);
    return $receiver;
  }
  function configSubFields$lambda(closure$value) {
    return function (el, index) {
      return configSubFields(closure$value, index);
    };
  }
  function configSubFields(obj, property) {
    var tmp$, tmp$_0, tmp$_1, tmp$_2, tmp$_3;
    var value = obj[property];
    if (typeof (tmp$ = typeof value === 'object') === 'boolean' ? tmp$ : throwCCE()) {
      if (typeof (tmp$_0 = value instanceof Array) === 'boolean' ? tmp$_0 : throwCCE()) {
        tmp$_3 = obj[property] = value.map(configSubFields$lambda(value));
      }
       else {
        if (!(typeof (tmp$_1 = value instanceof Function) === 'boolean' ? tmp$_1 : throwCCE())) {
          tmp$_2 = toPhaserConfig(value);
        }
         else {
          tmp$_2 = value;
        }
        return tmp$_2;
      }
    }
     else
      tmp$_3 = value;
    return tmp$_3;
  }
  function sprite($receiver, sprite) {
    $receiver.sys.displayList.add(sprite);
    $receiver.sys.updateList.add(sprite);
    $receiver.world.enable(sprite, $module$phaser.Physics.Arcade.DYNAMIC_BODY);
  }
  Object.defineProperty(PhaserEvent, 'POINTER_DOWN', {
    get: PhaserEvent$POINTER_DOWN_getInstance
  });
  Object.defineProperty(PhaserEvent, 'POINTER_OVER', {
    get: PhaserEvent$POINTER_OVER_getInstance
  });
  Object.defineProperty(PhaserEvent, 'POINTER_OUT', {
    get: PhaserEvent$POINTER_OUT_getInstance
  });
  var package$org = _.org || (_.org = {});
  var package$decembrist = package$org.decembrist || (package$org.decembrist = {});
  var package$utils = package$decembrist.utils || (package$decembrist.utils = {});
  package$utils.PhaserEvent = PhaserEvent;
  package$utils.onEvent_1fn989$ = onEvent;
  package$utils.onEvent_9yq3bk$ = onEvent_0;
  package$utils.toPhaserConfig_fr2oqm$ = toPhaserConfig;
  package$utils.sprite_dcdbim$ = sprite;
  Kotlin.defineModule('phaser3-kotlin-wrapper', _);
  return _;
}));

//# sourceMappingURL=phaser3-kotlin-wrapper.js.map
