/*
 * Decompiled with CFR 0.152.
 */
package deepboof.io.torch7;

import deepboof.Tensor;
import deepboof.io.torch7.struct.TorchBoolean;
import deepboof.io.torch7.struct.TorchByteStorage;
import deepboof.io.torch7.struct.TorchDoubleStorage;
import deepboof.io.torch7.struct.TorchFloatStorage;
import deepboof.io.torch7.struct.TorchNumber;
import deepboof.io.torch7.struct.TorchString;
import deepboof.io.torch7.struct.TorchTensor;
import deepboof.tensors.Tensor_F32;
import deepboof.tensors.Tensor_F64;
import deepboof.tensors.Tensor_U8;

public class ConvertBoofToTorch {
    public static TorchTensor convert(Tensor input) {
        TorchTensor torch = new TorchTensor();
        torch.version = 1;
        torch.shape = input.shape;
        if (input.isSub()) {
            throw new IllegalArgumentException("Subtensors not yet supported");
        }
        if (input instanceof Tensor_F64) {
            Tensor_F64 t = (Tensor_F64)input;
            TorchDoubleStorage storage = new TorchDoubleStorage(0);
            storage.data = t.d;
            storage.version = 1;
            torch.storage = storage;
            torch.torchName = "torch.DoubleTensor";
        } else if (input instanceof Tensor_F32) {
            Tensor_F32 t = (Tensor_F32)input;
            TorchFloatStorage storage = new TorchFloatStorage(0);
            storage.data = t.d;
            storage.version = 1;
            torch.storage = storage;
            torch.torchName = "torch.FloatTensor";
        } else if (input instanceof Tensor_U8) {
            Tensor_U8 t = (Tensor_U8)input;
            TorchByteStorage storage = new TorchByteStorage(0);
            storage.data = t.d;
            storage.version = 1;
            torch.storage = storage;
            torch.torchName = "torch.ByteTensor";
        } else {
            throw new RuntimeException("Add support for " + input.getClass().getSimpleName());
        }
        return torch;
    }

    public static TorchBoolean convert(boolean value) {
        TorchBoolean output = new TorchBoolean();
        output.value = value;
        return output;
    }

    public static TorchNumber convert(double number) {
        TorchNumber output = new TorchNumber();
        output.value = number;
        return output;
    }

    public static TorchString convert(String message) {
        TorchString output = new TorchString();
        output.message = message;
        return output;
    }
}

