/*
 * Decompiled with CFR 0.152.
 */
package deepboof.impl.backward.standard;

import deepboof.backward.DActivationSigmoid;
import deepboof.impl.backward.standard.ElementWiseDFunction;
import deepboof.tensors.Tensor_F64;
import java.util.List;

public class DActivationSigmoid_F64
extends ElementWiseDFunction<Tensor_F64>
implements DActivationSigmoid<Tensor_F64> {
    Tensor_F64 memorySigmoid = new Tensor_F64();

    public void _forward(Tensor_F64 input, Tensor_F64 output) {
        this.memorySigmoid.reshape(input.shape);
        int length = input.length();
        int indexIn = input.startIndex;
        int indexOut = output.startIndex;
        int indexMem = this.memorySigmoid.startIndex;
        for (int i = 0; i < length; ++i) {
            double value = input.d[indexIn + i];
            double d = 1.0 / (1.0 + Math.exp(-value));
            output.d[indexOut + i] = d;
            this.memorySigmoid.d[indexMem + i] = d;
        }
    }

    @Override
    protected void _backwards(Tensor_F64 input, Tensor_F64 dout, Tensor_F64 gradientInput, List<Tensor_F64> gradientParameters) {
        int length = gradientInput.length();
        int indexDIn = gradientInput.startIndex;
        int indexDOut = dout.startIndex;
        for (int i = 0; i < length; ++i) {
            double sigmoid = this.memorySigmoid.d[i];
            gradientInput.d[indexDIn++] = sigmoid * (1.0 - sigmoid) * dout.d[indexDOut++];
        }
    }

    public Class<Tensor_F64> getTensorType() {
        return Tensor_F64.class;
    }
}

