/*
 * Decompiled with CFR 0.152.
 */
package deepboof.impl.forward.standard;

import deepboof.Tensor;
import deepboof.forward.ConfigSpatial;
import deepboof.forward.SpatialPadding2D;
import deepboof.impl.forward.standard.BaseSpatialWindow;

public abstract class SpatialWindowImage<T extends Tensor<T>, P extends SpatialPadding2D<T>>
extends BaseSpatialWindow<T, P> {
    protected T output;

    public SpatialWindowImage(ConfigSpatial config, P padding) {
        super(config, padding);
    }

    protected void forwardImage(T input, T output) {
        this.output = output;
        this.padding.setInput(input);
        this.N = ((Tensor)input).length(0);
        int paddingX0 = this.padding.getPaddingCol0();
        int paddingY0 = this.padding.getPaddingRow0();
        int outC0 = SpatialWindowImage.innerLowerExtent(this.config.periodX, paddingX0);
        int outC1 = SpatialWindowImage.innerUpperExtent(this.config.WW, this.config.periodX, paddingX0, this.W);
        int outR0 = SpatialWindowImage.innerLowerExtent(this.config.periodY, paddingY0);
        int outR1 = SpatialWindowImage.innerUpperExtent(this.config.HH, this.config.periodY, paddingY0, this.H);
        if (this.isEntirelyBorder(outR0, outC0)) {
            for (int batchIndex = 0; batchIndex < this.N; ++batchIndex) {
                this.forwardBorder(batchIndex, 0, 0, this.Ho, this.Wo);
            }
        } else {
            for (int batchIndex = 0; batchIndex < this.N; ++batchIndex) {
                for (int outRow = outR0; outRow < outR1; ++outRow) {
                    int inputRow = outRow * this.config.periodY - paddingY0;
                    for (int outCol = outC0; outCol < outC1; ++outCol) {
                        int inputCol = outCol * this.config.periodX - paddingX0;
                        this.forwardAt_inner(input, batchIndex, inputRow, inputCol, outRow, outCol);
                    }
                }
                this.forwardBorder(batchIndex, 0, 0, outR0, this.Wo);
                this.forwardBorder(batchIndex, outR1, 0, this.Ho, this.Wo);
                this.forwardBorder(batchIndex, outR0, 0, outR1, outC0);
                this.forwardBorder(batchIndex, outR0, outC1, outR1, this.Wo);
            }
        }
    }

    private void forwardBorder(int batchIndex, int row0, int col0, int row1, int col1) {
        for (int outRow = row0; outRow < row1; ++outRow) {
            int paddedRow = outRow * this.config.periodY;
            for (int outCol = col0; outCol < col1; ++outCol) {
                int paddedCol = outCol * this.config.periodX;
                this.forwardAt_border(this.padding, batchIndex, paddedRow, paddedCol, outRow, outCol);
            }
        }
    }

    protected abstract void forwardAt_inner(T var1, int var2, int var3, int var4, int var5, int var6);

    protected abstract void forwardAt_border(P var1, int var2, int var3, int var4, int var5, int var6);
}

