/*
 * Decompiled with CFR 0.152.
 */
package deepboof.misc;

import deepboof.misc.TensorOps;
import deepboof.tensors.Tensor_F32;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class TensorFactory_F32 {
    public static Tensor_F32 zeros(Random rand, int ... shape) {
        Tensor_F32 out = new Tensor_F32();
        if (rand != null) {
            out.subtensor = true;
            out.startIndex = rand.nextInt(20) + 1;
        }
        out.d = new float[out.startIndex + TensorOps.tensorLength(shape)];
        out.reshape(shape);
        return out;
    }

    public static Tensor_F32 random(Random rand, boolean subTensor, int ... shape) {
        return TensorFactory_F32.randomMM(rand, subTensor, -1.0f, 1.0f, shape);
    }

    public static Tensor_F32 randomMM(Random rand, boolean subTensor, float min, float max, int ... shape) {
        Tensor_F32 out = TensorFactory_F32.zeros(subTensor ? rand : null, shape);
        TensorFactory_F32.randomMM(rand, min, max, out);
        return out;
    }

    public static List<Tensor_F32> randomMM(Random rand, boolean subTensor, float min, float max, List<int[]> shapes) {
        ArrayList<Tensor_F32> out = new ArrayList<Tensor_F32>();
        for (int[] shape : shapes) {
            out.add(TensorFactory_F32.randomMM(rand, subTensor, min, max, shape));
        }
        return out;
    }

    public static void randomMM(Random rand, float min, float max, Tensor_F32 tensor) {
        int N = tensor.length();
        for (int i = 0; i < N; ++i) {
            tensor.d[tensor.startIndex + i] = rand.nextFloat() * (max - min) + min;
        }
    }
}

