/*
 * Decompiled with CFR 0.152.
 */
package deepboof.graph;

import deepboof.graph.Node;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class SequenceForwardOrder {
    List<NodeData> sequence = new ArrayList<NodeData>();

    public SequenceForwardOrder(List<Node<?, ?>> list) {
        HashMap<String, NodeData> lookup = new HashMap<String, NodeData>();
        for (Node<?, ?> node : list) {
            NodeData d = new NodeData(node);
            this.sequence.add(d);
            lookup.put(node.name, d);
        }
        for (int i = 0; i < this.sequence.size(); ++i) {
            NodeData nodeData = this.sequence.get(i);
            for (int j = 0; j < nodeData.node.sources.size(); ++j) {
                NodeData c = (NodeData)lookup.get(nodeData.node.sources.get((int)j).nodeName);
                nodeData.previous.add(c);
                c.next.add(nodeData);
            }
        }
    }

    public List<Node<?, ?>> putIntoForwardOrder() {
        this.assignDepth();
        for (int i = 0; i < this.sequence.size(); ++i) {
            NodeData n = this.sequence.get(i);
            if (n.depth != Integer.MAX_VALUE) continue;
            throw new RuntimeException("Disconnected node from graph " + n.node.name);
        }
        ArrayList<NodeData> copy = new ArrayList<NodeData>(this.sequence);
        Collections.sort(copy, new CompareWithDepth());
        ArrayList ordered = new ArrayList();
        for (int i = 0; i < copy.size(); ++i) {
            ordered.add(((NodeData)copy.get((int)i)).node);
        }
        return ordered;
    }

    protected void assignDepth() {
        this.resetNodeInfo();
        NodeData input = this.findInput();
        input.depth = 0;
        ArrayList<NodeData> layer = new ArrayList<NodeData>();
        ArrayList<NodeData> nextLayer = new ArrayList<NodeData>();
        layer.addAll(input.next);
        for (int i = 0; i < input.next.size(); ++i) {
            NodeData c = input.next.get(i);
            if (c.depth != Integer.MAX_VALUE) {
                throw new RuntimeException("Input node connects to a child node more than once! " + c.node.name);
            }
            c.depth = 1;
        }
        int depth = 1;
        while (!layer.isEmpty()) {
            nextLayer.clear();
            for (int i = 0; i < layer.size(); ++i) {
                NodeData c;
                int j;
                NodeData n = (NodeData)layer.get(i);
                for (j = 0; j < n.next.size(); ++j) {
                    c = n.next.get(j);
                    if (c.depth != Integer.MAX_VALUE) continue;
                    boolean allAssigned = true;
                    for (int k = 0; k < c.previous.size(); ++k) {
                        if (c.previous.get((int)k).depth != Integer.MAX_VALUE) continue;
                        allAssigned = false;
                        break;
                    }
                    if (!allAssigned) continue;
                    c.depth = depth + 1;
                    nextLayer.add(c);
                }
                for (j = 0; j < n.previous.size(); ++j) {
                    c = n.previous.get(j);
                    if (c.depth != Integer.MAX_VALUE) continue;
                    throw new RuntimeException("An input to this node has not been traversed. Cycle or other graph error. " + c.node.name);
                }
            }
            ArrayList<NodeData> tmp = layer;
            layer = nextLayer;
            nextLayer = tmp;
            ++depth;
        }
    }

    protected NodeData findInput() {
        NodeData found = null;
        for (int i = 0; i < this.sequence.size(); ++i) {
            NodeData n = this.sequence.get(i);
            if (!n.node.sources.isEmpty()) continue;
            if (found != null) {
                throw new RuntimeException("Found multiple input nodes");
            }
            found = n;
        }
        if (found == null) {
            throw new RuntimeException("No input node found");
        }
        return found;
    }

    private void resetNodeInfo() {
        for (int i = 0; i < this.sequence.size(); ++i) {
            this.sequence.get(i).reset();
        }
    }

    public static class NodeData {
        Node<?, ?> node;
        List<NodeData> next = new ArrayList<NodeData>();
        List<NodeData> previous = new ArrayList<NodeData>();
        int depth;

        public NodeData(Node<?, ?> node) {
            this.node = node;
            this.reset();
        }

        public void reset() {
            this.depth = Integer.MAX_VALUE;
        }
    }

    private static class CompareWithDepth
    implements Comparator<NodeData> {
        private CompareWithDepth() {
        }

        @Override
        public int compare(NodeData a, NodeData b) {
            if (a.depth < b.depth) {
                return -1;
            }
            if (a.depth > b.depth) {
                return 1;
            }
            return a.node.name.compareTo(b.node.name);
        }
    }
}

