/*
 * Decompiled with CFR 0.152.
 */
package deepboof.impl.forward.standard;

import deepboof.forward.ConfigSpatial;
import deepboof.forward.SpatialMaxPooling;
import deepboof.forward.SpatialPadding2D_F64;
import deepboof.impl.forward.standard.SpatialWindowChannel;
import deepboof.tensors.Tensor_F64;
import java.util.List;

public class SpatialMaxPooling_F64
extends SpatialWindowChannel<Tensor_F64, SpatialPadding2D_F64>
implements SpatialMaxPooling<Tensor_F64> {
    public SpatialMaxPooling_F64(ConfigSpatial config, SpatialPadding2D_F64 padding) {
        super(config, padding);
    }

    @Override
    public void _initialize() {
        super._initialize();
        if (this.shapeInput.length != 3) {
            throw new IllegalArgumentException("Expected 3D spatial tensor");
        }
        this.shapeOutput = (int[])this.shapeInput.clone();
        this.shapeOutput[1] = this.Ho;
        this.shapeOutput[2] = this.Wo;
    }

    @Override
    public void _setParameters(List<Tensor_F64> parameters) {
    }

    @Override
    public void _forward(Tensor_F64 input, Tensor_F64 output) {
        this.forwardChannel(input, output);
    }

    @Override
    protected void forwardAt_inner(Tensor_F64 input, int batch, int channel, int inY, int inX, int outY, int outX) {
        int inputIndexRow = input.idx(batch, channel, inY, inX);
        double max = -1.7976931348623157E308;
        for (int j = 0; j < this.HH; ++j) {
            int inputIndex = inputIndexRow;
            for (int i = 0; i < this.WW; ++i) {
                int n = inputIndex++;
                double value = input.d[n];
                if (!(value > max)) continue;
                max = value;
            }
            inputIndexRow += this.W;
        }
        ((Tensor_F64)this.output).d[((Tensor_F64)this.output).idx((int)batch, (int)channel, (int)outY, (int)outX)] = max;
    }

    @Override
    protected void forwardAt_border(SpatialPadding2D_F64 padded, int batch, int channel, int padY, int padX, int outY, int outX) {
        int row0 = padY;
        int row1 = padY + this.HH;
        row0 += padded.getClippingOffsetRow(row0);
        row1 += padded.getClippingOffsetRow(row1);
        int col0 = padX;
        int col1 = padX + this.WW;
        col0 += padded.getClippingOffsetCol(col0);
        col1 += padded.getClippingOffsetCol(col1);
        double max = -1.7976931348623157E308;
        for (int j = row0; j < row1; ++j) {
            for (int i = col0; i < col1; ++i) {
                double value = padded.get(batch, channel, j, i);
                if (!(value > max)) continue;
                max = value;
            }
        }
        ((Tensor_F64)this.output).d[((Tensor_F64)this.output).idx((int)batch, (int)channel, (int)outY, (int)outX)] = max;
    }

    @Override
    public Class<Tensor_F64> getTensorType() {
        return Tensor_F64.class;
    }

    @Override
    public ConfigSpatial getConfiguration() {
        return this.config;
    }
}

