/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.arbiter.ComputationGraphSpace;
import org.deeplearning4j.arbiter.MultiLayerSpace;
import org.deeplearning4j.arbiter.adapter.ActivationParameterSpaceAdapter;
import org.deeplearning4j.arbiter.conf.dropout.DropoutSpace;
import org.deeplearning4j.arbiter.layers.LayerSpace;
import org.deeplearning4j.arbiter.optimize.api.AbstractParameterSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.arbiter.optimize.serde.jackson.JsonMapper;
import org.deeplearning4j.arbiter.optimize.serde.jackson.YamlMapper;
import org.deeplearning4j.earlystopping.EarlyStoppingConfiguration;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.api.layers.LayerConstraint;
import org.deeplearning4j.nn.conf.BackpropType;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.InputPreProcessor;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.dropout.Dropout;
import org.deeplearning4j.nn.conf.dropout.IDropout;
import org.deeplearning4j.nn.conf.stepfunctions.StepFunction;
import org.deeplearning4j.nn.conf.weightnoise.IWeightNoise;
import org.deeplearning4j.nn.weights.WeightInit;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.activations.IActivation;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.shade.jackson.annotation.JsonTypeInfo;
import org.nd4j.shade.jackson.core.JsonProcessingException;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="@class")
public abstract class BaseNetworkSpace<T>
extends AbstractParameterSpace<T> {
    protected Long seed;
    protected ParameterSpace<OptimizationAlgorithm> optimizationAlgo;
    protected ParameterSpace<IActivation> activationFunction;
    protected ParameterSpace<Double> biasInit;
    protected ParameterSpace<WeightInit> weightInit;
    protected ParameterSpace<Distribution> dist;
    protected ParameterSpace<Integer> maxNumLineSearchIterations;
    protected ParameterSpace<Boolean> miniBatch;
    protected ParameterSpace<Boolean> minimize;
    protected ParameterSpace<StepFunction> stepFunction;
    protected ParameterSpace<Double> l1;
    protected ParameterSpace<Double> l2;
    protected ParameterSpace<Double> l1Bias;
    protected ParameterSpace<Double> l2Bias;
    protected ParameterSpace<IUpdater> updater;
    protected ParameterSpace<IUpdater> biasUpdater;
    protected ParameterSpace<IWeightNoise> weightNoise;
    private ParameterSpace<IDropout> dropout;
    protected ParameterSpace<GradientNormalization> gradientNormalization;
    protected ParameterSpace<Double> gradientNormalizationThreshold;
    protected ParameterSpace<ConvolutionMode> convolutionMode;
    protected List<LayerConf> layerSpaces = new ArrayList<LayerConf>();
    protected ParameterSpace<BackpropType> backpropType;
    protected ParameterSpace<Integer> tbpttFwdLength;
    protected ParameterSpace<Integer> tbpttBwdLength;
    protected ParameterSpace<List<LayerConstraint>> allParamConstraints;
    protected ParameterSpace<List<LayerConstraint>> weightConstraints;
    protected ParameterSpace<List<LayerConstraint>> biasConstraints;
    protected int numEpochs = 1;

    protected BaseNetworkSpace(Builder builder) {
        this.seed = builder.seed;
        this.optimizationAlgo = builder.optimizationAlgo;
        this.activationFunction = builder.activationFunction;
        this.biasInit = builder.biasInit;
        this.weightInit = builder.weightInit;
        this.dist = builder.dist;
        this.maxNumLineSearchIterations = builder.maxNumLineSearchIterations;
        this.miniBatch = builder.miniBatch;
        this.minimize = builder.minimize;
        this.stepFunction = builder.stepFunction;
        this.l1 = builder.l1;
        this.l2 = builder.l2;
        this.l1Bias = builder.l1Bias;
        this.l2Bias = builder.l2Bias;
        this.updater = builder.updater;
        this.biasUpdater = builder.biasUpdater;
        this.weightNoise = builder.weightNoise;
        this.dropout = builder.dropout;
        this.gradientNormalization = builder.gradientNormalization;
        this.gradientNormalizationThreshold = builder.gradientNormalizationThreshold;
        this.convolutionMode = builder.convolutionMode;
        this.allParamConstraints = builder.allParamConstraints;
        this.weightConstraints = builder.weightConstraints;
        this.biasConstraints = builder.biasConstraints;
        this.backpropType = builder.backpropType;
        this.tbpttFwdLength = builder.tbpttFwdLength;
        this.tbpttBwdLength = builder.tbpttBwdLength;
        this.numEpochs = builder.numEpochs;
    }

    protected BaseNetworkSpace() {
    }

    protected NeuralNetConfiguration.Builder randomGlobalConf(double[] values) {
        List c;
        NeuralNetConfiguration.Builder builder = new NeuralNetConfiguration.Builder();
        if (this.seed != null) {
            builder.seed(this.seed.longValue());
        }
        if (this.optimizationAlgo != null) {
            builder.optimizationAlgo((OptimizationAlgorithm)this.optimizationAlgo.getValue(values));
        }
        if (this.activationFunction != null) {
            builder.activation((IActivation)this.activationFunction.getValue(values));
        }
        if (this.biasInit != null) {
            builder.biasInit(((Double)this.biasInit.getValue(values)).doubleValue());
        }
        if (this.weightInit != null) {
            builder.weightInit((WeightInit)this.weightInit.getValue(values));
        }
        if (this.dist != null) {
            builder.dist((Distribution)this.dist.getValue(values));
        }
        if (this.maxNumLineSearchIterations != null) {
            builder.maxNumLineSearchIterations(((Integer)this.maxNumLineSearchIterations.getValue(values)).intValue());
        }
        if (this.miniBatch != null) {
            builder.miniBatch(((Boolean)this.miniBatch.getValue(values)).booleanValue());
        }
        if (this.minimize != null) {
            builder.minimize(((Boolean)this.minimize.getValue(values)).booleanValue());
        }
        if (this.stepFunction != null) {
            builder.stepFunction((StepFunction)this.stepFunction.getValue(values));
        }
        if (this.l1 != null) {
            builder.l1(((Double)this.l1.getValue(values)).doubleValue());
        }
        if (this.l2 != null) {
            builder.l2(((Double)this.l2.getValue(values)).doubleValue());
        }
        if (this.l1Bias != null) {
            builder.l1Bias(((Double)this.l1Bias.getValue(values)).doubleValue());
        }
        if (this.l2Bias != null) {
            builder.l2Bias(((Double)this.l2Bias.getValue(values)).doubleValue());
        }
        if (this.updater != null) {
            builder.updater((IUpdater)this.updater.getValue(values));
        }
        if (this.biasUpdater != null) {
            builder.biasUpdater((IUpdater)this.biasUpdater.getValue(values));
        }
        if (this.weightNoise != null) {
            builder.weightNoise((IWeightNoise)this.weightNoise.getValue(values));
        }
        if (this.dropout != null) {
            builder.dropOut((IDropout)this.dropout.getValue(values));
        }
        if (this.gradientNormalization != null) {
            builder.gradientNormalization((GradientNormalization)this.gradientNormalization.getValue(values));
        }
        if (this.gradientNormalizationThreshold != null) {
            builder.gradientNormalizationThreshold(((Double)this.gradientNormalizationThreshold.getValue(values)).doubleValue());
        }
        if (this.convolutionMode != null) {
            builder.convolutionMode((ConvolutionMode)this.convolutionMode.getValue(values));
        }
        if (this.allParamConstraints != null && (c = (List)this.allParamConstraints.getValue(values)) != null) {
            builder.constrainAllParameters(c.toArray(new LayerConstraint[c.size()]));
        }
        if (this.weightConstraints != null && (c = (List)this.weightConstraints.getValue(values)) != null) {
            builder.constrainWeights(c.toArray(new LayerConstraint[c.size()]));
        }
        if (this.biasConstraints != null && (c = (List)this.biasConstraints.getValue(values)) != null) {
            builder.constrainBias(c.toArray(new LayerConstraint[c.size()]));
        }
        return builder;
    }

    public List<ParameterSpace> collectLeaves() {
        Map global = this.getNestedSpaces();
        LinkedList<BaseNetworkSpace<T>> stack = new LinkedList<BaseNetworkSpace<T>>();
        stack.add(this);
        for (LayerConf layerConf : this.layerSpaces) {
            LayerSpace<?> ls = layerConf.getLayerSpace();
            stack.addAll(ls.collectLeaves());
        }
        ArrayList<ParameterSpace> out = new ArrayList<ParameterSpace>();
        while (!stack.isEmpty()) {
            ParameterSpace next = (ParameterSpace)stack.removeLast();
            if (next.isLeaf()) {
                out.add(next);
                continue;
            }
            Map m = next.getNestedSpaces();
            ParameterSpace[] arr = m.values().toArray(new ParameterSpace[m.size()]);
            for (int i = arr.length - 1; i >= 0; --i) {
                stack.add((BaseNetworkSpace<T>)arr[i]);
            }
        }
        return out;
    }

    public boolean isLeaf() {
        return false;
    }

    public void setIndices(int ... indices) {
        throw new UnsupportedOperationException("Cannot set indices for non leaf");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry e : this.getNestedSpaces().entrySet()) {
            sb.append((String)e.getKey()).append(": ").append(e.getValue()).append("\n");
        }
        int i = 0;
        for (LayerConf conf : this.layerSpaces) {
            sb.append("Layer config ").append(i++).append(": (Number layers:").append(conf.numLayers).append(", duplicate: ").append(conf.duplicateConfig).append("), ").append(conf.layerSpace.toString()).append("\n");
        }
        return sb.toString();
    }

    public String toJson() {
        try {
            return JsonMapper.getMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toYaml() {
        try {
            return YamlMapper.getMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseNetworkSpace)) {
            return false;
        }
        BaseNetworkSpace other = (BaseNetworkSpace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$seed = this.getSeed();
        Long other$seed = other.getSeed();
        if (this$seed == null ? other$seed != null : !((Object)this$seed).equals(other$seed)) {
            return false;
        }
        ParameterSpace<OptimizationAlgorithm> this$optimizationAlgo = this.getOptimizationAlgo();
        ParameterSpace<OptimizationAlgorithm> other$optimizationAlgo = other.getOptimizationAlgo();
        if (this$optimizationAlgo == null ? other$optimizationAlgo != null : !this$optimizationAlgo.equals(other$optimizationAlgo)) {
            return false;
        }
        ParameterSpace<IActivation> this$activationFunction = this.getActivationFunction();
        ParameterSpace<IActivation> other$activationFunction = other.getActivationFunction();
        if (this$activationFunction == null ? other$activationFunction != null : !this$activationFunction.equals(other$activationFunction)) {
            return false;
        }
        ParameterSpace<Double> this$biasInit = this.getBiasInit();
        ParameterSpace<Double> other$biasInit = other.getBiasInit();
        if (this$biasInit == null ? other$biasInit != null : !this$biasInit.equals(other$biasInit)) {
            return false;
        }
        ParameterSpace<WeightInit> this$weightInit = this.getWeightInit();
        ParameterSpace<WeightInit> other$weightInit = other.getWeightInit();
        if (this$weightInit == null ? other$weightInit != null : !this$weightInit.equals(other$weightInit)) {
            return false;
        }
        ParameterSpace<Distribution> this$dist = this.getDist();
        ParameterSpace<Distribution> other$dist = other.getDist();
        if (this$dist == null ? other$dist != null : !this$dist.equals(other$dist)) {
            return false;
        }
        ParameterSpace<Integer> this$maxNumLineSearchIterations = this.getMaxNumLineSearchIterations();
        ParameterSpace<Integer> other$maxNumLineSearchIterations = other.getMaxNumLineSearchIterations();
        if (this$maxNumLineSearchIterations == null ? other$maxNumLineSearchIterations != null : !this$maxNumLineSearchIterations.equals(other$maxNumLineSearchIterations)) {
            return false;
        }
        ParameterSpace<Boolean> this$miniBatch = this.getMiniBatch();
        ParameterSpace<Boolean> other$miniBatch = other.getMiniBatch();
        if (this$miniBatch == null ? other$miniBatch != null : !this$miniBatch.equals(other$miniBatch)) {
            return false;
        }
        ParameterSpace<Boolean> this$minimize = this.getMinimize();
        ParameterSpace<Boolean> other$minimize = other.getMinimize();
        if (this$minimize == null ? other$minimize != null : !this$minimize.equals(other$minimize)) {
            return false;
        }
        ParameterSpace<StepFunction> this$stepFunction = this.getStepFunction();
        ParameterSpace<StepFunction> other$stepFunction = other.getStepFunction();
        if (this$stepFunction == null ? other$stepFunction != null : !this$stepFunction.equals(other$stepFunction)) {
            return false;
        }
        ParameterSpace<Double> this$l1 = this.getL1();
        ParameterSpace<Double> other$l1 = other.getL1();
        if (this$l1 == null ? other$l1 != null : !this$l1.equals(other$l1)) {
            return false;
        }
        ParameterSpace<Double> this$l2 = this.getL2();
        ParameterSpace<Double> other$l2 = other.getL2();
        if (this$l2 == null ? other$l2 != null : !this$l2.equals(other$l2)) {
            return false;
        }
        ParameterSpace<Double> this$l1Bias = this.getL1Bias();
        ParameterSpace<Double> other$l1Bias = other.getL1Bias();
        if (this$l1Bias == null ? other$l1Bias != null : !this$l1Bias.equals(other$l1Bias)) {
            return false;
        }
        ParameterSpace<Double> this$l2Bias = this.getL2Bias();
        ParameterSpace<Double> other$l2Bias = other.getL2Bias();
        if (this$l2Bias == null ? other$l2Bias != null : !this$l2Bias.equals(other$l2Bias)) {
            return false;
        }
        ParameterSpace<IUpdater> this$updater = this.getUpdater();
        ParameterSpace<IUpdater> other$updater = other.getUpdater();
        if (this$updater == null ? other$updater != null : !this$updater.equals(other$updater)) {
            return false;
        }
        ParameterSpace<IUpdater> this$biasUpdater = this.getBiasUpdater();
        ParameterSpace<IUpdater> other$biasUpdater = other.getBiasUpdater();
        if (this$biasUpdater == null ? other$biasUpdater != null : !this$biasUpdater.equals(other$biasUpdater)) {
            return false;
        }
        ParameterSpace<IWeightNoise> this$weightNoise = this.getWeightNoise();
        ParameterSpace<IWeightNoise> other$weightNoise = other.getWeightNoise();
        if (this$weightNoise == null ? other$weightNoise != null : !this$weightNoise.equals(other$weightNoise)) {
            return false;
        }
        ParameterSpace<IDropout> this$dropout = this.getDropout();
        ParameterSpace<IDropout> other$dropout = other.getDropout();
        if (this$dropout == null ? other$dropout != null : !this$dropout.equals(other$dropout)) {
            return false;
        }
        ParameterSpace<GradientNormalization> this$gradientNormalization = this.getGradientNormalization();
        ParameterSpace<GradientNormalization> other$gradientNormalization = other.getGradientNormalization();
        if (this$gradientNormalization == null ? other$gradientNormalization != null : !this$gradientNormalization.equals(other$gradientNormalization)) {
            return false;
        }
        ParameterSpace<Double> this$gradientNormalizationThreshold = this.getGradientNormalizationThreshold();
        ParameterSpace<Double> other$gradientNormalizationThreshold = other.getGradientNormalizationThreshold();
        if (this$gradientNormalizationThreshold == null ? other$gradientNormalizationThreshold != null : !this$gradientNormalizationThreshold.equals(other$gradientNormalizationThreshold)) {
            return false;
        }
        ParameterSpace<ConvolutionMode> this$convolutionMode = this.getConvolutionMode();
        ParameterSpace<ConvolutionMode> other$convolutionMode = other.getConvolutionMode();
        if (this$convolutionMode == null ? other$convolutionMode != null : !this$convolutionMode.equals(other$convolutionMode)) {
            return false;
        }
        List<LayerConf> this$layerSpaces = this.getLayerSpaces();
        List<LayerConf> other$layerSpaces = other.getLayerSpaces();
        if (this$layerSpaces == null ? other$layerSpaces != null : !((Object)this$layerSpaces).equals(other$layerSpaces)) {
            return false;
        }
        ParameterSpace<BackpropType> this$backpropType = this.getBackpropType();
        ParameterSpace<BackpropType> other$backpropType = other.getBackpropType();
        if (this$backpropType == null ? other$backpropType != null : !this$backpropType.equals(other$backpropType)) {
            return false;
        }
        ParameterSpace<Integer> this$tbpttFwdLength = this.getTbpttFwdLength();
        ParameterSpace<Integer> other$tbpttFwdLength = other.getTbpttFwdLength();
        if (this$tbpttFwdLength == null ? other$tbpttFwdLength != null : !this$tbpttFwdLength.equals(other$tbpttFwdLength)) {
            return false;
        }
        ParameterSpace<Integer> this$tbpttBwdLength = this.getTbpttBwdLength();
        ParameterSpace<Integer> other$tbpttBwdLength = other.getTbpttBwdLength();
        if (this$tbpttBwdLength == null ? other$tbpttBwdLength != null : !this$tbpttBwdLength.equals(other$tbpttBwdLength)) {
            return false;
        }
        ParameterSpace<List<LayerConstraint>> this$allParamConstraints = this.getAllParamConstraints();
        ParameterSpace<List<LayerConstraint>> other$allParamConstraints = other.getAllParamConstraints();
        if (this$allParamConstraints == null ? other$allParamConstraints != null : !this$allParamConstraints.equals(other$allParamConstraints)) {
            return false;
        }
        ParameterSpace<List<LayerConstraint>> this$weightConstraints = this.getWeightConstraints();
        ParameterSpace<List<LayerConstraint>> other$weightConstraints = other.getWeightConstraints();
        if (this$weightConstraints == null ? other$weightConstraints != null : !this$weightConstraints.equals(other$weightConstraints)) {
            return false;
        }
        ParameterSpace<List<LayerConstraint>> this$biasConstraints = this.getBiasConstraints();
        ParameterSpace<List<LayerConstraint>> other$biasConstraints = other.getBiasConstraints();
        if (this$biasConstraints == null ? other$biasConstraints != null : !this$biasConstraints.equals(other$biasConstraints)) {
            return false;
        }
        return this.getNumEpochs() == other.getNumEpochs();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseNetworkSpace;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $seed = this.getSeed();
        result = result * 59 + ($seed == null ? 43 : ((Object)$seed).hashCode());
        ParameterSpace<OptimizationAlgorithm> $optimizationAlgo = this.getOptimizationAlgo();
        result = result * 59 + ($optimizationAlgo == null ? 43 : $optimizationAlgo.hashCode());
        ParameterSpace<IActivation> $activationFunction = this.getActivationFunction();
        result = result * 59 + ($activationFunction == null ? 43 : $activationFunction.hashCode());
        ParameterSpace<Double> $biasInit = this.getBiasInit();
        result = result * 59 + ($biasInit == null ? 43 : $biasInit.hashCode());
        ParameterSpace<WeightInit> $weightInit = this.getWeightInit();
        result = result * 59 + ($weightInit == null ? 43 : $weightInit.hashCode());
        ParameterSpace<Distribution> $dist = this.getDist();
        result = result * 59 + ($dist == null ? 43 : $dist.hashCode());
        ParameterSpace<Integer> $maxNumLineSearchIterations = this.getMaxNumLineSearchIterations();
        result = result * 59 + ($maxNumLineSearchIterations == null ? 43 : $maxNumLineSearchIterations.hashCode());
        ParameterSpace<Boolean> $miniBatch = this.getMiniBatch();
        result = result * 59 + ($miniBatch == null ? 43 : $miniBatch.hashCode());
        ParameterSpace<Boolean> $minimize = this.getMinimize();
        result = result * 59 + ($minimize == null ? 43 : $minimize.hashCode());
        ParameterSpace<StepFunction> $stepFunction = this.getStepFunction();
        result = result * 59 + ($stepFunction == null ? 43 : $stepFunction.hashCode());
        ParameterSpace<Double> $l1 = this.getL1();
        result = result * 59 + ($l1 == null ? 43 : $l1.hashCode());
        ParameterSpace<Double> $l2 = this.getL2();
        result = result * 59 + ($l2 == null ? 43 : $l2.hashCode());
        ParameterSpace<Double> $l1Bias = this.getL1Bias();
        result = result * 59 + ($l1Bias == null ? 43 : $l1Bias.hashCode());
        ParameterSpace<Double> $l2Bias = this.getL2Bias();
        result = result * 59 + ($l2Bias == null ? 43 : $l2Bias.hashCode());
        ParameterSpace<IUpdater> $updater = this.getUpdater();
        result = result * 59 + ($updater == null ? 43 : $updater.hashCode());
        ParameterSpace<IUpdater> $biasUpdater = this.getBiasUpdater();
        result = result * 59 + ($biasUpdater == null ? 43 : $biasUpdater.hashCode());
        ParameterSpace<IWeightNoise> $weightNoise = this.getWeightNoise();
        result = result * 59 + ($weightNoise == null ? 43 : $weightNoise.hashCode());
        ParameterSpace<IDropout> $dropout = this.getDropout();
        result = result * 59 + ($dropout == null ? 43 : $dropout.hashCode());
        ParameterSpace<GradientNormalization> $gradientNormalization = this.getGradientNormalization();
        result = result * 59 + ($gradientNormalization == null ? 43 : $gradientNormalization.hashCode());
        ParameterSpace<Double> $gradientNormalizationThreshold = this.getGradientNormalizationThreshold();
        result = result * 59 + ($gradientNormalizationThreshold == null ? 43 : $gradientNormalizationThreshold.hashCode());
        ParameterSpace<ConvolutionMode> $convolutionMode = this.getConvolutionMode();
        result = result * 59 + ($convolutionMode == null ? 43 : $convolutionMode.hashCode());
        List<LayerConf> $layerSpaces = this.getLayerSpaces();
        result = result * 59 + ($layerSpaces == null ? 43 : ((Object)$layerSpaces).hashCode());
        ParameterSpace<BackpropType> $backpropType = this.getBackpropType();
        result = result * 59 + ($backpropType == null ? 43 : $backpropType.hashCode());
        ParameterSpace<Integer> $tbpttFwdLength = this.getTbpttFwdLength();
        result = result * 59 + ($tbpttFwdLength == null ? 43 : $tbpttFwdLength.hashCode());
        ParameterSpace<Integer> $tbpttBwdLength = this.getTbpttBwdLength();
        result = result * 59 + ($tbpttBwdLength == null ? 43 : $tbpttBwdLength.hashCode());
        ParameterSpace<List<LayerConstraint>> $allParamConstraints = this.getAllParamConstraints();
        result = result * 59 + ($allParamConstraints == null ? 43 : $allParamConstraints.hashCode());
        ParameterSpace<List<LayerConstraint>> $weightConstraints = this.getWeightConstraints();
        result = result * 59 + ($weightConstraints == null ? 43 : $weightConstraints.hashCode());
        ParameterSpace<List<LayerConstraint>> $biasConstraints = this.getBiasConstraints();
        result = result * 59 + ($biasConstraints == null ? 43 : $biasConstraints.hashCode());
        result = result * 59 + this.getNumEpochs();
        return result;
    }

    public Long getSeed() {
        return this.seed;
    }

    public ParameterSpace<OptimizationAlgorithm> getOptimizationAlgo() {
        return this.optimizationAlgo;
    }

    public ParameterSpace<IActivation> getActivationFunction() {
        return this.activationFunction;
    }

    public ParameterSpace<Double> getBiasInit() {
        return this.biasInit;
    }

    public ParameterSpace<WeightInit> getWeightInit() {
        return this.weightInit;
    }

    public ParameterSpace<Distribution> getDist() {
        return this.dist;
    }

    public ParameterSpace<Integer> getMaxNumLineSearchIterations() {
        return this.maxNumLineSearchIterations;
    }

    public ParameterSpace<Boolean> getMiniBatch() {
        return this.miniBatch;
    }

    public ParameterSpace<Boolean> getMinimize() {
        return this.minimize;
    }

    public ParameterSpace<StepFunction> getStepFunction() {
        return this.stepFunction;
    }

    public ParameterSpace<Double> getL1() {
        return this.l1;
    }

    public ParameterSpace<Double> getL2() {
        return this.l2;
    }

    public ParameterSpace<Double> getL1Bias() {
        return this.l1Bias;
    }

    public ParameterSpace<Double> getL2Bias() {
        return this.l2Bias;
    }

    public ParameterSpace<IUpdater> getUpdater() {
        return this.updater;
    }

    public ParameterSpace<IUpdater> getBiasUpdater() {
        return this.biasUpdater;
    }

    public ParameterSpace<IWeightNoise> getWeightNoise() {
        return this.weightNoise;
    }

    public ParameterSpace<IDropout> getDropout() {
        return this.dropout;
    }

    public ParameterSpace<GradientNormalization> getGradientNormalization() {
        return this.gradientNormalization;
    }

    public ParameterSpace<Double> getGradientNormalizationThreshold() {
        return this.gradientNormalizationThreshold;
    }

    public ParameterSpace<ConvolutionMode> getConvolutionMode() {
        return this.convolutionMode;
    }

    public List<LayerConf> getLayerSpaces() {
        return this.layerSpaces;
    }

    public ParameterSpace<BackpropType> getBackpropType() {
        return this.backpropType;
    }

    public ParameterSpace<Integer> getTbpttFwdLength() {
        return this.tbpttFwdLength;
    }

    public ParameterSpace<Integer> getTbpttBwdLength() {
        return this.tbpttBwdLength;
    }

    public ParameterSpace<List<LayerConstraint>> getAllParamConstraints() {
        return this.allParamConstraints;
    }

    public ParameterSpace<List<LayerConstraint>> getWeightConstraints() {
        return this.weightConstraints;
    }

    public ParameterSpace<List<LayerConstraint>> getBiasConstraints() {
        return this.biasConstraints;
    }

    public int getNumEpochs() {
        return this.numEpochs;
    }

    public void setSeed(Long seed) {
        this.seed = seed;
    }

    public void setOptimizationAlgo(ParameterSpace<OptimizationAlgorithm> optimizationAlgo) {
        this.optimizationAlgo = optimizationAlgo;
    }

    public void setActivationFunction(ParameterSpace<IActivation> activationFunction) {
        this.activationFunction = activationFunction;
    }

    public void setBiasInit(ParameterSpace<Double> biasInit) {
        this.biasInit = biasInit;
    }

    public void setWeightInit(ParameterSpace<WeightInit> weightInit) {
        this.weightInit = weightInit;
    }

    public void setDist(ParameterSpace<Distribution> dist) {
        this.dist = dist;
    }

    public void setMaxNumLineSearchIterations(ParameterSpace<Integer> maxNumLineSearchIterations) {
        this.maxNumLineSearchIterations = maxNumLineSearchIterations;
    }

    public void setMiniBatch(ParameterSpace<Boolean> miniBatch) {
        this.miniBatch = miniBatch;
    }

    public void setMinimize(ParameterSpace<Boolean> minimize) {
        this.minimize = minimize;
    }

    public void setStepFunction(ParameterSpace<StepFunction> stepFunction) {
        this.stepFunction = stepFunction;
    }

    public void setL1(ParameterSpace<Double> l1) {
        this.l1 = l1;
    }

    public void setL2(ParameterSpace<Double> l2) {
        this.l2 = l2;
    }

    public void setL1Bias(ParameterSpace<Double> l1Bias) {
        this.l1Bias = l1Bias;
    }

    public void setL2Bias(ParameterSpace<Double> l2Bias) {
        this.l2Bias = l2Bias;
    }

    public void setUpdater(ParameterSpace<IUpdater> updater) {
        this.updater = updater;
    }

    public void setBiasUpdater(ParameterSpace<IUpdater> biasUpdater) {
        this.biasUpdater = biasUpdater;
    }

    public void setWeightNoise(ParameterSpace<IWeightNoise> weightNoise) {
        this.weightNoise = weightNoise;
    }

    public void setDropout(ParameterSpace<IDropout> dropout) {
        this.dropout = dropout;
    }

    public void setGradientNormalization(ParameterSpace<GradientNormalization> gradientNormalization) {
        this.gradientNormalization = gradientNormalization;
    }

    public void setGradientNormalizationThreshold(ParameterSpace<Double> gradientNormalizationThreshold) {
        this.gradientNormalizationThreshold = gradientNormalizationThreshold;
    }

    public void setConvolutionMode(ParameterSpace<ConvolutionMode> convolutionMode) {
        this.convolutionMode = convolutionMode;
    }

    public void setLayerSpaces(List<LayerConf> layerSpaces) {
        this.layerSpaces = layerSpaces;
    }

    public void setBackpropType(ParameterSpace<BackpropType> backpropType) {
        this.backpropType = backpropType;
    }

    public void setTbpttFwdLength(ParameterSpace<Integer> tbpttFwdLength) {
        this.tbpttFwdLength = tbpttFwdLength;
    }

    public void setTbpttBwdLength(ParameterSpace<Integer> tbpttBwdLength) {
        this.tbpttBwdLength = tbpttBwdLength;
    }

    public void setAllParamConstraints(ParameterSpace<List<LayerConstraint>> allParamConstraints) {
        this.allParamConstraints = allParamConstraints;
    }

    public void setWeightConstraints(ParameterSpace<List<LayerConstraint>> weightConstraints) {
        this.weightConstraints = weightConstraints;
    }

    public void setBiasConstraints(ParameterSpace<List<LayerConstraint>> biasConstraints) {
        this.biasConstraints = biasConstraints;
    }

    public void setNumEpochs(int numEpochs) {
        this.numEpochs = numEpochs;
    }

    static {
        JsonMapper.getMapper().registerSubtypes(new Class[]{ComputationGraphSpace.class, MultiLayerSpace.class});
        YamlMapper.getMapper().registerSubtypes(new Class[]{ComputationGraphSpace.class, MultiLayerSpace.class});
    }

    protected static abstract class Builder<T extends Builder<T>> {
        private Long seed;
        private ParameterSpace<OptimizationAlgorithm> optimizationAlgo;
        private ParameterSpace<IActivation> activationFunction;
        private ParameterSpace<Double> biasInit;
        private ParameterSpace<WeightInit> weightInit;
        private ParameterSpace<Distribution> dist;
        private ParameterSpace<Integer> maxNumLineSearchIterations;
        private ParameterSpace<Boolean> miniBatch;
        private ParameterSpace<Boolean> minimize;
        private ParameterSpace<StepFunction> stepFunction;
        private ParameterSpace<Double> l1;
        private ParameterSpace<Double> l2;
        private ParameterSpace<Double> l1Bias;
        private ParameterSpace<Double> l2Bias;
        private ParameterSpace<IUpdater> updater;
        private ParameterSpace<IUpdater> biasUpdater;
        private ParameterSpace<IWeightNoise> weightNoise;
        private ParameterSpace<IDropout> dropout;
        private ParameterSpace<GradientNormalization> gradientNormalization;
        private ParameterSpace<Double> gradientNormalizationThreshold;
        private ParameterSpace<ConvolutionMode> convolutionMode;
        private ParameterSpace<List<LayerConstraint>> allParamConstraints;
        private ParameterSpace<List<LayerConstraint>> weightConstraints;
        private ParameterSpace<List<LayerConstraint>> biasConstraints;
        private ParameterSpace<BackpropType> backpropType;
        private ParameterSpace<Integer> tbpttFwdLength;
        private ParameterSpace<Integer> tbpttBwdLength;
        private EarlyStoppingConfiguration earlyStoppingConfiguration;
        private int numEpochs = 1;
        protected boolean validateOutputLayerConfig = true;

        protected Builder() {
        }

        public T seed(long seed) {
            this.seed = seed;
            return (T)this;
        }

        public T optimizationAlgo(OptimizationAlgorithm optimizationAlgorithm) {
            return this.optimizationAlgo((ParameterSpace<OptimizationAlgorithm>)new FixedValue((Object)optimizationAlgorithm));
        }

        public T optimizationAlgo(ParameterSpace<OptimizationAlgorithm> parameterSpace) {
            this.optimizationAlgo = parameterSpace;
            return (T)this;
        }

        public T activation(Activation activationFunction) {
            return this.activation((ParameterSpace<Activation>)new FixedValue((Object)activationFunction));
        }

        public T activation(ParameterSpace<Activation> activationFunction) {
            return this.activationFn((ParameterSpace<IActivation>)new ActivationParameterSpaceAdapter(activationFunction));
        }

        public T activationFn(ParameterSpace<IActivation> activationFunction) {
            this.activationFunction = activationFunction;
            return (T)this;
        }

        public T biasInit(double biasInit) {
            return this.biasInit((ParameterSpace<Double>)new FixedValue((Object)biasInit));
        }

        public T biasInit(ParameterSpace<Double> biasInit) {
            this.biasInit = biasInit;
            return (T)this;
        }

        public T weightInit(WeightInit weightInit) {
            return this.weightInit((ParameterSpace<WeightInit>)new FixedValue((Object)weightInit));
        }

        public T weightInit(ParameterSpace<WeightInit> weightInit) {
            this.weightInit = weightInit;
            return (T)this;
        }

        public T dist(Distribution dist) {
            return this.dist((ParameterSpace<Distribution>)new FixedValue((Object)dist));
        }

        public T dist(ParameterSpace<Distribution> dist) {
            this.dist = dist;
            return (T)this;
        }

        public T maxNumLineSearchIterations(int maxNumLineSearchIterations) {
            return this.maxNumLineSearchIterations((ParameterSpace<Integer>)new FixedValue((Object)maxNumLineSearchIterations));
        }

        public T maxNumLineSearchIterations(ParameterSpace<Integer> maxNumLineSearchIterations) {
            this.maxNumLineSearchIterations = maxNumLineSearchIterations;
            return (T)this;
        }

        public T miniBatch(boolean minibatch) {
            return this.miniBatch((ParameterSpace<Boolean>)new FixedValue((Object)minibatch));
        }

        public T miniBatch(ParameterSpace<Boolean> miniBatch) {
            this.miniBatch = miniBatch;
            return (T)this;
        }

        public T minimize(boolean minimize) {
            return this.minimize((ParameterSpace<Boolean>)new FixedValue((Object)minimize));
        }

        public T minimize(ParameterSpace<Boolean> minimize) {
            this.minimize = minimize;
            return (T)this;
        }

        public T stepFunction(StepFunction stepFunction) {
            return this.stepFunction((ParameterSpace<StepFunction>)new FixedValue((Object)stepFunction));
        }

        public T stepFunction(ParameterSpace<StepFunction> stepFunction) {
            this.stepFunction = stepFunction;
            return (T)this;
        }

        public T l1(double l1) {
            return this.l1((ParameterSpace<Double>)new FixedValue((Object)l1));
        }

        public T l1(ParameterSpace<Double> l1) {
            this.l1 = l1;
            return (T)this;
        }

        public T l2(double l2) {
            return this.l2((ParameterSpace<Double>)new FixedValue((Object)l2));
        }

        public T l2(ParameterSpace<Double> l2) {
            this.l2 = l2;
            return (T)this;
        }

        public T l1Bias(double l1Bias) {
            return this.l1Bias((ParameterSpace<Double>)new FixedValue((Object)l1Bias));
        }

        public T l1Bias(ParameterSpace<Double> l1Bias) {
            this.l1Bias = l1Bias;
            return (T)this;
        }

        public T l2Bias(double l2Bias) {
            return this.l2Bias((ParameterSpace<Double>)new FixedValue((Object)l2Bias));
        }

        public T l2Bias(ParameterSpace<Double> l2Bias) {
            this.l2Bias = l2Bias;
            return (T)this;
        }

        public T updater(IUpdater updater) {
            return this.updater((ParameterSpace<IUpdater>)new FixedValue((Object)updater));
        }

        public T updater(ParameterSpace<IUpdater> updater) {
            this.updater = updater;
            return (T)this;
        }

        public T biasUpdater(IUpdater biasUpdater) {
            return this.biasUpdater((ParameterSpace<IUpdater>)new FixedValue((Object)biasUpdater));
        }

        public T biasUpdater(ParameterSpace<IUpdater> biasUpdater) {
            this.biasUpdater = biasUpdater;
            return (T)this;
        }

        public T weightNoise(IWeightNoise weightNoise) {
            return this.weightNoise((ParameterSpace<IWeightNoise>)new FixedValue((Object)weightNoise));
        }

        public T weightNoise(ParameterSpace<IWeightNoise> weightNoise) {
            this.weightNoise = weightNoise;
            return (T)this;
        }

        public T dropOut(double dropout) {
            return this.idropOut((IDropout)new Dropout(dropout));
        }

        public T dropOut(ParameterSpace<Double> dropOut) {
            return this.idropOut((ParameterSpace<IDropout>)new DropoutSpace(dropOut));
        }

        public T idropOut(IDropout idropOut) {
            return this.idropOut((ParameterSpace<IDropout>)new FixedValue((Object)idropOut));
        }

        public T idropOut(ParameterSpace<IDropout> idropOut) {
            this.dropout = idropOut;
            return (T)this;
        }

        public T gradientNormalization(GradientNormalization gradientNormalization) {
            return this.gradientNormalization((ParameterSpace<GradientNormalization>)new FixedValue((Object)gradientNormalization));
        }

        public T gradientNormalization(ParameterSpace<GradientNormalization> gradientNormalization) {
            this.gradientNormalization = gradientNormalization;
            return (T)this;
        }

        public T gradientNormalizationThreshold(double threshold) {
            return this.gradientNormalizationThreshold((ParameterSpace<Double>)new FixedValue((Object)threshold));
        }

        public T gradientNormalizationThreshold(ParameterSpace<Double> gradientNormalizationThreshold) {
            this.gradientNormalizationThreshold = gradientNormalizationThreshold;
            return (T)this;
        }

        public T convolutionMode(ConvolutionMode convolutionMode) {
            return this.convolutionMode((ParameterSpace<ConvolutionMode>)new FixedValue((Object)convolutionMode));
        }

        public T convolutionMode(ParameterSpace<ConvolutionMode> convolutionMode) {
            this.convolutionMode = convolutionMode;
            return (T)this;
        }

        public T backpropType(BackpropType backpropType) {
            return this.backpropType((ParameterSpace<BackpropType>)new FixedValue((Object)backpropType));
        }

        public T backpropType(ParameterSpace<BackpropType> backpropType) {
            this.backpropType = backpropType;
            return (T)this;
        }

        public T tbpttFwdLength(int tbpttFwdLength) {
            return this.tbpttFwdLength((ParameterSpace<Integer>)new FixedValue((Object)tbpttFwdLength));
        }

        public T tbpttFwdLength(ParameterSpace<Integer> tbpttFwdLength) {
            this.tbpttFwdLength = tbpttFwdLength;
            return (T)this;
        }

        public T tbpttBwdLength(int tbpttBwdLength) {
            return this.tbpttBwdLength((ParameterSpace<Integer>)new FixedValue((Object)tbpttBwdLength));
        }

        public T tbpttBwdLength(ParameterSpace<Integer> tbpttBwdLength) {
            this.tbpttBwdLength = tbpttBwdLength;
            return (T)this;
        }

        public T constrainWeights(LayerConstraint ... constraints) {
            return this.constrainWeights((ParameterSpace<List<LayerConstraint>>)new FixedValue(Arrays.asList(constraints)));
        }

        public T constrainWeights(ParameterSpace<List<LayerConstraint>> constraints) {
            this.weightConstraints = constraints;
            return (T)this;
        }

        public T constrainBias(LayerConstraint ... constraints) {
            return this.constrainBias((ParameterSpace<List<LayerConstraint>>)new FixedValue(Arrays.asList(constraints)));
        }

        public T constrainBias(ParameterSpace<List<LayerConstraint>> constraints) {
            this.biasConstraints = constraints;
            return (T)this;
        }

        public T constrainAllParams(LayerConstraint ... constraints) {
            return this.constrainAllParams((ParameterSpace<List<LayerConstraint>>)new FixedValue(Arrays.asList(constraints)));
        }

        public T constrainAllParams(ParameterSpace<List<LayerConstraint>> constraints) {
            this.allParamConstraints = constraints;
            return (T)this;
        }

        public T validateOutputLayerConfig(boolean validate) {
            this.validateOutputLayerConfig = validate;
            return (T)this;
        }

        public T numEpochs(int numEpochs) {
            this.numEpochs = numEpochs;
            return (T)this;
        }

        public abstract <E extends BaseNetworkSpace> E build();
    }

    public static class LayerConf {
        protected LayerSpace<?> layerSpace;
        protected String layerName;
        protected String[] inputs;
        protected ParameterSpace<Integer> numLayers;
        protected boolean duplicateConfig;
        protected InputPreProcessor preProcessor;

        public LayerConf(LayerSpace<?> layerSpace, String layerName, String[] inputs, ParameterSpace<Integer> numLayers, boolean duplicateConfig, InputPreProcessor preProcessor) {
            this.layerSpace = layerSpace;
            this.layerName = layerName;
            this.inputs = inputs;
            this.numLayers = numLayers;
            this.duplicateConfig = duplicateConfig;
            this.preProcessor = preProcessor;
        }

        public LayerSpace<?> getLayerSpace() {
            return this.layerSpace;
        }

        public String getLayerName() {
            return this.layerName;
        }

        public String[] getInputs() {
            return this.inputs;
        }

        public ParameterSpace<Integer> getNumLayers() {
            return this.numLayers;
        }

        public boolean isDuplicateConfig() {
            return this.duplicateConfig;
        }

        public InputPreProcessor getPreProcessor() {
            return this.preProcessor;
        }

        public void setLayerSpace(LayerSpace<?> layerSpace) {
            this.layerSpace = layerSpace;
        }

        public void setLayerName(String layerName) {
            this.layerName = layerName;
        }

        public void setInputs(String[] inputs) {
            this.inputs = inputs;
        }

        public void setNumLayers(ParameterSpace<Integer> numLayers) {
            this.numLayers = numLayers;
        }

        public void setDuplicateConfig(boolean duplicateConfig) {
            this.duplicateConfig = duplicateConfig;
        }

        public void setPreProcessor(InputPreProcessor preProcessor) {
            this.preProcessor = preProcessor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LayerConf)) {
                return false;
            }
            LayerConf other = (LayerConf)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LayerSpace<?> this$layerSpace = this.getLayerSpace();
            LayerSpace<?> other$layerSpace = other.getLayerSpace();
            if (this$layerSpace == null ? other$layerSpace != null : !((Object)this$layerSpace).equals(other$layerSpace)) {
                return false;
            }
            String this$layerName = this.getLayerName();
            String other$layerName = other.getLayerName();
            if (this$layerName == null ? other$layerName != null : !this$layerName.equals(other$layerName)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getInputs(), other.getInputs())) {
                return false;
            }
            ParameterSpace<Integer> this$numLayers = this.getNumLayers();
            ParameterSpace<Integer> other$numLayers = other.getNumLayers();
            if (this$numLayers == null ? other$numLayers != null : !this$numLayers.equals(other$numLayers)) {
                return false;
            }
            if (this.isDuplicateConfig() != other.isDuplicateConfig()) {
                return false;
            }
            InputPreProcessor this$preProcessor = this.getPreProcessor();
            InputPreProcessor other$preProcessor = other.getPreProcessor();
            return !(this$preProcessor == null ? other$preProcessor != null : !this$preProcessor.equals(other$preProcessor));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LayerConf;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LayerSpace<?> $layerSpace = this.getLayerSpace();
            result = result * 59 + ($layerSpace == null ? 43 : ((Object)$layerSpace).hashCode());
            String $layerName = this.getLayerName();
            result = result * 59 + ($layerName == null ? 43 : $layerName.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getInputs());
            ParameterSpace<Integer> $numLayers = this.getNumLayers();
            result = result * 59 + ($numLayers == null ? 43 : $numLayers.hashCode());
            result = result * 59 + (this.isDuplicateConfig() ? 79 : 97);
            InputPreProcessor $preProcessor = this.getPreProcessor();
            result = result * 59 + ($preProcessor == null ? 43 : $preProcessor.hashCode());
            return result;
        }

        public String toString() {
            return "BaseNetworkSpace.LayerConf(layerSpace=" + this.getLayerSpace() + ", layerName=" + this.getLayerName() + ", inputs=" + Arrays.deepToString(this.getInputs()) + ", numLayers=" + this.getNumLayers() + ", duplicateConfig=" + this.isDuplicateConfig() + ", preProcessor=" + this.getPreProcessor() + ")";
        }

        public LayerConf() {
        }
    }
}

