/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.conf.updater;

import org.deeplearning4j.arbiter.conf.updater.BaseUpdaterSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.nd4j.linalg.learning.config.AdaGrad;
import org.nd4j.linalg.learning.config.IUpdater;
import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class AdaGradSpace
extends BaseUpdaterSpace {
    private ParameterSpace<Double> learningRate;
    private ParameterSpace<ISchedule> lrSchedule;

    public AdaGradSpace(ParameterSpace<Double> learningRate) {
        this(learningRate, null);
    }

    public static AdaGradSpace withLR(ParameterSpace<Double> lr) {
        return new AdaGradSpace(lr, null);
    }

    public static AdaGradSpace withLRSchedule(ParameterSpace<ISchedule> lrSchedule) {
        return new AdaGradSpace(null, lrSchedule);
    }

    protected AdaGradSpace(@JsonProperty(value="learningRate") ParameterSpace<Double> learningRate, @JsonProperty(value="lrSchedule") ParameterSpace<ISchedule> lrSchedule) {
        this.learningRate = learningRate;
        this.lrSchedule = lrSchedule;
    }

    public IUpdater getValue(double[] parameterValues) {
        if (this.lrSchedule != null) {
            return new AdaGrad((ISchedule)this.lrSchedule.getValue(parameterValues));
        }
        return new AdaGrad(((Double)this.learningRate.getValue(parameterValues)).doubleValue());
    }

    public ParameterSpace<Double> getLearningRate() {
        return this.learningRate;
    }

    public ParameterSpace<ISchedule> getLrSchedule() {
        return this.lrSchedule;
    }

    public void setLearningRate(ParameterSpace<Double> learningRate) {
        this.learningRate = learningRate;
    }

    public void setLrSchedule(ParameterSpace<ISchedule> lrSchedule) {
        this.lrSchedule = lrSchedule;
    }

    @Override
    public String toString() {
        return "AdaGradSpace(learningRate=" + this.getLearningRate() + ", lrSchedule=" + this.getLrSchedule() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdaGradSpace)) {
            return false;
        }
        AdaGradSpace other = (AdaGradSpace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ParameterSpace<Double> this$learningRate = this.getLearningRate();
        ParameterSpace<Double> other$learningRate = other.getLearningRate();
        if (this$learningRate == null ? other$learningRate != null : !this$learningRate.equals(other$learningRate)) {
            return false;
        }
        ParameterSpace<ISchedule> this$lrSchedule = this.getLrSchedule();
        ParameterSpace<ISchedule> other$lrSchedule = other.getLrSchedule();
        return !(this$lrSchedule == null ? other$lrSchedule != null : !this$lrSchedule.equals(other$lrSchedule));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AdaGradSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ParameterSpace<Double> $learningRate = this.getLearningRate();
        result = result * 59 + ($learningRate == null ? 43 : $learningRate.hashCode());
        ParameterSpace<ISchedule> $lrSchedule = this.getLrSchedule();
        result = result * 59 + ($lrSchedule == null ? 43 : $lrSchedule.hashCode());
        return result;
    }
}

