/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.conf.updater.schedule;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.linalg.schedule.PolySchedule;
import org.nd4j.linalg.schedule.ScheduleType;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class PolyScheduleSpace
implements ParameterSpace<ISchedule> {
    private ScheduleType scheduleType;
    private ParameterSpace<Double> initialValue;
    private ParameterSpace<Double> power;
    private ParameterSpace<Integer> maxIter;

    public PolyScheduleSpace(@NonNull ScheduleType scheduleType, @NonNull ParameterSpace<Double> initialValue, double power, int maxIter) {
        this(scheduleType, initialValue, (ParameterSpace<Double>)new FixedValue((Object)power), (ParameterSpace<Integer>)new FixedValue((Object)maxIter));
        if (scheduleType == null) {
            throw new NullPointerException("scheduleType is marked non-null but is null");
        }
        if (initialValue == null) {
            throw new NullPointerException("initialValue is marked non-null but is null");
        }
    }

    public PolyScheduleSpace(@JsonProperty(value="scheduleType") @NonNull ScheduleType scheduleType, @JsonProperty(value="initialValue") @NonNull ParameterSpace<Double> initialValue, @JsonProperty(value="power") @NonNull ParameterSpace<Double> power, @JsonProperty(value="maxIter") @NonNull ParameterSpace<Integer> maxIter) {
        if (scheduleType == null) {
            throw new NullPointerException("scheduleType is marked non-null but is null");
        }
        if (initialValue == null) {
            throw new NullPointerException("initialValue is marked non-null but is null");
        }
        if (power == null) {
            throw new NullPointerException("power is marked non-null but is null");
        }
        if (maxIter == null) {
            throw new NullPointerException("maxIter is marked non-null but is null");
        }
        this.scheduleType = scheduleType;
        this.initialValue = initialValue;
        this.power = power;
        this.maxIter = maxIter;
    }

    public ISchedule getValue(double[] parameterValues) {
        return new PolySchedule(this.scheduleType, ((Double)this.initialValue.getValue(parameterValues)).doubleValue(), ((Double)this.power.getValue(parameterValues)).doubleValue(), ((Integer)this.maxIter.getValue(parameterValues)).intValue());
    }

    public int numParameters() {
        return this.initialValue.numParameters() + this.power.numParameters() + this.maxIter.numParameters();
    }

    public List<ParameterSpace> collectLeaves() {
        return Arrays.asList(this.initialValue, this.power, this.maxIter);
    }

    public Map<String, ParameterSpace> getNestedSpaces() {
        LinkedHashMap<String, ParameterSpace> out = new LinkedHashMap<String, ParameterSpace>();
        out.put("initialValue", this.initialValue);
        out.put("power", this.power);
        out.put("maxIter", this.maxIter);
        return out;
    }

    public boolean isLeaf() {
        return false;
    }

    public void setIndices(int ... indices) {
        int[] sub;
        if (this.initialValue.numParameters() > 0) {
            int[] sub2 = Arrays.copyOfRange(indices, 0, this.initialValue.numParameters());
            this.initialValue.setIndices(sub2);
        }
        if (this.power.numParameters() > 0) {
            int np = this.initialValue.numParameters();
            sub = Arrays.copyOfRange(indices, np, np + this.power.numParameters());
            this.power.setIndices(sub);
        }
        if (this.maxIter.numParameters() > 0) {
            int np = this.initialValue.numParameters() + this.power.numParameters();
            sub = Arrays.copyOfRange(indices, np, np + this.maxIter.numParameters());
            this.maxIter.setIndices(sub);
        }
    }

    public PolyScheduleSpace() {
    }

    public ScheduleType getScheduleType() {
        return this.scheduleType;
    }

    public ParameterSpace<Double> getInitialValue() {
        return this.initialValue;
    }

    public ParameterSpace<Double> getPower() {
        return this.power;
    }

    public ParameterSpace<Integer> getMaxIter() {
        return this.maxIter;
    }

    public void setScheduleType(ScheduleType scheduleType) {
        this.scheduleType = scheduleType;
    }

    public void setInitialValue(ParameterSpace<Double> initialValue) {
        this.initialValue = initialValue;
    }

    public void setPower(ParameterSpace<Double> power) {
        this.power = power;
    }

    public void setMaxIter(ParameterSpace<Integer> maxIter) {
        this.maxIter = maxIter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PolyScheduleSpace)) {
            return false;
        }
        PolyScheduleSpace other = (PolyScheduleSpace)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScheduleType this$scheduleType = this.getScheduleType();
        ScheduleType other$scheduleType = other.getScheduleType();
        if (this$scheduleType == null ? other$scheduleType != null : !this$scheduleType.equals(other$scheduleType)) {
            return false;
        }
        ParameterSpace<Double> this$initialValue = this.getInitialValue();
        ParameterSpace<Double> other$initialValue = other.getInitialValue();
        if (this$initialValue == null ? other$initialValue != null : !this$initialValue.equals(other$initialValue)) {
            return false;
        }
        ParameterSpace<Double> this$power = this.getPower();
        ParameterSpace<Double> other$power = other.getPower();
        if (this$power == null ? other$power != null : !this$power.equals(other$power)) {
            return false;
        }
        ParameterSpace<Integer> this$maxIter = this.getMaxIter();
        ParameterSpace<Integer> other$maxIter = other.getMaxIter();
        return !(this$maxIter == null ? other$maxIter != null : !this$maxIter.equals(other$maxIter));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PolyScheduleSpace;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScheduleType $scheduleType = this.getScheduleType();
        result = result * 59 + ($scheduleType == null ? 43 : $scheduleType.hashCode());
        ParameterSpace<Double> $initialValue = this.getInitialValue();
        result = result * 59 + ($initialValue == null ? 43 : $initialValue.hashCode());
        ParameterSpace<Double> $power = this.getPower();
        result = result * 59 + ($power == null ? 43 : $power.hashCode());
        ParameterSpace<Integer> $maxIter = this.getMaxIter();
        result = result * 59 + ($maxIter == null ? 43 : $maxIter.hashCode());
        return result;
    }

    public String toString() {
        return "PolyScheduleSpace(scheduleType=" + this.getScheduleType() + ", initialValue=" + this.getInitialValue() + ", power=" + this.getPower() + ", maxIter=" + this.getMaxIter() + ")";
    }
}

