/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.dropout;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.nn.conf.dropout.AlphaDropout;
import org.deeplearning4j.nn.conf.dropout.IDropout;

public class AlphaDropoutSpace
implements ParameterSpace<IDropout> {
    private ParameterSpace<Double> dropout;

    public AlphaDropoutSpace(double activationRetainProbability) {
        this((ParameterSpace<Double>)new FixedValue((Object)activationRetainProbability));
    }

    public IDropout getValue(double[] parameterValues) {
        return new AlphaDropout(((Double)this.dropout.getValue(parameterValues)).doubleValue());
    }

    public int numParameters() {
        return this.dropout.numParameters();
    }

    public List<ParameterSpace> collectLeaves() {
        return Collections.singletonList(this.dropout);
    }

    public Map<String, ParameterSpace> getNestedSpaces() {
        return Collections.singletonMap("dropout", this.dropout);
    }

    public boolean isLeaf() {
        return false;
    }

    public void setIndices(int ... indices) {
        this.dropout.setIndices(indices);
    }

    public AlphaDropoutSpace(ParameterSpace<Double> dropout) {
        this.dropout = dropout;
    }
}

