/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import org.deeplearning4j.arbiter.layers.LayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.arbiter.util.LeafUtils;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.LocalResponseNormalization;

public class LocalResponseNormalizationLayerSpace
extends LayerSpace<LocalResponseNormalization> {
    private ParameterSpace<Double> n;
    private ParameterSpace<Double> k;
    private ParameterSpace<Double> alpha;
    private ParameterSpace<Double> beta;

    private LocalResponseNormalizationLayerSpace(Builder builder) {
        super(builder);
        this.n = builder.n;
        this.k = builder.k;
        this.alpha = builder.alpha;
        this.beta = builder.beta;
        this.numParameters = LeafUtils.countUniqueParameters(this.collectLeaves());
    }

    public LocalResponseNormalization getValue(double[] values) {
        LocalResponseNormalization.Builder b = new LocalResponseNormalization.Builder();
        this.setLayerOptionsBuilder(b, values);
        return b.build();
    }

    protected void setLayerOptionsBuilder(LocalResponseNormalization.Builder builder, double[] values) {
        super.setLayerOptionsBuilder((Layer.Builder)builder, values);
        if (this.n != null) {
            builder.n(((Double)this.n.getValue(values)).doubleValue());
        }
        if (this.k != null) {
            builder.k(((Double)this.k.getValue(values)).doubleValue());
        }
        if (this.alpha != null) {
            builder.alpha(((Double)this.alpha.getValue(values)).doubleValue());
        }
        if (this.beta != null) {
            builder.beta(((Double)this.beta.getValue(values)).doubleValue());
        }
    }

    public ParameterSpace<Double> getN() {
        return this.n;
    }

    public ParameterSpace<Double> getK() {
        return this.k;
    }

    public ParameterSpace<Double> getAlpha() {
        return this.alpha;
    }

    public ParameterSpace<Double> getBeta() {
        return this.beta;
    }

    public void setN(ParameterSpace<Double> n) {
        this.n = n;
    }

    public void setK(ParameterSpace<Double> k) {
        this.k = k;
    }

    public void setAlpha(ParameterSpace<Double> alpha) {
        this.alpha = alpha;
    }

    public void setBeta(ParameterSpace<Double> beta) {
        this.beta = beta;
    }

    @Override
    public String toString() {
        return "LocalResponseNormalizationLayerSpace(n=" + this.getN() + ", k=" + this.getK() + ", alpha=" + this.getAlpha() + ", beta=" + this.getBeta() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalResponseNormalizationLayerSpace)) {
            return false;
        }
        LocalResponseNormalizationLayerSpace other = (LocalResponseNormalizationLayerSpace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterSpace<Double> this$n = this.getN();
        ParameterSpace<Double> other$n = other.getN();
        if (this$n == null ? other$n != null : !this$n.equals(other$n)) {
            return false;
        }
        ParameterSpace<Double> this$k = this.getK();
        ParameterSpace<Double> other$k = other.getK();
        if (this$k == null ? other$k != null : !this$k.equals(other$k)) {
            return false;
        }
        ParameterSpace<Double> this$alpha = this.getAlpha();
        ParameterSpace<Double> other$alpha = other.getAlpha();
        if (this$alpha == null ? other$alpha != null : !this$alpha.equals(other$alpha)) {
            return false;
        }
        ParameterSpace<Double> this$beta = this.getBeta();
        ParameterSpace<Double> other$beta = other.getBeta();
        return !(this$beta == null ? other$beta != null : !this$beta.equals(other$beta));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LocalResponseNormalizationLayerSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ParameterSpace<Double> $n = this.getN();
        result = result * 59 + ($n == null ? 43 : $n.hashCode());
        ParameterSpace<Double> $k = this.getK();
        result = result * 59 + ($k == null ? 43 : $k.hashCode());
        ParameterSpace<Double> $alpha = this.getAlpha();
        result = result * 59 + ($alpha == null ? 43 : $alpha.hashCode());
        ParameterSpace<Double> $beta = this.getBeta();
        result = result * 59 + ($beta == null ? 43 : $beta.hashCode());
        return result;
    }

    private LocalResponseNormalizationLayerSpace() {
    }

    public static class Builder
    extends LayerSpace.Builder<Builder> {
        private ParameterSpace<Double> n;
        private ParameterSpace<Double> k;
        private ParameterSpace<Double> alpha;
        private ParameterSpace<Double> beta;

        public Builder n(double n) {
            return this.n((ParameterSpace<Double>)new FixedValue((Object)n));
        }

        public Builder n(ParameterSpace<Double> n) {
            this.n = n;
            return this;
        }

        public Builder k(double k) {
            return this.k((ParameterSpace<Double>)new FixedValue((Object)k));
        }

        public Builder k(ParameterSpace<Double> k) {
            this.k = k;
            return this;
        }

        public Builder alpha(double alpha) {
            return this.alpha((ParameterSpace<Double>)new FixedValue((Object)alpha));
        }

        public Builder alpha(ParameterSpace<Double> alpha) {
            this.alpha = alpha;
            return this;
        }

        public Builder beta(double beta) {
            return this.beta((ParameterSpace<Double>)new FixedValue((Object)beta));
        }

        public Builder beta(ParameterSpace<Double> beta) {
            this.beta = beta;
            return this;
        }

        @Override
        public LocalResponseNormalizationLayerSpace build() {
            return new LocalResponseNormalizationLayerSpace(this);
        }
    }
}

