/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import org.deeplearning4j.arbiter.layers.BaseOutputLayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.arbiter.util.LeafUtils;
import org.deeplearning4j.nn.conf.layers.BaseOutputLayer;
import org.deeplearning4j.nn.conf.ocnn.OCNNOutputLayer;

public class OCNNLayerSpace
extends BaseOutputLayerSpace<OCNNOutputLayer> {
    protected ParameterSpace<Double> nuSpace;
    protected ParameterSpace<Double> initialRValue;
    protected ParameterSpace<Integer> hiddenLayerSize;
    protected ParameterSpace<Integer> windowSize;
    protected ParameterSpace<Boolean> configureR;

    private OCNNLayerSpace(Builder builder) {
        super(builder);
        this.numParameters = LeafUtils.countUniqueParameters(this.collectLeaves());
        this.nuSpace = builder.nuSpace;
        this.initialRValue = builder.initialRValue;
        this.hiddenLayerSize = builder.hiddenLayerSize;
        this.configureR = builder.configureR;
    }

    public OCNNOutputLayer getValue(double[] parameterValues) {
        OCNNOutputLayer.Builder o = new OCNNOutputLayer.Builder();
        this.setLayerOptionsBuilder(o, parameterValues);
        return o.build();
    }

    protected void setLayerOptionsBuilder(OCNNOutputLayer.Builder builder, double[] values) {
        super.setLayerOptionsBuilder((BaseOutputLayer.Builder)builder, values);
        builder.nu(((Double)this.nuSpace.getValue(values)).doubleValue());
        builder.hiddenLayerSize(((Integer)this.hiddenLayerSize.getValue(values)).intValue());
        builder.initialRValue(((Double)this.initialRValue.getValue(values)).doubleValue());
        builder.configureR(((Boolean)this.configureR.getValue(values)).booleanValue());
        builder.windowSize(((Integer)this.windowSize.getValue(values)).intValue());
    }

    public ParameterSpace<Double> getNuSpace() {
        return this.nuSpace;
    }

    public ParameterSpace<Double> getInitialRValue() {
        return this.initialRValue;
    }

    public ParameterSpace<Integer> getHiddenLayerSize() {
        return this.hiddenLayerSize;
    }

    public ParameterSpace<Integer> getWindowSize() {
        return this.windowSize;
    }

    public ParameterSpace<Boolean> getConfigureR() {
        return this.configureR;
    }

    public void setNuSpace(ParameterSpace<Double> nuSpace) {
        this.nuSpace = nuSpace;
    }

    public void setInitialRValue(ParameterSpace<Double> initialRValue) {
        this.initialRValue = initialRValue;
    }

    public void setHiddenLayerSize(ParameterSpace<Integer> hiddenLayerSize) {
        this.hiddenLayerSize = hiddenLayerSize;
    }

    public void setWindowSize(ParameterSpace<Integer> windowSize) {
        this.windowSize = windowSize;
    }

    public void setConfigureR(ParameterSpace<Boolean> configureR) {
        this.configureR = configureR;
    }

    @Override
    public String toString() {
        return "OCNNLayerSpace(nuSpace=" + this.getNuSpace() + ", initialRValue=" + this.getInitialRValue() + ", hiddenLayerSize=" + this.getHiddenLayerSize() + ", windowSize=" + this.getWindowSize() + ", configureR=" + this.getConfigureR() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OCNNLayerSpace)) {
            return false;
        }
        OCNNLayerSpace other = (OCNNLayerSpace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterSpace<Double> this$nuSpace = this.getNuSpace();
        ParameterSpace<Double> other$nuSpace = other.getNuSpace();
        if (this$nuSpace == null ? other$nuSpace != null : !this$nuSpace.equals(other$nuSpace)) {
            return false;
        }
        ParameterSpace<Double> this$initialRValue = this.getInitialRValue();
        ParameterSpace<Double> other$initialRValue = other.getInitialRValue();
        if (this$initialRValue == null ? other$initialRValue != null : !this$initialRValue.equals(other$initialRValue)) {
            return false;
        }
        ParameterSpace<Integer> this$hiddenLayerSize = this.getHiddenLayerSize();
        ParameterSpace<Integer> other$hiddenLayerSize = other.getHiddenLayerSize();
        if (this$hiddenLayerSize == null ? other$hiddenLayerSize != null : !this$hiddenLayerSize.equals(other$hiddenLayerSize)) {
            return false;
        }
        ParameterSpace<Integer> this$windowSize = this.getWindowSize();
        ParameterSpace<Integer> other$windowSize = other.getWindowSize();
        if (this$windowSize == null ? other$windowSize != null : !this$windowSize.equals(other$windowSize)) {
            return false;
        }
        ParameterSpace<Boolean> this$configureR = this.getConfigureR();
        ParameterSpace<Boolean> other$configureR = other.getConfigureR();
        return !(this$configureR == null ? other$configureR != null : !this$configureR.equals(other$configureR));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OCNNLayerSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ParameterSpace<Double> $nuSpace = this.getNuSpace();
        result = result * 59 + ($nuSpace == null ? 43 : $nuSpace.hashCode());
        ParameterSpace<Double> $initialRValue = this.getInitialRValue();
        result = result * 59 + ($initialRValue == null ? 43 : $initialRValue.hashCode());
        ParameterSpace<Integer> $hiddenLayerSize = this.getHiddenLayerSize();
        result = result * 59 + ($hiddenLayerSize == null ? 43 : $hiddenLayerSize.hashCode());
        ParameterSpace<Integer> $windowSize = this.getWindowSize();
        result = result * 59 + ($windowSize == null ? 43 : $windowSize.hashCode());
        ParameterSpace<Boolean> $configureR = this.getConfigureR();
        result = result * 59 + ($configureR == null ? 43 : $configureR.hashCode());
        return result;
    }

    private OCNNLayerSpace() {
    }

    public static class Builder
    extends BaseOutputLayerSpace.Builder<Builder> {
        protected ParameterSpace<Double> nuSpace;
        protected ParameterSpace<Double> initialRValue;
        protected ParameterSpace<Integer> hiddenLayerSize;
        protected ParameterSpace<Integer> windowSize;
        protected ParameterSpace<Boolean> configureR;

        public Builder nu(ParameterSpace<Double> nuSpace) {
            this.nuSpace = nuSpace;
            return this;
        }

        @Deprecated
        public Builder numHidden(ParameterSpace<Integer> numHiddenSpace) {
            return this.hiddenLayerSize(numHiddenSpace);
        }

        @Deprecated
        public Builder numHidden(int numHidden) {
            return this.hiddenLayerSize(numHidden);
        }

        public Builder hiddenLayerSize(ParameterSpace<Integer> hiddenLayerSize) {
            this.hiddenLayerSize = hiddenLayerSize;
            return this;
        }

        public Builder hiddenLayerSize(int hiddenLayerSize) {
            this.hiddenLayerSize = new FixedValue((Object)hiddenLayerSize);
            return this;
        }

        public Builder nu(double nu) {
            this.nuSpace = new FixedValue((Object)nu);
            return this;
        }

        public Builder initialRValue(double initialRValue) {
            this.initialRValue = new FixedValue((Object)initialRValue);
            return this;
        }

        public Builder initialRValue(ParameterSpace<Double> initialRValue) {
            this.initialRValue = initialRValue;
            return this;
        }

        public Builder windowSize(int windowSize) {
            this.windowSize = new FixedValue((Object)windowSize);
            return this;
        }

        public Builder windowSize(ParameterSpace<Integer> windowSize) {
            this.windowSize = windowSize;
            return this;
        }

        public Builder configureR(boolean configureR) {
            this.configureR = new FixedValue((Object)configureR);
            return this;
        }

        public Builder configureR(ParameterSpace<Boolean> configureR) {
            this.configureR = configureR;
            return this;
        }

        @Override
        public OCNNLayerSpace build() {
            return new OCNNLayerSpace(this);
        }
    }
}

