/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.layers;

import org.deeplearning4j.arbiter.layers.FeedForwardLayerSpace;
import org.deeplearning4j.arbiter.layers.LayerSpace;
import org.deeplearning4j.arbiter.optimize.api.ParameterSpace;
import org.deeplearning4j.arbiter.optimize.parameter.FixedValue;
import org.deeplearning4j.arbiter.util.LeafUtils;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;

public class SubsamplingLayerSpace
extends LayerSpace<SubsamplingLayer> {
    protected ParameterSpace<ConvolutionMode> convolutionMode;
    protected ParameterSpace<SubsamplingLayer.PoolingType> poolingType;
    protected ParameterSpace<int[]> dilation;
    protected ParameterSpace<int[]> kernelSize;
    protected ParameterSpace<int[]> stride;
    protected ParameterSpace<int[]> padding;
    protected ParameterSpace<Integer> pnorm;
    protected ParameterSpace<Double> eps;

    private SubsamplingLayerSpace(Builder builder) {
        super(builder);
        this.convolutionMode = builder.convolutionMode;
        this.poolingType = builder.poolingType;
        this.kernelSize = builder.kernelSize;
        this.dilation = builder.dilation;
        this.stride = builder.stride;
        this.padding = builder.padding;
        this.pnorm = builder.pnorm;
        this.eps = builder.eps;
        this.numParameters = LeafUtils.countUniqueParameters(this.collectLeaves());
    }

    public SubsamplingLayer getValue(double[] values) {
        SubsamplingLayer.Builder b = new SubsamplingLayer.Builder();
        this.setLayerOptionsBuilder(b, values);
        return b.build();
    }

    protected void setLayerOptionsBuilder(SubsamplingLayer.Builder builder, double[] values) {
        super.setLayerOptionsBuilder((Layer.Builder)builder, values);
        if (this.convolutionMode != null) {
            builder.convolutionMode((ConvolutionMode)this.convolutionMode.getValue(values));
        }
        if (this.poolingType != null) {
            builder.poolingType((SubsamplingLayer.PoolingType)this.poolingType.getValue(values));
        }
        if (this.dilation != null) {
            builder.dilation((int[])this.dilation.getValue(values));
        }
        if (this.kernelSize != null) {
            builder.kernelSize((int[])this.kernelSize.getValue(values));
        }
        if (this.stride != null) {
            builder.stride((int[])this.stride.getValue(values));
        }
        if (this.padding != null) {
            builder.padding((int[])this.padding.getValue(values));
        }
        if (this.pnorm != null) {
            builder.pnorm(((Integer)this.pnorm.getValue(values)).intValue());
        }
        if (this.eps != null) {
            builder.eps(((Double)this.eps.getValue(values)).doubleValue());
        }
    }

    @Override
    public String toString() {
        return this.toString(", ");
    }

    @Override
    public String toString(String delim) {
        StringBuilder sb = new StringBuilder("SubsamplingLayerSpace(");
        if (this.convolutionMode != null) {
            sb.append("convolutionMode: ").append(this.convolutionMode).append(delim);
        }
        if (this.poolingType != null) {
            sb.append("poolingType: ").append(this.poolingType).append(delim);
        }
        if (this.dilation != null) {
            sb.append("dilation: ").append(this.dilation).append(delim);
        }
        if (this.kernelSize != null) {
            sb.append("kernelSize: ").append(this.kernelSize).append(delim);
        }
        if (this.stride != null) {
            sb.append("stride: ").append(this.stride).append(delim);
        }
        if (this.padding != null) {
            sb.append("padding: ").append(this.padding).append(delim);
        }
        if (this.pnorm != null) {
            sb.append("pnorm: ").append(this.pnorm).append(delim);
        }
        if (this.eps != null) {
            sb.append("eps: ").append(this.eps).append(delim);
        }
        sb.append(super.toString(delim)).append(")");
        return sb.toString();
    }

    public ParameterSpace<ConvolutionMode> getConvolutionMode() {
        return this.convolutionMode;
    }

    public ParameterSpace<SubsamplingLayer.PoolingType> getPoolingType() {
        return this.poolingType;
    }

    public ParameterSpace<int[]> getDilation() {
        return this.dilation;
    }

    public ParameterSpace<int[]> getKernelSize() {
        return this.kernelSize;
    }

    public ParameterSpace<int[]> getStride() {
        return this.stride;
    }

    public ParameterSpace<int[]> getPadding() {
        return this.padding;
    }

    public ParameterSpace<Integer> getPnorm() {
        return this.pnorm;
    }

    public ParameterSpace<Double> getEps() {
        return this.eps;
    }

    public void setConvolutionMode(ParameterSpace<ConvolutionMode> convolutionMode) {
        this.convolutionMode = convolutionMode;
    }

    public void setPoolingType(ParameterSpace<SubsamplingLayer.PoolingType> poolingType) {
        this.poolingType = poolingType;
    }

    public void setDilation(ParameterSpace<int[]> dilation) {
        this.dilation = dilation;
    }

    public void setKernelSize(ParameterSpace<int[]> kernelSize) {
        this.kernelSize = kernelSize;
    }

    public void setStride(ParameterSpace<int[]> stride) {
        this.stride = stride;
    }

    public void setPadding(ParameterSpace<int[]> padding) {
        this.padding = padding;
    }

    public void setPnorm(ParameterSpace<Integer> pnorm) {
        this.pnorm = pnorm;
    }

    public void setEps(ParameterSpace<Double> eps) {
        this.eps = eps;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubsamplingLayerSpace)) {
            return false;
        }
        SubsamplingLayerSpace other = (SubsamplingLayerSpace)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ParameterSpace<ConvolutionMode> this$convolutionMode = this.getConvolutionMode();
        ParameterSpace<ConvolutionMode> other$convolutionMode = other.getConvolutionMode();
        if (this$convolutionMode == null ? other$convolutionMode != null : !this$convolutionMode.equals(other$convolutionMode)) {
            return false;
        }
        ParameterSpace<SubsamplingLayer.PoolingType> this$poolingType = this.getPoolingType();
        ParameterSpace<SubsamplingLayer.PoolingType> other$poolingType = other.getPoolingType();
        if (this$poolingType == null ? other$poolingType != null : !this$poolingType.equals(other$poolingType)) {
            return false;
        }
        ParameterSpace<int[]> this$dilation = this.getDilation();
        ParameterSpace<int[]> other$dilation = other.getDilation();
        if (this$dilation == null ? other$dilation != null : !this$dilation.equals(other$dilation)) {
            return false;
        }
        ParameterSpace<int[]> this$kernelSize = this.getKernelSize();
        ParameterSpace<int[]> other$kernelSize = other.getKernelSize();
        if (this$kernelSize == null ? other$kernelSize != null : !this$kernelSize.equals(other$kernelSize)) {
            return false;
        }
        ParameterSpace<int[]> this$stride = this.getStride();
        ParameterSpace<int[]> other$stride = other.getStride();
        if (this$stride == null ? other$stride != null : !this$stride.equals(other$stride)) {
            return false;
        }
        ParameterSpace<int[]> this$padding = this.getPadding();
        ParameterSpace<int[]> other$padding = other.getPadding();
        if (this$padding == null ? other$padding != null : !this$padding.equals(other$padding)) {
            return false;
        }
        ParameterSpace<Integer> this$pnorm = this.getPnorm();
        ParameterSpace<Integer> other$pnorm = other.getPnorm();
        if (this$pnorm == null ? other$pnorm != null : !this$pnorm.equals(other$pnorm)) {
            return false;
        }
        ParameterSpace<Double> this$eps = this.getEps();
        ParameterSpace<Double> other$eps = other.getEps();
        return !(this$eps == null ? other$eps != null : !this$eps.equals(other$eps));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SubsamplingLayerSpace;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ParameterSpace<ConvolutionMode> $convolutionMode = this.getConvolutionMode();
        result = result * 59 + ($convolutionMode == null ? 43 : $convolutionMode.hashCode());
        ParameterSpace<SubsamplingLayer.PoolingType> $poolingType = this.getPoolingType();
        result = result * 59 + ($poolingType == null ? 43 : $poolingType.hashCode());
        ParameterSpace<int[]> $dilation = this.getDilation();
        result = result * 59 + ($dilation == null ? 43 : $dilation.hashCode());
        ParameterSpace<int[]> $kernelSize = this.getKernelSize();
        result = result * 59 + ($kernelSize == null ? 43 : $kernelSize.hashCode());
        ParameterSpace<int[]> $stride = this.getStride();
        result = result * 59 + ($stride == null ? 43 : $stride.hashCode());
        ParameterSpace<int[]> $padding = this.getPadding();
        result = result * 59 + ($padding == null ? 43 : $padding.hashCode());
        ParameterSpace<Integer> $pnorm = this.getPnorm();
        result = result * 59 + ($pnorm == null ? 43 : $pnorm.hashCode());
        ParameterSpace<Double> $eps = this.getEps();
        result = result * 59 + ($eps == null ? 43 : $eps.hashCode());
        return result;
    }

    private SubsamplingLayerSpace() {
    }

    public static class Builder
    extends FeedForwardLayerSpace.Builder<Builder> {
        protected ParameterSpace<ConvolutionMode> convolutionMode;
        protected ParameterSpace<SubsamplingLayer.PoolingType> poolingType;
        protected ParameterSpace<int[]> dilation;
        protected ParameterSpace<int[]> kernelSize;
        protected ParameterSpace<int[]> stride;
        protected ParameterSpace<int[]> padding;
        protected ParameterSpace<Integer> pnorm;
        protected ParameterSpace<Double> eps;

        public Builder convolutionMode(ConvolutionMode convolutionMode) {
            return this.convolutionMode((ParameterSpace<ConvolutionMode>)new FixedValue((Object)convolutionMode));
        }

        public Builder convolutionMode(ParameterSpace<ConvolutionMode> convolutionMode) {
            this.convolutionMode = convolutionMode;
            return this;
        }

        public Builder poolingType(SubsamplingLayer.PoolingType poolingType) {
            return this.poolingType((ParameterSpace<SubsamplingLayer.PoolingType>)new FixedValue((Object)poolingType));
        }

        public Builder poolingType(ParameterSpace<SubsamplingLayer.PoolingType> poolingType) {
            this.poolingType = poolingType;
            return this;
        }

        public Builder dilation(int ... dilation) {
            return this.dilation((ParameterSpace<int[]>)new FixedValue((Object)dilation));
        }

        public Builder dilation(ParameterSpace<int[]> dilation) {
            this.dilation = dilation;
            return this;
        }

        public Builder kernelSize(int ... kernelSize) {
            return this.kernelSize((ParameterSpace<int[]>)new FixedValue((Object)kernelSize));
        }

        public Builder kernelSize(ParameterSpace<int[]> kernelSize) {
            this.kernelSize = kernelSize;
            return this;
        }

        public Builder stride(int ... stride) {
            return this.stride((ParameterSpace<int[]>)new FixedValue((Object)stride));
        }

        public Builder stride(ParameterSpace<int[]> stride) {
            this.stride = stride;
            return this;
        }

        public Builder padding(int ... padding) {
            return this.padding((ParameterSpace<int[]>)new FixedValue((Object)padding));
        }

        public Builder padding(ParameterSpace<int[]> padding) {
            this.padding = padding;
            return this;
        }

        public Builder pnorm(int pnorm) {
            return this.pnorm((ParameterSpace<Integer>)new FixedValue((Object)pnorm));
        }

        public Builder pnorm(ParameterSpace<Integer> pnorm) {
            this.pnorm = pnorm;
            return this;
        }

        public Builder eps(double eps) {
            return this.eps((ParameterSpace<Double>)new FixedValue((Object)eps));
        }

        public Builder eps(ParameterSpace<Double> eps) {
            this.eps = eps;
            return this;
        }

        @Override
        public SubsamplingLayerSpace build() {
            return new SubsamplingLayerSpace(this);
        }
    }
}

