/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.arbiter.scoring.impl;

import org.deeplearning4j.arbiter.scoring.impl.BaseNetScoreFunction;
import org.deeplearning4j.arbiter.scoring.util.ScoreUtil;
import org.deeplearning4j.nn.graph.ComputationGraph;
import org.deeplearning4j.nn.multilayer.MultiLayerNetwork;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.dataset.api.iterator.MultiDataSetIterator;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class TestSetLossScoreFunction
extends BaseNetScoreFunction {
    @JsonProperty
    private final boolean average;

    public TestSetLossScoreFunction() {
        this(true);
    }

    public TestSetLossScoreFunction(boolean average) {
        this.average = average;
    }

    public boolean minimize() {
        return true;
    }

    public String toString() {
        return "TestSetLossScoreFunction()";
    }

    @Override
    public double score(MultiLayerNetwork net, DataSetIterator iterator) {
        return ScoreUtil.score(net, iterator, this.average);
    }

    @Override
    public double score(MultiLayerNetwork net, MultiDataSetIterator iterator) {
        throw new UnsupportedOperationException("Cannot evaluate MultiLayerNetwork on MultiDataSetIterator");
    }

    @Override
    public double score(ComputationGraph graph, DataSetIterator iterator) {
        return ScoreUtil.score(graph, iterator, this.average);
    }

    @Override
    public double score(ComputationGraph graph, MultiDataSetIterator iterator) {
        return ScoreUtil.score(graph, iterator, this.average);
    }

    public boolean isAverage() {
        return this.average;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestSetLossScoreFunction)) {
            return false;
        }
        TestSetLossScoreFunction other = (TestSetLossScoreFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.isAverage() == other.isAverage();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TestSetLossScoreFunction;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAverage() ? 79 : 97);
        return result;
    }
}

