/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.dropout;

import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.SizeTPointer;
import org.bytedeco.javacpp.cuda;
import org.bytedeco.javacpp.cudnn;
import org.deeplearning4j.nn.conf.dropout.DropoutHelper;
import org.deeplearning4j.nn.layers.BaseCudnnHelper;
import org.nd4j.jita.allocator.impl.AtomicAllocator;
import org.nd4j.jita.conf.CudaEnvironment;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.jcublas.context.CudaContext;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CudnnDropoutHelper
extends BaseCudnnHelper
implements DropoutHelper {
    private static final Logger log = LoggerFactory.getLogger(CudnnDropoutHelper.class);
    private CudnnDropoutContext cudnnContext = new CudnnDropoutContext();
    private boolean initializedDescriptor = false;
    private BaseCudnnHelper.DataCache rngStates;
    private BaseCudnnHelper.DataCache mask;
    private SizeTPointer stateSizeBytesPtr;
    private SizeTPointer reserveSizeBytesPtr;
    private float lastInitializedP;

    public void applyDropout(INDArray input, INDArray resultArray, double dropoutInputRetainProb) {
        float p = (float)(1.0 - dropoutInputRetainProb);
        int[] inShape = CudnnDropoutHelper.adaptForTensorDescr(ArrayUtil.toInts((long[])input.shape()));
        int[] inStride = CudnnDropoutHelper.adaptForTensorDescr(ArrayUtil.toInts((long[])input.stride()));
        CudnnDropoutHelper.checkCudnn(cudnn.cudnnSetTensorNdDescriptor((cudnn.cudnnTensorStruct)this.cudnnContext.xTensorDesc, (int)this.dataType, (int)inShape.length, (int[])inShape, (int[])inStride));
        int[] outShape = CudnnDropoutHelper.adaptForTensorDescr(ArrayUtil.toInts((long[])resultArray.shape()));
        int[] outStride = CudnnDropoutHelper.adaptForTensorDescr(ArrayUtil.toInts((long[])resultArray.stride()));
        CudnnDropoutHelper.checkCudnn(cudnn.cudnnSetTensorNdDescriptor((cudnn.cudnnTensorStruct)this.cudnnContext.yTensorDesc, (int)this.dataType, (int)outShape.length, (int[])outShape, (int[])outStride));
        if (this.stateSizeBytesPtr == null) {
            this.stateSizeBytesPtr = new SizeTPointer(1L);
            this.reserveSizeBytesPtr = new SizeTPointer(1L);
        }
        CudnnDropoutHelper.checkCudnn(cudnn.cudnnDropoutGetStatesSize((cudnn.cudnnContext)this.cudnnContext, (SizeTPointer)this.stateSizeBytesPtr));
        long rngStateSizeBytes = this.stateSizeBytesPtr.get();
        CudnnDropoutHelper.checkCudnn(cudnn.cudnnDropoutGetReserveSpaceSize((cudnn.cudnnTensorStruct)this.cudnnContext.xTensorDesc, (SizeTPointer)this.reserveSizeBytesPtr));
        long maskReserveSizeBytes = this.reserveSizeBytesPtr.get();
        if (this.rngStates == null || this.rngStates.capacity() < rngStateSizeBytes) {
            if (log.isTraceEnabled()) {
                if (this.rngStates == null) {
                    log.trace("CudnnDropoutHelper: Allocating intial RNG states workspace of size {} ({})", (Object)rngStateSizeBytes, (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)rngStateSizeBytes, (String)"B", (int)2));
                } else {
                    log.trace("CudnnDropoutHelper: Deallocating RNG states of size {} ({}), allocating new workspace of size {} ({})", new Object[]{this.rngStates.capacity(), StringUtils.TraditionalBinaryPrefix.long2String((long)this.rngStates.capacity(), (String)"B", (int)2), rngStateSizeBytes, StringUtils.TraditionalBinaryPrefix.long2String((long)rngStateSizeBytes, (String)"B", (int)2)});
                }
            }
            if (this.rngStates != null) {
                this.rngStates.deallocate();
            }
            this.rngStates = new BaseCudnnHelper.DataCache(rngStateSizeBytes);
            this.initializedDescriptor = false;
        }
        if (this.mask == null || this.mask.capacity() < maskReserveSizeBytes) {
            if (log.isTraceEnabled()) {
                if (this.mask == null) {
                    log.trace("CudnnDropoutHelper: Allocating intial mask array of size {} ({})", (Object)maskReserveSizeBytes, (Object)StringUtils.TraditionalBinaryPrefix.long2String((long)maskReserveSizeBytes, (String)"B", (int)2));
                } else {
                    log.trace("CudnnDropoutHelper: Deallocating mask array of size {} ({}), allocating new mask array of size {} ({})", new Object[]{this.mask.capacity(), StringUtils.TraditionalBinaryPrefix.long2String((long)this.mask.capacity(), (String)"B", (int)2), maskReserveSizeBytes, StringUtils.TraditionalBinaryPrefix.long2String((long)maskReserveSizeBytes, (String)"B", (int)2)});
                }
            }
            if (this.mask != null) {
                this.mask.deallocate();
            }
            this.mask = new BaseCudnnHelper.DataCache(maskReserveSizeBytes);
        }
        if (!this.initializedDescriptor || p != this.lastInitializedP) {
            if (log.isTraceEnabled()) {
                log.trace("CudnnDropoutHelper: (re)initializing dropout descriptor");
            }
            long seed = Nd4j.getRandom().nextLong();
            this.lastInitializedP = p;
            CudnnDropoutHelper.checkCudnn(cudnn.cudnnSetDropoutDescriptor((cudnn.cudnnDropoutStruct)this.cudnnContext.dropoutDesc, (cudnn.cudnnContext)this.cudnnContext, (float)p, (Pointer)this.rngStates, (long)this.rngStates.capacity(), (long)seed));
            this.initializedDescriptor = true;
        }
        AtomicAllocator allocator = AtomicAllocator.getInstance();
        CudaContext context = allocator.getFlowController().prepareAction(input, new INDArray[]{resultArray});
        Pointer xPtr = allocator.getPointer(input, context);
        Pointer yPtr = allocator.getPointer(resultArray, context);
        CudnnDropoutHelper.checkCudnn(cudnn.cudnnSetStream((cudnn.cudnnContext)this.cudnnContext, (cuda.CUstream_st)new cuda.CUstream_st((Pointer)context.getOldStream())));
        CudnnDropoutHelper.checkCudnn(cudnn.cudnnDropoutForward((cudnn.cudnnContext)this.cudnnContext, (cudnn.cudnnDropoutStruct)this.cudnnContext.dropoutDesc, (cudnn.cudnnTensorStruct)this.cudnnContext.xTensorDesc, (Pointer)xPtr, (cudnn.cudnnTensorStruct)this.cudnnContext.yTensorDesc, (Pointer)yPtr, (Pointer)this.mask, (long)this.mask.capacity()));
        allocator.registerAction(context, input, new INDArray[]{resultArray});
        if (CudaEnvironment.getInstance().getConfiguration().isDebug()) {
            context.syncOldStream();
        }
    }

    public void backprop(INDArray gradAtOutput, INDArray gradAtInput) {
        int[] gradAtOutShape = CudnnDropoutHelper.adaptForTensorDescr(ArrayUtil.toInts((long[])gradAtOutput.shape()));
        int[] gradAtOutStride = CudnnDropoutHelper.adaptForTensorDescr(ArrayUtil.toInts((long[])gradAtOutput.stride()));
        CudnnDropoutHelper.checkCudnn(cudnn.cudnnSetTensorNdDescriptor((cudnn.cudnnTensorStruct)this.cudnnContext.dyTensorDesc, (int)this.dataType, (int)gradAtOutShape.length, (int[])gradAtOutShape, (int[])gradAtOutStride));
        int[] gradAtInShape = CudnnDropoutHelper.adaptForTensorDescr(ArrayUtil.toInts((long[])gradAtInput.shape()));
        int[] gradAtInStride = CudnnDropoutHelper.adaptForTensorDescr(ArrayUtil.toInts((long[])gradAtInput.stride()));
        CudnnDropoutHelper.checkCudnn(cudnn.cudnnSetTensorNdDescriptor((cudnn.cudnnTensorStruct)this.cudnnContext.dxTensorDesc, (int)this.dataType, (int)gradAtInShape.length, (int[])gradAtInShape, (int[])gradAtInStride));
        AtomicAllocator allocator = AtomicAllocator.getInstance();
        CudaContext context = allocator.getFlowController().prepareAction(gradAtOutput, new INDArray[]{gradAtInput});
        Pointer dyPtr = allocator.getPointer(gradAtOutput, context);
        Pointer dxPtr = allocator.getPointer(gradAtInput, context);
        CudnnDropoutHelper.checkCudnn(cudnn.cudnnDropoutBackward((cudnn.cudnnContext)this.cudnnContext, (cudnn.cudnnDropoutStruct)this.cudnnContext.dropoutDesc, (cudnn.cudnnTensorStruct)this.cudnnContext.dyTensorDesc, (Pointer)dyPtr, (cudnn.cudnnTensorStruct)this.cudnnContext.dxTensorDesc, (Pointer)dxPtr, (Pointer)this.mask, (long)this.mask.capacity()));
        allocator.registerAction(context, gradAtOutput, new INDArray[]{gradAtInput});
        if (CudaEnvironment.getInstance().getConfiguration().isDebug()) {
            context.syncOldStream();
        }
    }

    public CudnnDropoutContext getCudnnContext() {
        return this.cudnnContext;
    }

    public boolean isInitializedDescriptor() {
        return this.initializedDescriptor;
    }

    public BaseCudnnHelper.DataCache getRngStates() {
        return this.rngStates;
    }

    public BaseCudnnHelper.DataCache getMask() {
        return this.mask;
    }

    public SizeTPointer getStateSizeBytesPtr() {
        return this.stateSizeBytesPtr;
    }

    public SizeTPointer getReserveSizeBytesPtr() {
        return this.reserveSizeBytesPtr;
    }

    public float getLastInitializedP() {
        return this.lastInitializedP;
    }

    public void setCudnnContext(CudnnDropoutContext cudnnContext2) {
        this.cudnnContext = cudnnContext2;
    }

    public void setInitializedDescriptor(boolean initializedDescriptor) {
        this.initializedDescriptor = initializedDescriptor;
    }

    public void setRngStates(BaseCudnnHelper.DataCache rngStates) {
        this.rngStates = rngStates;
    }

    public void setMask(BaseCudnnHelper.DataCache mask) {
        this.mask = mask;
    }

    public void setStateSizeBytesPtr(SizeTPointer stateSizeBytesPtr) {
        this.stateSizeBytesPtr = stateSizeBytesPtr;
    }

    public void setReserveSizeBytesPtr(SizeTPointer reserveSizeBytesPtr) {
        this.reserveSizeBytesPtr = reserveSizeBytesPtr;
    }

    public void setLastInitializedP(float lastInitializedP) {
        this.lastInitializedP = lastInitializedP;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CudnnDropoutHelper)) {
            return false;
        }
        CudnnDropoutHelper other = (CudnnDropoutHelper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CudnnDropoutContext this$cudnnContext = this.getCudnnContext();
        CudnnDropoutContext other$cudnnContext = other.getCudnnContext();
        if (this$cudnnContext == null ? other$cudnnContext != null : !((Object)((Object)this$cudnnContext)).equals((Object)other$cudnnContext)) {
            return false;
        }
        if (this.isInitializedDescriptor() != other.isInitializedDescriptor()) {
            return false;
        }
        BaseCudnnHelper.DataCache this$rngStates = this.getRngStates();
        BaseCudnnHelper.DataCache other$rngStates = other.getRngStates();
        if (this$rngStates == null ? other$rngStates != null : !((Object)((Object)this$rngStates)).equals((Object)other$rngStates)) {
            return false;
        }
        BaseCudnnHelper.DataCache this$mask = this.getMask();
        BaseCudnnHelper.DataCache other$mask = other.getMask();
        if (this$mask == null ? other$mask != null : !((Object)((Object)this$mask)).equals((Object)other$mask)) {
            return false;
        }
        SizeTPointer this$stateSizeBytesPtr = this.getStateSizeBytesPtr();
        SizeTPointer other$stateSizeBytesPtr = other.getStateSizeBytesPtr();
        if (this$stateSizeBytesPtr == null ? other$stateSizeBytesPtr != null : !this$stateSizeBytesPtr.equals(other$stateSizeBytesPtr)) {
            return false;
        }
        SizeTPointer this$reserveSizeBytesPtr = this.getReserveSizeBytesPtr();
        SizeTPointer other$reserveSizeBytesPtr = other.getReserveSizeBytesPtr();
        if (this$reserveSizeBytesPtr == null ? other$reserveSizeBytesPtr != null : !this$reserveSizeBytesPtr.equals(other$reserveSizeBytesPtr)) {
            return false;
        }
        return Float.compare(this.getLastInitializedP(), other.getLastInitializedP()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof CudnnDropoutHelper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CudnnDropoutContext $cudnnContext = this.getCudnnContext();
        result = result * 59 + ($cudnnContext == null ? 43 : ((Object)((Object)$cudnnContext)).hashCode());
        result = result * 59 + (this.isInitializedDescriptor() ? 79 : 97);
        BaseCudnnHelper.DataCache $rngStates = this.getRngStates();
        result = result * 59 + ($rngStates == null ? 43 : ((Object)((Object)$rngStates)).hashCode());
        BaseCudnnHelper.DataCache $mask = this.getMask();
        result = result * 59 + ($mask == null ? 43 : ((Object)((Object)$mask)).hashCode());
        SizeTPointer $stateSizeBytesPtr = this.getStateSizeBytesPtr();
        result = result * 59 + ($stateSizeBytesPtr == null ? 43 : $stateSizeBytesPtr.hashCode());
        SizeTPointer $reserveSizeBytesPtr = this.getReserveSizeBytesPtr();
        result = result * 59 + ($reserveSizeBytesPtr == null ? 43 : $reserveSizeBytesPtr.hashCode());
        result = result * 59 + Float.floatToIntBits(this.getLastInitializedP());
        return result;
    }

    public String toString() {
        return "CudnnDropoutHelper(cudnnContext=" + (Object)((Object)this.getCudnnContext()) + ", initializedDescriptor=" + this.isInitializedDescriptor() + ", rngStates=" + (Object)((Object)this.getRngStates()) + ", mask=" + (Object)((Object)this.getMask()) + ", stateSizeBytesPtr=" + this.getStateSizeBytesPtr() + ", reserveSizeBytesPtr=" + this.getReserveSizeBytesPtr() + ", lastInitializedP=" + this.getLastInitializedP() + ")";
    }

    private static class CudnnDropoutContext
    extends BaseCudnnHelper.CudnnContext {
        private cudnn.cudnnTensorStruct xTensorDesc = new cudnn.cudnnTensorStruct();
        private cudnn.cudnnTensorStruct dxTensorDesc = new cudnn.cudnnTensorStruct();
        private cudnn.cudnnTensorStruct yTensorDesc = new cudnn.cudnnTensorStruct();
        private cudnn.cudnnTensorStruct dyTensorDesc = new cudnn.cudnnTensorStruct();
        private cudnn.cudnnDropoutStruct dropoutDesc = new cudnn.cudnnDropoutStruct();

        public CudnnDropoutContext() {
            this.createHandles();
            this.deallocator(new Deallocator(this));
        }

        public CudnnDropoutContext(CudnnDropoutContext c) {
            super(c);
            this.xTensorDesc = new cudnn.cudnnTensorStruct((Pointer)c.xTensorDesc);
            this.dxTensorDesc = new cudnn.cudnnTensorStruct((Pointer)c.dxTensorDesc);
            this.yTensorDesc = new cudnn.cudnnTensorStruct((Pointer)c.yTensorDesc);
            this.dyTensorDesc = new cudnn.cudnnTensorStruct((Pointer)c.dyTensorDesc);
            this.dropoutDesc = new cudnn.cudnnDropoutStruct((Pointer)c.dropoutDesc);
        }

        @Override
        protected void createHandles() {
            super.createHandles();
            CudnnDropoutHelper.checkCudnn(cudnn.cudnnCreateTensorDescriptor((cudnn.cudnnTensorStruct)this.xTensorDesc));
            CudnnDropoutHelper.checkCudnn(cudnn.cudnnCreateTensorDescriptor((cudnn.cudnnTensorStruct)this.dxTensorDesc));
            CudnnDropoutHelper.checkCudnn(cudnn.cudnnCreateTensorDescriptor((cudnn.cudnnTensorStruct)this.yTensorDesc));
            CudnnDropoutHelper.checkCudnn(cudnn.cudnnCreateTensorDescriptor((cudnn.cudnnTensorStruct)this.dyTensorDesc));
            CudnnDropoutHelper.checkCudnn(cudnn.cudnnCreateDropoutDescriptor((cudnn.cudnnDropoutStruct)this.dropoutDesc));
        }

        @Override
        protected void destroyHandles() {
            CudnnDropoutHelper.checkCudnn(cudnn.cudnnDestroyTensorDescriptor((cudnn.cudnnTensorStruct)this.xTensorDesc));
            CudnnDropoutHelper.checkCudnn(cudnn.cudnnDestroyTensorDescriptor((cudnn.cudnnTensorStruct)this.dxTensorDesc));
            CudnnDropoutHelper.checkCudnn(cudnn.cudnnDestroyTensorDescriptor((cudnn.cudnnTensorStruct)this.yTensorDesc));
            CudnnDropoutHelper.checkCudnn(cudnn.cudnnDestroyTensorDescriptor((cudnn.cudnnTensorStruct)this.dyTensorDesc));
            CudnnDropoutHelper.checkCudnn(cudnn.cudnnDestroyDropoutDescriptor((cudnn.cudnnDropoutStruct)this.dropoutDesc));
            super.destroyHandles();
        }

        private static class Deallocator
        extends CudnnDropoutContext
        implements Pointer.Deallocator {
            Deallocator(CudnnDropoutContext c) {
                super(c);
            }

            public void deallocate() {
                this.destroyHandles();
            }
        }
    }
}

