/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.layers.normalization;

import java.util.Collections;
import java.util.Map;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.cuda;
import org.bytedeco.javacpp.cudnn;
import org.deeplearning4j.nn.gradient.DefaultGradient;
import org.deeplearning4j.nn.gradient.Gradient;
import org.deeplearning4j.nn.layers.BaseCudnnHelper;
import org.deeplearning4j.nn.layers.normalization.LocalResponseNormalizationHelper;
import org.deeplearning4j.nn.workspace.ArrayType;
import org.deeplearning4j.nn.workspace.LayerWorkspaceMgr;
import org.nd4j.jita.allocator.impl.AtomicAllocator;
import org.nd4j.jita.conf.CudaEnvironment;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.executioner.GridExecutioner;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.jcublas.context.CudaContext;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.linalg.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CudnnLocalResponseNormalizationHelper
extends BaseCudnnHelper
implements LocalResponseNormalizationHelper {
    private static final Logger log = LoggerFactory.getLogger(CudnnLocalResponseNormalizationHelper.class);
    private CudnnLocalResponseNormalizationContext cudnnContext = new CudnnLocalResponseNormalizationContext();
    private INDArray activations = null;

    public boolean checkSupported(double k, double n, double alpha, double beta) {
        boolean supported = this.checkSupported();
        if (n < 1.0) {
            supported = false;
            log.warn("Not supported: n < CUDNN_LRN_MIN_N (" + n + " < " + 1 + ")");
        }
        if (n > 16.0) {
            supported = false;
            log.warn("Not supported: n > CUDNN_LRN_MAX_N (" + n + " > " + 16 + ")");
        }
        if (k < 1.0E-5) {
            supported = false;
            log.warn("Not supported: k < CUDNN_LRN_MIN_K (" + k + " < " + 1.0E-5 + ")");
        }
        if (beta < 0.01) {
            supported = false;
            log.warn("Not supported: beta < CUDNN_LRN_MIN_BETA (" + beta + " < " + 0.01 + ")");
        }
        return supported;
    }

    public Pair<Gradient, INDArray> backpropGradient(INDArray input, INDArray epsilon, double k, double n, double alpha, double beta, LayerWorkspaceMgr workspaceMgr) {
        int miniBatch = (int)input.size(0);
        int depth = (int)input.size(1);
        int inH = (int)input.size(2);
        int inW = (int)input.size(3);
        DefaultGradient retGradient = new DefaultGradient();
        if (!Shape.hasDefaultStridesForShape((INDArray)epsilon)) {
            epsilon = epsilon.dup('c');
        }
        int[] srcStride = ArrayUtil.toInts((long[])input.stride());
        int[] deltaStride = ArrayUtil.toInts((long[])epsilon.stride());
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudnnLocalResponseNormalizationHelper.checkCudnn(cudnn.cudnnSetTensor4dDescriptorEx((cudnn.cudnnTensorStruct)this.cudnnContext.srcTensorDesc, (int)this.dataType, (int)miniBatch, (int)depth, (int)inH, (int)inW, (int)srcStride[0], (int)srcStride[1], (int)srcStride[2], (int)srcStride[3]));
        CudnnLocalResponseNormalizationHelper.checkCudnn(cudnn.cudnnSetTensor4dDescriptorEx((cudnn.cudnnTensorStruct)this.cudnnContext.deltaTensorDesc, (int)this.dataType, (int)miniBatch, (int)depth, (int)inH, (int)inW, (int)deltaStride[0], (int)deltaStride[1], (int)deltaStride[2], (int)deltaStride[3]));
        CudnnLocalResponseNormalizationHelper.checkCudnn(cudnn.cudnnSetLRNDescriptor((cudnn.cudnnLRNStruct)this.cudnnContext.lrnDesc, (int)((int)n), (double)alpha, (double)beta, (double)k));
        INDArray nextEpsilon = workspaceMgr.createUninitialized((Enum)ArrayType.ACTIVATION_GRAD, new int[]{miniBatch, depth, inH, inW}, 'c');
        int[] dstStride = ArrayUtil.toInts((long[])nextEpsilon.stride());
        CudnnLocalResponseNormalizationHelper.checkCudnn(cudnn.cudnnSetTensor4dDescriptorEx((cudnn.cudnnTensorStruct)this.cudnnContext.dstTensorDesc, (int)this.dataType, (int)miniBatch, (int)depth, (int)inH, (int)inW, (int)dstStride[0], (int)dstStride[1], (int)dstStride[2], (int)dstStride[3]));
        AtomicAllocator allocator = AtomicAllocator.getInstance();
        CudaContext context = allocator.getFlowController().prepareActionAllWrite(new INDArray[]{input, epsilon, this.activations, nextEpsilon});
        Pointer srcData = allocator.getPointer(input, context);
        Pointer epsData = allocator.getPointer(epsilon, context);
        Pointer zData = allocator.getPointer(this.activations, context);
        Pointer dstData = allocator.getPointer(nextEpsilon, context);
        CudnnLocalResponseNormalizationHelper.checkCudnn(cudnn.cudnnSetStream((cudnn.cudnnContext)this.cudnnContext, (cuda.CUstream_st)new cuda.CUstream_st((Pointer)context.getOldStream())));
        CudnnLocalResponseNormalizationHelper.checkCudnn(cudnn.cudnnLRNCrossChannelBackward((cudnn.cudnnContext)this.cudnnContext, (cudnn.cudnnLRNStruct)this.cudnnContext.lrnDesc, (int)0, (Pointer)this.alpha, (cudnn.cudnnTensorStruct)this.cudnnContext.deltaTensorDesc, (Pointer)zData, (cudnn.cudnnTensorStruct)this.cudnnContext.deltaTensorDesc, (Pointer)epsData, (cudnn.cudnnTensorStruct)this.cudnnContext.srcTensorDesc, (Pointer)srcData, (Pointer)this.beta, (cudnn.cudnnTensorStruct)this.cudnnContext.dstTensorDesc, (Pointer)dstData));
        allocator.getFlowController().registerActionAllWrite(context, new INDArray[]{input, epsilon, this.activations, nextEpsilon});
        if (CudaEnvironment.getInstance().getConfiguration().isDebug()) {
            context.syncOldStream();
        }
        return new Pair((Object)retGradient, (Object)nextEpsilon);
    }

    public INDArray activate(INDArray input, boolean training, double k, double n, double alpha, double beta, LayerWorkspaceMgr workspaceMgr) {
        int miniBatch = (int)input.size(0);
        int inDepth = (int)input.size(1);
        int inH = (int)input.size(2);
        int inW = (int)input.size(3);
        if (!Shape.hasDefaultStridesForShape((INDArray)input)) {
            input = input.dup('c');
        }
        int[] srcStride = ArrayUtil.toInts((long[])input.stride());
        CudnnLocalResponseNormalizationHelper.checkCudnn(cudnn.cudnnSetTensor4dDescriptorEx((cudnn.cudnnTensorStruct)this.cudnnContext.srcTensorDesc, (int)this.dataType, (int)miniBatch, (int)inDepth, (int)inH, (int)inW, (int)srcStride[0], (int)srcStride[1], (int)srcStride[2], (int)srcStride[3]));
        this.activations = workspaceMgr.createUninitialized((Enum)ArrayType.ACTIVATIONS, new int[]{miniBatch, inDepth, inH, inW}, 'c');
        int[] dstStride = ArrayUtil.toInts((long[])this.activations.stride());
        CudnnLocalResponseNormalizationHelper.checkCudnn(cudnn.cudnnSetTensor4dDescriptorEx((cudnn.cudnnTensorStruct)this.cudnnContext.dstTensorDesc, (int)this.dataType, (int)miniBatch, (int)inDepth, (int)inH, (int)inW, (int)dstStride[0], (int)dstStride[1], (int)dstStride[2], (int)dstStride[3]));
        CudnnLocalResponseNormalizationHelper.checkCudnn(cudnn.cudnnSetLRNDescriptor((cudnn.cudnnLRNStruct)this.cudnnContext.lrnDesc, (int)((int)n), (double)alpha, (double)beta, (double)k));
        AtomicAllocator allocator = AtomicAllocator.getInstance();
        CudaContext context = allocator.getFlowController().prepareActionAllWrite(new INDArray[]{input, this.activations});
        Pointer srcData = allocator.getPointer(input, context);
        Pointer dstData = allocator.getPointer(this.activations, context);
        if (Nd4j.getExecutioner() instanceof GridExecutioner) {
            ((GridExecutioner)Nd4j.getExecutioner()).flushQueue();
        }
        CudnnLocalResponseNormalizationHelper.checkCudnn(cudnn.cudnnSetStream((cudnn.cudnnContext)this.cudnnContext, (cuda.CUstream_st)new cuda.CUstream_st((Pointer)context.getOldStream())));
        CudnnLocalResponseNormalizationHelper.checkCudnn(cudnn.cudnnLRNCrossChannelForward((cudnn.cudnnContext)this.cudnnContext, (cudnn.cudnnLRNStruct)this.cudnnContext.lrnDesc, (int)0, (Pointer)this.alpha, (cudnn.cudnnTensorStruct)this.cudnnContext.srcTensorDesc, (Pointer)srcData, (Pointer)this.beta, (cudnn.cudnnTensorStruct)this.cudnnContext.dstTensorDesc, (Pointer)dstData));
        allocator.getFlowController().registerActionAllWrite(context, new INDArray[]{input, this.activations});
        if (CudaEnvironment.getInstance().getConfiguration().isDebug()) {
            context.syncOldStream();
        }
        return this.activations;
    }

    public Map<String, Long> helperMemoryUse() {
        return Collections.emptyMap();
    }

    private static class CudnnLocalResponseNormalizationContext
    extends BaseCudnnHelper.CudnnContext {
        private cudnn.cudnnTensorStruct srcTensorDesc = new cudnn.cudnnTensorStruct();
        private cudnn.cudnnTensorStruct dstTensorDesc = new cudnn.cudnnTensorStruct();
        private cudnn.cudnnTensorStruct deltaTensorDesc = new cudnn.cudnnTensorStruct();
        private cudnn.cudnnLRNStruct lrnDesc = new cudnn.cudnnLRNStruct();

        public CudnnLocalResponseNormalizationContext() {
            this.createHandles();
            this.deallocator(new Deallocator(this));
        }

        public CudnnLocalResponseNormalizationContext(CudnnLocalResponseNormalizationContext c) {
            super(c);
            this.srcTensorDesc = new cudnn.cudnnTensorStruct((Pointer)c.srcTensorDesc);
            this.dstTensorDesc = new cudnn.cudnnTensorStruct((Pointer)c.dstTensorDesc);
            this.deltaTensorDesc = new cudnn.cudnnTensorStruct((Pointer)c.deltaTensorDesc);
            this.lrnDesc = new cudnn.cudnnLRNStruct((Pointer)c.lrnDesc);
        }

        @Override
        protected void createHandles() {
            super.createHandles();
            CudnnLocalResponseNormalizationHelper.checkCudnn(cudnn.cudnnCreateTensorDescriptor((cudnn.cudnnTensorStruct)this.srcTensorDesc));
            CudnnLocalResponseNormalizationHelper.checkCudnn(cudnn.cudnnCreateTensorDescriptor((cudnn.cudnnTensorStruct)this.dstTensorDesc));
            CudnnLocalResponseNormalizationHelper.checkCudnn(cudnn.cudnnCreateTensorDescriptor((cudnn.cudnnTensorStruct)this.deltaTensorDesc));
            CudnnLocalResponseNormalizationHelper.checkCudnn(cudnn.cudnnCreateLRNDescriptor((cudnn.cudnnLRNStruct)this.lrnDesc));
        }

        @Override
        protected void destroyHandles() {
            CudnnLocalResponseNormalizationHelper.checkCudnn(cudnn.cudnnDestroyLRNDescriptor((cudnn.cudnnLRNStruct)this.lrnDesc));
            CudnnLocalResponseNormalizationHelper.checkCudnn(cudnn.cudnnDestroyTensorDescriptor((cudnn.cudnnTensorStruct)this.srcTensorDesc));
            CudnnLocalResponseNormalizationHelper.checkCudnn(cudnn.cudnnDestroyTensorDescriptor((cudnn.cudnnTensorStruct)this.dstTensorDesc));
            CudnnLocalResponseNormalizationHelper.checkCudnn(cudnn.cudnnDestroyTensorDescriptor((cudnn.cudnnTensorStruct)this.deltaTensorDesc));
            super.destroyHandles();
        }

        private static class Deallocator
        extends CudnnLocalResponseNormalizationContext
        implements Pointer.Deallocator {
            Deallocator(CudnnLocalResponseNormalizationContext c) {
                super(c);
            }

            public void deallocate() {
                this.destroyHandles();
            }
        }
    }
}

